/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.rewrite.CollectPowers;
import org.lsmp.djep.rewrite.ExpandBrackets;
import org.lsmp.djep.rewrite.RewriteRuleI;
import org.lsmp.djep.rewrite.RewriteVisitor;
import org.lsmp.djepJUnit.DJepTest;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class RewriteTest
extends DJepTest {
    DJep j;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$org$lsmp$djepJUnit$RewriteTest;

    public RewriteTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$RewriteTest == null ? (class$org$lsmp$djepJUnit$RewriteTest = RewriteTest.class$("org.lsmp.djepJUnit.RewriteTest")) : class$org$lsmp$djepJUnit$RewriteTest);
        testSuite.run(new TestResult());
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$RewriteTest == null ? (class$org$lsmp$djepJUnit$RewriteTest = RewriteTest.class$("org.lsmp.djepJUnit.RewriteTest")) : class$org$lsmp$djepJUnit$RewriteTest);
    }

    public void testRewrite() throws Exception {
        DJep dJep = new DJep();
        dJep.addStandardFunctions();
        dJep.addStandardConstants();
        dJep.setImplicitMul(true);
        dJep.addComplex();
        dJep.setAllowUndeclared(true);
        dJep.setAllowAssignment(true);
        dJep.addStandardDiffRules();
        dJep.getPrintVisitor().setMaxLen(80);
        dJep.addVariable("x", 0.0);
        RewriteVisitor rewriteVisitor = new RewriteVisitor();
        ExpandBrackets expandBrackets = new ExpandBrackets(dJep);
        CollectPowers collectPowers = new CollectPowers(dJep);
        RewriteRuleI[] rewriteRuleIArray = new RewriteRuleI[]{expandBrackets, collectPowers};
        String[] stringArray = new String[]{"x*x", "x*x^2", "x^2*x"};
        for (int i = 0; i < stringArray.length; ++i) {
            Node node = dJep.parse(stringArray[i]);
            System.out.print("Eqn:\t");
            dJep.println(node);
            Node node2 = rewriteVisitor.rewrite(node, dJep, rewriteRuleIArray, true);
            System.out.print("Expand:\t");
            dJep.println(node2);
        }
    }

    public void testTaylor() throws Exception {
        Node node;
        DJep dJep = new DJep();
        dJep.addStandardFunctions();
        dJep.addStandardConstants();
        dJep.setAllowUndeclared(true);
        dJep.setAllowAssignment(true);
        dJep.setImplicitMul(true);
        dJep.addComplex();
        dJep.addStandardDiffRules();
        dJep.getPrintVisitor().setMaxLen(80);
        dJep.addVariable("x", 0.0);
        RewriteVisitor rewriteVisitor = new RewriteVisitor();
        ExpandBrackets expandBrackets = new ExpandBrackets(dJep);
        CollectPowers collectPowers = new CollectPowers(dJep);
        RewriteRuleI[] rewriteRuleIArray = new RewriteRuleI[]{expandBrackets, collectPowers};
        Node node2 = node = dJep.parse("ln(1+x)");
        for (int i = 1; i < 5; ++i) {
            Node node3 = dJep.differentiate(node2, "x");
            System.out.println("Deriv " + i);
            dJep.println(node3);
            Node node4 = dJep.simplify(node3);
            System.out.println("Simp ");
            dJep.println(node4);
            Node node5 = rewriteVisitor.rewrite(node4, dJep, rewriteRuleIArray, true);
            System.out.println("Expand ");
            dJep.println(node5);
            node2 = node4;
        }
    }

    public void testMemory() throws Exception {
        DJep dJep = new DJep();
        dJep.addStandardFunctions();
        dJep.addStandardConstants();
        dJep.setAllowUndeclared(true);
        dJep.setAllowAssignment(true);
        dJep.setImplicitMul(true);
        dJep.addComplex();
        dJep.addStandardDiffRules();
        dJep.addVariable("x", 0.0);
    }

    public void testBad() throws ParseException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

