/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class RpTest
extends TestCase {
    JEP j;
    public static final boolean SHOW_BAD = false;
    String[][] matStrs = new String[10][10];
    String[] vecStrs = new String[10];
    boolean TESTALL = false;
    static /* synthetic */ Class class$org$lsmp$djepJUnit$RpTest;

    public RpTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$RpTest == null ? (class$org$lsmp$djepJUnit$RpTest = RpTest.class$("org.lsmp.djepJUnit.RpTest")) : class$org$lsmp$djepJUnit$RpTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new JEP();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$RpTest == null ? (class$org$lsmp$djepJUnit$RpTest = RpTest.class$("org.lsmp.djepJUnit.RpTest")) : class$org$lsmp$djepJUnit$RpTest);
    }

    public void testGood() {
        RpTest.assertEquals((int)1, (int)1);
    }

    public void myAssertEquals(String string, String string2, String string3) {
        if (!string2.equals(string3)) {
            System.out.println("Error \"" + string + "\" is \n<" + string2 + "> should be \n<" + string3 + ">");
        }
        RpTest.assertEquals((String)("<" + string + ">"), (Object)string3, (Object)string2);
        System.out.println("Success: Value of <" + string + "> is <" + string2 + ">");
    }

    public void valueTest(String string, double d) throws ParseException, Exception {
        this.valueTest(string, new Double(d));
    }

    public void valueTest(String string, Object object) throws ParseException, Exception {
        Node node = this.j.parse(string);
        Object object2 = this.j.evaluate(node);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + string + this.j.getErrorInfo()));
        }
        RpTest.assertEquals((String)("<" + string + ">"), (Object)object, (Object)object2);
        System.out.println("Sucess value of <" + string + "> is " + object2);
    }

    public void valueTest(String string, String string2) throws ParseException, Exception {
        Node node = this.j.parse(string);
        Object object = this.j.evaluate(node);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + string + this.j.getErrorInfo()));
        }
        RpTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)object.toString());
        System.out.println("Sucess value of <" + string + "> is " + object.toString());
    }

    public void complexValueTest(String string, Complex complex, double d) throws Exception {
        Node node = this.j.parse(string);
        Object object = this.j.evaluate(node);
        RpTest.assertTrue((String)("<" + string + "> expected: <" + complex + "> but was <" + object + ">"), (boolean)complex.equals((Complex)object, d));
        System.out.println("Sucess value of <" + string + "> is " + object);
    }

    public Object calcValue(String string) throws ParseException, Exception {
        Node node = this.j.parse(string);
        Object object = this.j.evaluate(node);
        return object;
    }

    void rpTest(String[] stringArray, String string) throws ParseException, Exception {
        Object object;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("eqns " + stringArray[i]);
            object = this.j.parse(stringArray[i]);
            this.j.evaluate((Node)object);
        }
        Node node = this.j.parse(string);
        object = new RpEval(this.j);
        RpCommandList rpCommandList = ((RpEval)object).compile(node);
        double d = ((RpEval)object).evaluate(rpCommandList);
        Object object2 = this.j.evaluate(node);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + string + this.j.getErrorInfo()));
        }
        this.myAssertEquals("<" + string + ">", "" + d, object2.toString());
        if (!object2.equals(new Double(d))) {
            RpTest.fail((String)("Expected <" + object2 + "> found <" + d + ">"));
        }
    }

    void rpTest2(String[] stringArray) throws ParseException, Exception {
        Object object;
        int n;
        Node[] nodeArray = new Node[stringArray.length];
        double[] dArray = new double[stringArray.length];
        RpEval rpEval = new RpEval(this.j);
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println("eqns " + stringArray[n]);
            nodeArray[n] = this.j.parse(stringArray[n]);
            object = rpEval.compile(nodeArray[n]);
            dArray[n] = rpEval.evaluate((RpCommandList)object);
            System.out.println("<" + stringArray[n] + "> " + dArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = this.j.evaluate(nodeArray[n]);
            if (object.equals(new Double(dArray[n]))) continue;
            RpTest.fail((String)("Expected <" + object + "> found <" + dArray[n] + ">"));
        }
        rpEval.cleanUp();
    }

    public void testRp() throws ParseException, Exception {
        this.rpTest(new String[0], "1*2*3+4*5*6+7*8*9");
        this.rpTest(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
    }

    public void testAssign() throws ParseException, Exception {
        this.rpTest2(new String[]{"x=5", "x+x"});
        this.j.setVarValue("x", new Double(6.0));
        this.rpTest2(new String[]{"x+x"});
    }

    public void testLogical() throws ParseException, Exception {
        this.rpTest2(new String[]{"1&&1", "1&&0", "0&&0", "0&&1", "3.14&&1"});
        this.rpTest2(new String[]{"1||1", "1||0", "0||0", "0||1", "3.14||0"});
        this.rpTest2(new String[]{"!0", "!1", "!3.14", "!-3.14"});
        this.rpTest2(new String[]{"1>1", "1>0", "0>0", "0>1", "3.14>1"});
        this.rpTest2(new String[]{"1<1", "1<0", "0<0", "0<1", "3.14<1"});
        this.rpTest2(new String[]{"1>=1", "1>=0", "0>=0", "0>=1", "3.14>=1"});
        this.rpTest2(new String[]{"1<=1", "1<=0", "0<=0", "0<=1", "3.14<=1"});
        this.rpTest2(new String[]{"1==1", "1==0", "0==0", "0==1", "3.14==1"});
        this.rpTest2(new String[]{"1!=1", "1!=0", "0!=0", "0!=1", "3.14!=1"});
    }

    public void testFun() throws ParseException, Exception {
        this.rpTest2(new String[]{"x=5", "y=4", "x/y", "x%y", "x^y"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)", "sin(x)", "tan(x)", "asin(x)", "acos(x)", "atan(x)"});
        this.rpTest2(new String[]{"x=0.5", "cosh(x)", "sinh(x)", "tanh(x)", "asinh(x)", "acosh(x+1)", "atanh(x)"});
        this.rpTest2(new String[]{"x=0.5", "sqrt(x)", "ln(x)", "log(x)", "exp(x)", "abs(x)"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)^2+sin(x)^2"});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

