/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class SJepTest
extends TestCase {
    DJep j;
    PolynomialCreator pc;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$org$lsmp$djepJUnit$SJepTest;

    public SJepTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$SJepTest == null ? (class$org$lsmp$djepJUnit$SJepTest = SJepTest.class$("org.lsmp.djepJUnit.SJepTest")) : class$org$lsmp$djepJUnit$SJepTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.addStandardDiffRules();
        this.pc = new PolynomialCreator(this.j);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$SJepTest == null ? (class$org$lsmp$djepJUnit$SJepTest = SJepTest.class$("org.lsmp.djepJUnit.SJepTest")) : class$org$lsmp$djepJUnit$SJepTest);
    }

    public void myAssertEquals(String string, String string2, String string3) {
        if (!string2.equals(string3)) {
            System.out.println("Error \"" + string + "\" is \"" + string2 + " should be " + string3 + "\"");
        }
        SJepTest.assertEquals((String)("<" + string + ">"), (Object)string3, (Object)string2);
        System.out.println("Success: Value of \"" + string + "\" is \"" + string2 + "\"");
    }

    public void assertPolynomialEquals(String string, String string2) throws ParseException {
        Node node;
        PNodeI pNodeI;
        PNodeI pNodeI2;
        Node node2 = this.j.parse(string);
        PNodeI pNodeI3 = this.pc.createPoly(node2);
        PNodeI pNodeI4 = pNodeI3.expand();
        if (pNodeI4.equals(pNodeI2 = (pNodeI = this.pc.createPoly(node = this.j.parse(string2))).expand())) {
            System.out.println("Sucess: \"" + string + "\" equals \"" + string2 + "\"");
        } else {
            System.out.println("Error: \"" + string + "\" is not equal to \"" + string2 + "\"");
            SJepTest.assertTrue((String)("<" + string + "> should be equal to <" + string2 + "> it is not"), (boolean)false);
        }
    }

    public void testGood() {
        SJepTest.assertEquals((int)1, (int)1);
    }

    public void valueTest(String string, double d) throws Exception {
        this.valueTest(string, new Double(d));
    }

    public void valueTest(String string, Object object) throws Exception {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        Object object2 = this.j.evaluate(node2);
        SJepTest.assertEquals((String)("<" + string + ">"), (Object)object, (Object)object2);
        System.out.println("Success value of <" + string + "> is " + object2);
    }

    public void complexValueTest(String string, Complex complex, double d) throws Exception {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        Object object = this.j.evaluate(node2);
        SJepTest.assertTrue((String)("<" + string + "> expected: <" + complex + "> but was <" + object + ">"), (boolean)complex.equals((Complex)object, d));
        System.out.println("Success value of <" + string + "> is " + object);
    }

    public Object calcValue(String string) throws ParseException {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        Object object = this.j.evaluate(node2);
        return object;
    }

    public void simplifyTest(String string, String string2) throws ParseException {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        PNodeI pNodeI = this.pc.createPoly(node2);
        String string3 = ((Object)pNodeI).toString();
        Node node3 = this.j.parse(string2);
        Node node4 = this.j.preprocess(node3);
        PNodeI pNodeI2 = this.pc.createPoly(node4);
        String string4 = ((Object)pNodeI2).toString();
        if (!string4.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string4 + "\"");
        }
        SJepTest.assertEquals((String)("<" + string + ">"), (Object)string4, (Object)string3);
        System.out.println("Sucess: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void simplifyTestString(String string, String string2) throws ParseException {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        PNodeI pNodeI = this.pc.createPoly(node2);
        String string3 = ((Object)pNodeI).toString();
        if (!string2.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string2 + "\"");
        }
        SJepTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Sucess: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void expandTestString(String string, String string2) throws ParseException {
        Node node = this.j.parse(string);
        Node node2 = this.j.preprocess(node);
        PNodeI pNodeI = this.pc.createPoly(node2);
        PNodeI pNodeI2 = pNodeI.expand();
        String string3 = ((Object)pNodeI2).toString();
        if (!string2.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string2 + "\"");
        }
        SJepTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Sucess: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void testSimpleSum() throws Exception {
        this.valueTest("1+2", 3.0);
        this.valueTest("2*6+3", 15.0);
        this.valueTest("2*(6+3)", 18.0);
    }

    public void testOperators() throws Exception {
        OperatorSet operatorSet = this.j.getOperatorSet();
        if (!((XOperator)operatorSet.getMultiply()).isDistributiveOver(operatorSet.getAdd())) {
            SJepTest.fail((String)"* should be distrib over +");
        }
        if (((XOperator)operatorSet.getMultiply()).isDistributiveOver(operatorSet.getDivide())) {
            SJepTest.fail((String)"* should not be distrib over /");
        }
        if (((XOperator)operatorSet.getMultiply()).getPrecedence() > ((XOperator)operatorSet.getAdd()).getPrecedence()) {
            SJepTest.fail((String)"* should have a lower precedence than +");
        }
        this.valueTest("T=1", 1.0);
        this.valueTest("F=0", 0.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
    }

    public void testPrint() throws ParseException {
        this.simplifyTestString("(a+b)+c", "a+b+c");
        this.simplifyTestString("(a-b)+c", "a-b+c");
        this.simplifyTestString("(a+b)-c", "a+b-c");
        this.simplifyTestString("(a-b)-c", "a-b-c");
        this.simplifyTestString("a+(b+c)", "a+b+c");
        this.simplifyTestString("a-(b+c)", "a-b-c");
        this.simplifyTestString("a+(b-c)", "a+b-c");
        this.simplifyTestString("a-(b-c)", "a-b+c");
        this.simplifyTestString("(a*b)*c", "a*b*c");
        this.simplifyTestString("(a/b)*c", "a*c/b");
        this.simplifyTestString("(a*b)/c", "a*b/c");
        this.simplifyTestString("(a/b)/c", "a/(b*c)");
        this.simplifyTestString("a*(b*c)", "a*b*c");
        this.simplifyTestString("a/(b*c)", "a/(b*c)");
        this.simplifyTestString("a*(b/c)", "a*b/c");
        this.simplifyTestString("a/(b/c)", "a*c/b");
        this.simplifyTestString("(a*b)+c", "a*b+c");
        this.simplifyTestString("(a+b)*c", "(a+b)*c");
        this.simplifyTestString("a*(b+c)", "a*(b+c)");
        this.simplifyTestString("a+(b*c)", "a+b*c");
    }

    public void testSimp() throws ParseException {
        this.simplifyTest("2+3", "5");
        this.simplifyTest("2*3", "6");
        this.simplifyTest("2^3", "8");
        this.simplifyTest("3/2", "1.5");
        this.simplifyTest("2*3+4", "10");
        this.simplifyTest("2*(3+4)", "14");
        this.simplifyTest("0+x", "x");
        this.simplifyTest("x+0", "x");
        this.simplifyTest("0-x", "0-x");
        this.simplifyTest("x-0", "x");
        this.simplifyTest("0*x", "0");
        this.simplifyTest("x*0", "0");
        this.simplifyTest("1*x", "x");
        this.simplifyTest("x*1", "x");
        this.simplifyTest("-1*x", "-x");
        this.simplifyTest("x*-1", "-x");
        this.simplifyTest("-(-x)", "x");
        this.simplifyTest("-(-(-x))", "-x");
        this.simplifyTest("(-1)*(-1)*x", "x");
        this.simplifyTest("(-1)*(-1)*(-1)*x", "-x");
        this.simplifyTest("0/x", "0");
        this.simplifyTest("x/0", "1/0");
        this.simplifyTest("x^0", "1");
        this.simplifyTest("x^1", "x");
        this.simplifyTest("0^x", "0");
        this.simplifyTest("1^x", "1");
        this.simplifyTest("(2+3)+x", "5+x");
        this.simplifyTest("(2+x)+3", "5+x");
        this.simplifyTest("(x+2)+3", "5+x");
        this.simplifyTest("x+(2+3)", "5+x");
        this.simplifyTest("2+(x+3)", "5+x");
        this.simplifyTest("2+(3+x)", "5+x");
        this.simplifyTest("(2+3)-x", "5-x");
        this.simplifyTest("(2+x)-3", "x-1");
        this.simplifyTest("(x+2)-3", "x-1");
        this.simplifyTest("(2-3)+x", "-1+x");
        this.simplifyTest("(2-x)+3", "5-x");
        this.simplifyTest("(x-2)+3", "1+x");
        this.simplifyTest("x-(2+3)", "x-5");
        this.simplifyTest("2-(x+3)", "-1-x");
        this.simplifyTest("2-(3+x)", "-1-x");
        this.simplifyTest("x+(2-3)", "x-1");
        this.simplifyTest("2+(x-3)", "-1+x");
        this.simplifyTest("2+(3-x)", "5-x");
        this.simplifyTest("x-(2-3)", "1+x");
        this.simplifyTest("2-(x-3)", "5-x");
        this.simplifyTest("2-(3-x)", "-1+x");
        this.simplifyTest("(2-3)-x", "-1-x");
        this.simplifyTest("(2-x)-3", "-1-x");
        this.simplifyTest("(x-2)-3", "x-5");
        this.simplifyTest("(2*3)*x", "6*x");
        this.simplifyTest("(2*x)*3", "6*x");
        this.simplifyTest("(x*2)*3", "6*x");
        this.simplifyTest("x*(2*3)", "6*x");
        this.simplifyTest("2*(x*3)", "6*x");
        this.simplifyTest("2*(3*x)", "6*x");
        this.simplifyTest("(2*3)/x", "6/x");
        this.simplifyTest("(3*x)/2", "1.5*x");
        this.simplifyTest("(x*3)/2", "1.5*x");
        this.simplifyTest("(3/2)*x", "1.5*x");
        this.simplifyTest("(3/x)*2", "6/x");
        this.simplifyTest("(x/2)*3", "1.5*x");
        this.simplifyTest("x/(2*3)", "x/6");
        this.simplifyTest("3/(x*2)", "1.5/x");
        this.simplifyTest("3/(2*x)", "1.5/x");
        this.simplifyTest("x*(3/2)", "1.5*x");
        this.simplifyTest("3*(x/2)", "1.5*x");
        this.simplifyTest("3*(2/x)", "6/x");
        this.simplifyTest("x/(3/2)", "x/1.5");
        this.simplifyTest("2/(x/3)", "6/x");
        this.simplifyTest("3/(2/x)", "1.5*x");
        this.simplifyTest("(3/2)/x", "1.5/x");
        this.simplifyTest("(3/x)/2", "1.5/x");
        this.simplifyTest("(x/3)/2", "x/6");
        this.simplifyTest("x*(3+2)", "5*x");
        this.simplifyTest("x*(3-2)", "x");
        this.simplifyTest("(3-2)*x", "x");
        this.simplifyTest("x*x", "x^2");
        this.simplifyTest("x*x*x", "x^3");
        this.simplifyTest("(x^3)*(x^4)", "x^7");
        this.simplifyTest("(x^4)/(x^3)", "x");
        this.simplifyTest("(x^3)/(x^4)", "1/x");
        this.simplifyTest("(x^2)/(x^4)", "1/x^2");
        this.simplifyTestString("1/x", "1/x");
        this.simplifyTestString("-1/x", "-1/x");
        this.simplifyTestString("2/x", "2/x");
        this.simplifyTestString("-2/x", "-2/x");
        this.simplifyTestString("(1+x)*(1+x)", "(1+x)^2");
        this.simplifyTestString("(1+x)/(1+x)", "1");
        this.simplifyTest("2*x+x", "3*x");
        this.simplifyTest("2*x+3*x", "5*x");
        this.simplifyTest("5*x-3*x", "2*x");
        this.simplifyTest("3*x-5*x", "-2*x");
        this.simplifyTest("3*x-x", "2*x");
        this.simplifyTest("(2*x+x)^3", "27*x^3");
    }

    public void testPolySimp() throws ParseException, Exception {
        Node node = this.j.parse("(1.0+2.0*x+x^2.0)*(1.0+2.0*x+x^2.0)");
        this.pc.createPoly(node);
        this.expandTestString("(a+b)*(c+d)", "a*c+a*d+b*c+b*d");
        this.expandTestString("a*c+a*d+b*c+b*d", "a*c+a*d+b*c+b*d");
        this.expandTestString("(a+b)*(a+b)", "2*a*b+a^2+b^2");
        this.expandTestString("(a-b)*(a-b)", "-2*a*b+a^2+b^2");
        this.expandTestString("(x+7.6)*(x+5.8832)*(x-55.12)", "-2464.5430784-698.4816639999999*x-41.636799999999994*x^2+x^3");
        this.simplifyTestString("(a+b)^0", "1");
        this.simplifyTestString("(a-b)^0", "1");
        this.simplifyTestString("(a+b)^1", "a+b");
        this.simplifyTestString("(a-b)^1", "a-b");
        this.expandTestString("(a+b)^2", "2*a*b+a^2+b^2");
        this.expandTestString("(a-b)^2", "-2*a*b+a^2+b^2");
        this.expandTestString("(a+b)^3", "3*a*b^2+3*a^2*b+a^3+b^3");
        this.expandTestString("(a-b)^3", "3*a*b^2-3*a^2*b+a^3-b^3");
        this.expandTestString("1+x+x^2+x*y+y^2", "1+x+x*y+x^2+y^2");
        this.expandTestString("(5*x+3*y)^2", "30*x*y+25*x^2+9*y^2");
        this.j.getPrintVisitor().setMaxLen(80);
        Node node2 = this.j.parse("(xx^2+yy^2+zz^2+ww^2)^4");
        Node node3 = this.pc.expand(node2);
        this.j.println(node3);
        this.expandTestString("(xx^2+yy^2+zz^2+ww^2)^4", "24*ww^2*xx^2*yy^2*zz^2+12*ww^2*xx^2*yy^4+12*ww^2*xx^2*zz^4+12*ww^2*xx^4*yy^2+12*ww^2*xx^4*zz^2+4*ww^2*xx^6+12*ww^2*yy^2*zz^4+12*ww^2*yy^4*zz^2+4*ww^2*yy^6+4*ww^2*zz^6+12*ww^4*xx^2*yy^2+12*ww^4*xx^2*zz^2+6*ww^4*xx^4+12*ww^4*yy^2*zz^2+6*ww^4*yy^4+6*ww^4*zz^4+4*ww^6*xx^2+4*ww^6*yy^2+4*ww^6*zz^2+ww^8+12*xx^2*yy^2*zz^4+12*xx^2*yy^4*zz^2+4*xx^2*yy^6+4*xx^2*zz^6+12*xx^4*yy^2*zz^2+6*xx^4*yy^4+6*xx^4*zz^4+4*xx^6*yy^2+4*xx^6*zz^2+xx^8+4*yy^2*zz^6+6*yy^4*zz^4+4*yy^6*zz^2+yy^8+zz^8");
        Node node4 = this.j.parse("ln(x+1)");
        Node node5 = this.j.differentiate(node4, "x");
        Node node6 = this.pc.simplify(node5);
        this.myAssertEquals("diff(ln(x+1))", this.j.toString(node6), "1.0/(1.0+x)");
        node5 = this.j.differentiate(node6, "x");
        this.j.println(node5);
        node6 = this.pc.simplify(node5);
        this.myAssertEquals("d^2(ln(x+1))", this.j.toString(node6), "-1.0/(1.0+x)^2.0");
        node5 = this.j.differentiate(node6, "x");
        this.j.println(node5);
        node6 = this.pc.simplify(node5);
        this.myAssertEquals("d^3(ln(x+1))", this.j.toString(node6), "2.0/(1.0+x)^3.0");
        node5 = this.j.differentiate(node6, "x");
        this.j.println(node5);
        node6 = this.pc.simplify(node5);
        System.out.println("D^4\t" + this.j.toString(node6));
        this.j.getPrintVisitor().setMaxLen(80);
        node5 = this.j.differentiate(node6, "x");
        node6 = this.pc.simplify(node5);
        System.out.print("D^5\t");
        this.j.println(node6);
        node5 = this.j.differentiate(node6, "x");
        node6 = this.pc.simplify(node5);
        System.out.print("D^6\t");
        this.j.println(node6);
        node5 = this.j.differentiate(node6, "x");
        node6 = this.pc.simplify(node5);
        System.out.print("D^7\t");
        this.j.println(node6);
        node5 = this.j.differentiate(node6, "x");
        node6 = this.pc.simplify(node5);
        System.out.print("D^8\t");
        this.j.println(node6);
    }

    public void testTotalOrder() throws ParseException, Exception {
        this.expandTestString("y+x", "x+y");
        this.expandTestString("x^2+x", "x+x^2");
        this.expandTestString("x^3+x^2", "x^2+x^3");
        this.expandTestString("x*y+x", "x+x*y");
        this.expandTestString("x^2+x*y", "x*y+x^2");
        this.expandTestString("x+1/x", "1/x+x");
        this.expandTestString("1/x^2+1/x", "1/x^2+1/x");
        this.simplifyTestString("y+x", "x+y");
        this.simplifyTestString("x^2+x", "x+x^2");
        this.simplifyTestString("x^3+x^2", "x^2+x^3");
        this.simplifyTestString("x*y+x", "x+x*y");
        this.simplifyTestString("x^2+x*y", "x*y+x^2");
        this.simplifyTestString("x+1/x", "1/x+x");
        this.simplifyTestString("1/x^2+1/x", "1/x^2+1/x");
    }

    public void testPolySimp2() throws ParseException, Exception {
        this.expandTestString("1+2*(1+x)", "3+2*x");
        this.expandTestString("6x+3y+4x+3(15x+7y)+40", "40+55*x+24*y");
        this.expandTestString("x*y+2*x", "2*x+x*y");
        this.expandTestString("(1+x+y)^2", "1+2*x+2*x*y+x^2+2*y+y^2");
    }

    public void testFormat() throws ParseException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.j.getPrintVisitor().setNumberFormat(numberFormat);
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(0);
        String string = "[10,0,0.1,0.11,0.111,0.1111]";
        String string2 = this.j.toString(this.j.parse(string));
        String string3 = "[0.9,0.99,0.999,0.9999]";
        String string4 = this.j.toString(this.j.parse(string3));
        this.myAssertEquals(string, string2, "[10,0,0.1,0.11,0.111,0.111]");
        this.myAssertEquals(string3, string4, "[0.9,0.99,0.999,1]");
        this.j.println(this.j.parse("[0,1,i,1+i]"));
        this.j.getPrintVisitor().setMode(2, true);
        this.j.println(this.j.simplify(this.j.parse("(2+i)+(1+i)")));
        this.j.parseExpression("(2+i)+(1+i)");
        Complex complex = this.j.getComplexValue();
        System.out.println(complex.toString(numberFormat, true));
    }

    public void testSimpleEquals() throws ParseException {
        this.assertPolynomialEquals("a+b-(c+d)", "(a+b)-c-d");
    }

    public void testBad() throws ParseException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

