/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.vectorJep.VectorJep;
import org.lsmp.djepJUnit.JepTest;
import org.nfunk.jep.ParseException;

public class VectorJepTest
extends JepTest {
    static /* synthetic */ Class class$org$lsmp$djepJUnit$VectorJepTest;

    public VectorJepTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$VectorJepTest == null ? (class$org$lsmp$djepJUnit$VectorJepTest = VectorJepTest.class$("org.lsmp.djepJUnit.VectorJepTest")) : class$org$lsmp$djepJUnit$VectorJepTest);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$VectorJepTest == null ? (class$org$lsmp$djepJUnit$VectorJepTest = VectorJepTest.class$("org.lsmp.djepJUnit.VectorJepTest")) : class$org$lsmp$djepJUnit$VectorJepTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new VectorJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public void testMatrix() throws Exception {
        System.out.println("\nTesting vector and matrix operations");
        this.j.getSymbolTable().clearValues();
        this.valueTest("x=2", 2.0);
        this.valueTest("(x*x)*x*(x*x)", 32.0);
        this.valueTest("y=[x^3,x^2,x]", "[8.0,4.0,2.0]");
        this.valueTest("z=[3*x^2,2*x,1]", "[12.0,4.0,1.0]");
        this.valueTest("w=y^^z", "[-4.0,16.0,-16.0]");
        this.valueTest("w.y", "0.0");
        this.valueTest("w.z", "0.0");
        this.valueTest("sqrt(w . z)", "0.0");
        this.valueTest("sqrt([3,4] . [3,4])", "5.0");
        this.valueTest("y+z", "[20.0,8.0,3.0]");
        this.valueTest("y-z", "[-4.0,0.0,1.0]");
        this.valueTest("3*y", "[24.0,12.0,6.0]");
        this.valueTest("y*4", "[32.0,16.0,8.0]");
        this.valueTest("y*z", "[[96.0,32.0,8.0],[48.0,16.0,4.0],[24.0,8.0,2.0]]");
        this.valueTest("z*y", "[[96.0,48.0,24.0],[32.0,16.0,8.0],[8.0,4.0,2.0]]");
        this.j.getSymbolTable().clearValues();
        this.j.evaluate(this.j.parse("y=[cos(x),sin(x)]"));
        this.j.evaluate(this.j.parse("z=[-sin(x),cos(x)]"));
        this.valueTest("y . y", "1.0");
        this.valueTest("y . z", "0.0");
        this.valueTest("z . z", "1.0");
        this.j.getSymbolTable().clearValues();
        this.valueTest("x=[[1,2],[3,4]]", "[[1.0,2.0],[3.0,4.0]]");
        this.valueTest("y=[1,-1]", "[1.0,-1.0]");
        this.valueTest("x*y", "[-1.0,-1.0]");
        this.valueTest("y*x", "[-2.0,-2.0]");
        this.valueTest("x+[y,y]", "[[2.0,1.0],[4.0,3.0]]");
        this.valueTest("ele(y,1)", "1.0");
        this.valueTest("ele(y,2)", "-1.0");
        this.valueTest("ele(x,[1,1])", "1.0");
        this.valueTest("ele(x,[1,2])", "2.0");
        this.valueTest("ele(x,[2,1])", "3.0");
        this.valueTest("ele(x,[2,2])", "4.0");
    }

    public void testLength() throws ParseException, Exception {
        System.out.println("\nTesting vector and matrix functions");
        this.valueTest("len(5)", "1");
        this.valueTest("len([1,2,3])", "3");
        this.valueTest("len([[1,2,3],[4,5,6]])", "6");
        this.valueTest("size(5)", "1");
        this.valueTest("size([1,2,3])", "3");
        this.valueTest("size([[1,2,3],[4,5,6]])", "[2,3]");
        this.valueTest("size([[[1,2],[3,4],[5,6]],[[7,8],[9,10],[11,12]]])", "[2,3,2]");
        this.valueTest("diag([1,2,3])", "[[1.0,0.0,0.0],[0.0,2.0,0.0],[0.0,0.0,3.0]]");
        this.valueTest("id(3)", "[[1.0,0.0,0.0],[0.0,1.0,0.0],[0.0,0.0,1.0]]");
        this.valueTest("getdiag([[1,2],[3,4]])", "[1.0,4.0]");
        this.valueTest("trans([[1,2],[3,4]])", "[[1.0,3.0],[2.0,4.0]]");
        this.valueTest("det([[1,2],[3,4]])", "-2.0");
        this.valueTest("det([[1,2,3],[4,5,6],[9,8,9]])", "-6.0");
        this.valueTest("det([[1,2,3],[4,5,6],[7,8,9]])", "0.0");
        this.valueTest("det([[1,2,3,4],[5,6,77,8],[4,3,2,1],[17,9,23,19]])", "9100.0");
        this.valueTest("trace([[1,2],[3,4]])", "5.0");
        this.valueTest("trace([[1,2,3],[4,5,6],[7,8,9]])", "15.0");
        this.valueTest("trace([[1,2,3,4],[5,6,7,8],[9,10,11,12],[13,14,15,16]])", "34.0");
        this.valueTest("vsum([[1,2],[3,4]])", "10.0");
        this.valueTest("vsum([1,2,3])", "6.0");
        this.valueTest("Map(x^3,x,[1,2,3])", "[1.0,8.0,27.0]");
        this.valueTest("Map(x*y,[x,y],[1,2,3],[4,5,6])", "[4.0,10.0,18.0]");
        this.valueTest("Map(if(x>0,x,0),x,[-2,-1,0,1,2])", "[0.0,0.0,0.0,1.0,2.0]");
        this.valueTest("Map(abs(x),x,[[-2,-1],[1,2]])", "[[2.0,1.0],[1.0,2.0]]");
    }

    public void testSumVector() throws Exception {
    }

    public void testVecCmp() throws Exception {
        this.valueTest("[1,2,3]==[1,2,3]", 1.0);
        this.valueTest("[1,2,3]==[1,2,4]", 0.0);
    }

    public void testDotInName() throws ParseException, Exception {
    }

    public void testGenMatEle() throws Exception {
        System.out.println("The following caused a problem as ele only acepted Double arguments");
        this.valueTest("m=[1,2,3]", "[1.0,2.0,3.0]");
        this.valueTest("GenMat(3,ele(m,n)*10,n)", "[10.0,20.0,30.0]");
    }

    public void testArrayAccess() throws Exception {
        System.out.println("\nTests array access on lhs and rhs using the a[3] notation");
        this.valueTest("a=[1,2,3]", "[1.0,2.0,3.0]");
        this.valueTest("a[2]=4", 4.0);
        this.valueTest("b=a[2]", 4.0);
        this.valueTest("b", 4.0);
        this.valueTest("c=[[1,2],[3,4]]", "[[1.0,2.0],[3.0,4.0]]");
        this.valueTest("c[1,2]=5", 5.0);
        this.valueTest("c", "[[1.0,5.0],[3.0,4.0]]");
        this.valueTest("c[2,1]", 3.0);
    }

    public void testElementOperations() throws Exception {
        ((VectorJep)this.j).setElementMultiply(true);
        this.valueTest("[1,2,3] == [2,2,2]", "[0.0,1.0,0.0]");
        this.valueTest("[1,2,3] != [2,2,2]", "[1.0,0.0,1.0]");
        this.valueTest("[1,2,3] < [2,2,2]", "[1.0,0.0,0.0]");
        this.valueTest("[1,2,3] <= [2,2,2]", "[1.0,1.0,0.0]");
        this.valueTest("[1,2,3] > [2,2,2]", "[0.0,0.0,1.0]");
        this.valueTest("[1,2,3] >= [2,2,2]", "[0.0,1.0,1.0]");
        this.valueTest("[1,2,3] * [2,2,2]", "[2.0,4.0,6.0]");
        this.valueTest("[1,2,3] / [2,2,2]", "[0.5,1.0,1.5]");
    }

    public void testComplexMatricies() throws Exception {
        this.valueTest("v=[1+i,1-2i]", "[(1.0, 1.0),(1.0, -2.0)]");
        this.valueTest("vsum(v)", "(2.0, -1.0)");
        this.valueTest("m=[[1+i,-1+i],[1-i,-1-i]]", "[[(1.0, 1.0),(-1.0, 1.0)],[(1.0, -1.0),(-1.0, -1.0)]]");
        this.valueTest("vsum(m)", "(0.0, 0.0)");
        this.valueTest("trace(m)", "(0.0, 0.0)");
        this.valueTest("m*v", "[(1.0, 5.0),(-1.0, 1.0)]");
        this.valueTest("v*m", "[(-1.0, -1.0),(-5.0, 1.0)]");
        this.valueTest("trans(m)", "[[(1.0, 1.0),(1.0, -1.0)],[(-1.0, 1.0),(-1.0, -1.0)]]");
        this.valueTest("det(m)", "(0.0, -4.0)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

