/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.text.NumberFormat;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.xjep.BaseFormat;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.lsmp.djepJUnit.JepTest;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.type.Complex;

public class XJepTest
extends JepTest {
    static /* synthetic */ Class class$org$lsmp$djepJUnit$XJepTest;

    public XJepTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$lsmp$djepJUnit$XJepTest == null ? (class$org$lsmp$djepJUnit$XJepTest = XJepTest.class$("org.lsmp.djepJUnit.XJepTest")) : class$org$lsmp$djepJUnit$XJepTest);
    }

    public static void main(String[] stringArray) {
        TestSuite testSuite = new TestSuite(class$org$lsmp$djepJUnit$XJepTest == null ? (class$org$lsmp$djepJUnit$XJepTest = XJepTest.class$("org.lsmp.djepJUnit.XJepTest")) : class$org$lsmp$djepJUnit$XJepTest);
        testSuite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new XJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public String parsePreprocSimp(String string) throws ParseException {
        XJep xJep = (XJep)this.j;
        Node node = xJep.parse(string);
        Node node2 = xJep.preprocess(node);
        Node node3 = xJep.simplify(node2);
        String string2 = xJep.toString(node3);
        return string2;
    }

    public void simplifyTestString(String string, String string2) throws ParseException {
        XJep xJep = (XJep)this.j;
        Node node = xJep.parse(string);
        Node node2 = xJep.preprocess(node);
        Node node3 = xJep.simplify(node2);
        String string3 = xJep.toString(node3);
        if (!string2.equals(string3)) {
            System.out.println("Error: Value of \"" + string + "\" is \"" + string3 + "\" should be \"" + string2 + "\"");
        }
        XJepTest.assertEquals((String)("<" + string + ">"), (Object)string2, (Object)string3);
        System.out.println("Success: Value of \"" + string + "\" is \"" + string3 + "\"");
    }

    public void simplifyTest(String string, String string2) throws ParseException {
        XJep xJep = (XJep)this.j;
        Node node = xJep.parse(string2);
        Node node2 = xJep.preprocess(node);
        Node node3 = xJep.simplify(node2);
        String string3 = xJep.toString(node3);
        this.simplifyTestString(string, string3);
    }

    public Node parseProcSimpEval(String string, Object object) throws ParseException, Exception {
        XJep xJep = (XJep)this.j;
        Node node = xJep.parse(string);
        Node node2 = xJep.preprocess(node);
        Node node3 = xJep.simplify(node2);
        Object object2 = xJep.evaluate(node3);
        this.myAssertEquals(string, object, object2);
        return node3;
    }

    public void testLogical() throws Exception {
        super.testLogical();
        OperatorSet operatorSet = this.j.getOperatorSet();
        if (!((XOperator)operatorSet.getMultiply()).isDistributiveOver(operatorSet.getAdd())) {
            XJepTest.fail((String)"* should be distrib over +");
        }
        if (((XOperator)operatorSet.getMultiply()).isDistributiveOver(operatorSet.getDivide())) {
            XJepTest.fail((String)"* should not be distrib over /");
        }
        if (((XOperator)operatorSet.getMultiply()).getPrecedence() > ((XOperator)operatorSet.getAdd()).getPrecedence()) {
            XJepTest.fail((String)"* should have a lower precedence than +");
        }
    }

    public void testPrint() throws ParseException {
        this.simplifyTestString("(a+b)+c", "a+b+c");
        this.simplifyTestString("(a-b)+c", "a-b+c");
        this.simplifyTestString("(a+b)-c", "a+b-c");
        this.simplifyTestString("(a-b)-c", "a-b-c");
        this.simplifyTestString("a+(b+c)", "a+b+c");
        this.simplifyTestString("a-(b+c)", "a-(b+c)");
        this.simplifyTestString("a+(b-c)", "a+b-c");
        this.simplifyTestString("a-(b-c)", "a-(b-c)");
        this.simplifyTestString("(a*b)*c", "a*b*c");
        this.simplifyTestString("(a/b)*c", "(a/b)*c");
        this.simplifyTestString("(a*b)/c", "a*b/c");
        this.simplifyTestString("(a/b)/c", "(a/b)/c");
        this.simplifyTestString("a*(b*c)", "a*b*c");
        this.simplifyTestString("a/(b*c)", "a/(b*c)");
        this.simplifyTestString("a*(b/c)", "a*b/c");
        this.simplifyTestString("a/(b/c)", "a/(b/c)");
        this.simplifyTestString("a=(b=c)", "a=b=c");
        this.simplifyTestString("(a*b)+c", "a*b+c");
        this.simplifyTestString("(a+b)*c", "(a+b)*c");
        this.simplifyTestString("a*(b+c)", "a*(b+c)");
        this.simplifyTestString("a+(b*c)", "a+b*c");
        this.simplifyTestString("(a||b)||c", "a||b||c");
        this.simplifyTestString("(a&&b)||c", "a&&b||c");
        this.simplifyTestString("(a||b)&&c", "(a||b)&&c");
        this.simplifyTestString("(a&&b)&&c", "a&&b&&c");
        this.simplifyTestString("a||(b||c)", "a||b||c");
        this.simplifyTestString("a&&(b||c)", "a&&(b||c)");
        this.simplifyTestString("a||(b&&c)", "a||b&&c");
        this.simplifyTestString("a&&(b&&c)", "a&&b&&c");
    }

    public void testSimp() throws ParseException {
        this.simplifyTest("2+3", "5");
        this.simplifyTest("2*3", "6");
        this.simplifyTest("2^3", "8");
        this.simplifyTest("3/2", "1.5");
        this.simplifyTest("2*3+4", "10");
        this.simplifyTest("2*(3+4)", "14");
        this.simplifyTest("0+x", "x");
        this.simplifyTest("x+0", "x");
        this.simplifyTest("0-x", "0-x");
        this.simplifyTest("x-0", "x");
        this.simplifyTest("0*x", "0");
        this.simplifyTest("x*0", "0");
        this.simplifyTest("1*x", "x");
        this.simplifyTest("x*1", "x");
        this.simplifyTest("-1*x", "-x");
        this.simplifyTest("x*-1", "-x");
        this.simplifyTest("-(-x)", "x");
        this.simplifyTest("-(-(-x))", "-x");
        this.simplifyTest("(-1)*(-1)*x", "x");
        this.simplifyTest("(-1)*(-1)*(-1)*x", "-x");
        this.simplifyTest("0/x", "0");
        this.simplifyTest("x/0", "1/0");
        this.simplifyTest("x^0", "1");
        this.simplifyTest("x^1", "x");
        this.simplifyTest("0^x", "0");
        this.simplifyTest("1^x", "1");
        this.simplifyTest("(2+3)+x", "5+x");
        this.simplifyTest("(2+x)+3", "5+x");
        this.simplifyTest("(x+2)+3", "5+x");
        this.simplifyTest("x+(2+3)", "5+x");
        this.simplifyTest("2+(x+3)", "5+x");
        this.simplifyTest("2+(3+x)", "5+x");
        this.simplifyTest("(2+3)-x", "5-x");
        this.simplifyTest("(2+x)-3", "x-1");
        this.simplifyTest("(x+2)-3", "x-1");
        this.simplifyTest("(2-3)+x", "-1+x");
        this.simplifyTest("(2-x)+3", "5-x");
        this.simplifyTest("(x-2)+3", "1+x");
        this.simplifyTest("x-(2+3)", "x-5");
        this.simplifyTest("2-(x+3)", "-1-x");
        this.simplifyTest("2-(3+x)", "-1-x");
        this.simplifyTest("x+(2-3)", "x-1");
        this.simplifyTest("2+(x-3)", "-1+x");
        this.simplifyTest("2+(3-x)", "5-x");
        this.simplifyTest("x-(2-3)", "1+x");
        this.simplifyTest("2-(x-3)", "5-x");
        this.simplifyTest("2-(3-x)", "-1+x");
        this.simplifyTest("(2-3)-x", "-1-x");
        this.simplifyTest("(2-x)-3", "-1-x");
        this.simplifyTest("(x-2)-3", "x-5");
        this.simplifyTest("(2*3)*x", "6*x");
        this.simplifyTest("(2*x)*3", "6*x");
        this.simplifyTest("(x*2)*3", "6*x");
        this.simplifyTest("x*(2*3)", "6*x");
        this.simplifyTest("2*(x*3)", "6*x");
        this.simplifyTest("2*(3*x)", "6*x");
        this.simplifyTest("(2*3)/x", "6/x");
        this.simplifyTest("(3*x)/2", "1.5*x");
        this.simplifyTest("(x*3)/2", "1.5*x");
        this.simplifyTest("(3/2)*x", "1.5*x");
        this.simplifyTest("(3/x)*2", "6/x");
        this.simplifyTest("(x/2)*3", "1.5*x");
        this.simplifyTest("x/(2*3)", "x/6");
        this.simplifyTest("3/(x*2)", "1.5/x");
        this.simplifyTest("3/(2*x)", "1.5/x");
        this.simplifyTest("x*(3/2)", "1.5*x");
        this.simplifyTest("3*(x/2)", "1.5*x");
        this.simplifyTest("3*(2/x)", "6/x");
        this.simplifyTest("x/(3/2)", "x/1.5");
        this.simplifyTest("2/(x/3)", "6/x");
        this.simplifyTest("3/(2/x)", "1.5*x");
        this.simplifyTest("(3/2)/x", "1.5/x");
        this.simplifyTest("(3/x)/2", "1.5/x");
        this.simplifyTest("(x/3)/2", "x/6");
        this.simplifyTest("x*(3+2)", "5*x");
        this.simplifyTest("3*(x+2)", "6+3*x");
        this.simplifyTest("3*(2+x)", "6+3*x");
        this.simplifyTest("(3+2)*x", "5*x");
        this.simplifyTest("(3+x)*2", "6+2*x");
        this.simplifyTest("(x+3)*2", "6+x*2");
        this.simplifyTest("x*(3-2)", "x");
        this.simplifyTest("3*(x-2)", "-6+3*x");
        this.simplifyTest("3*(2-x)", "6-3*x");
        this.simplifyTest("(3-2)*x", "x");
        this.simplifyTest("(3-x)*2", "6-2*x");
        this.simplifyTest("(x-3)*2", "-6+2*x");
        this.simplifyTest("3+(x/4)", "3+x/4");
        this.simplifyTest("2*(x/4)", "0.5*x");
        this.simplifyTest("(2*(3+(x/4)))", "6+0.5*x");
        this.simplifyTest("1+(2*(3+(x/4)))", "7+0.5*x");
        this.simplifyTest("((3+(x/4))*2)+1", "7+0.5*x");
        this.simplifyTest("(x/2)*3", "x*1.5");
    }

    public void testMacroFun() throws Exception {
        this.j.addFunction("zap", new MacroFunction("zap", 1, "x*(x-1)/2", (XJep)this.j));
        this.valueTest("zap(10)", 45.0);
    }

    public void testVariableReuse() throws Exception {
        XJep xJep = (XJep)this.j;
        System.out.println("\nTesting variable reuse");
        this.parseProcSimpEval("x=3", new Double(3.0));
        Node node = this.parseProcSimpEval("y=x^2", new Double(9.0));
        Node node2 = this.parseProcSimpEval("z=y+x", new Double(12.0));
        this.j.setVarValue("x", new Double(4.0));
        System.out.println("j.setVarValue(\"x\",new Double(4));");
        System.out.println("j.getVarValue(y): " + this.j.getVarValue("y"));
        this.myAssertEquals("eval y eqn", "16.0", this.j.evaluate(node).toString());
        System.out.println("j.getVarValue(y): " + this.j.getVarValue("y"));
        this.myAssertEquals("eval z eqn", "20.0", this.j.evaluate(node2).toString());
        this.j.setVarValue("x", new Double(5.0));
        System.out.println("j.setVarValue(\"x\",new Double(5));");
        this.myAssertEquals("j.findVarValue(y)", "25.0", xJep.calcVarValue("y").toString());
        this.myAssertEquals("j.findVarValue(z)", "30.0", xJep.calcVarValue("z").toString());
        this.j.getSymbolTable().clearValues();
        this.j.setVarValue("x", new Double(6.0));
        System.out.println("j.setVarValue(\"x\",new Double(6));");
        this.myAssertEquals("j.findVarValue(z)", "42.0", xJep.calcVarValue("z").toString());
        this.myAssertEquals("j.findVarValue(y)", "36.0", xJep.calcVarValue("y").toString());
        this.parseProcSimpEval("x=7", new Double(7.0));
        this.myAssertEquals("eval y eqn", "49.0", this.j.evaluate(node).toString());
        this.myAssertEquals("eval z eqn", "56.0", this.j.evaluate(node2).toString());
    }

    public void testReentrant() throws ParseException, Exception {
        XJep xJep = (XJep)this.j;
        xJep.restartParser("x=1; // semi-colon; in comment\n y=2; z=x+y;");
        Node node = xJep.continueParsing();
        this.myAssertEquals("x=1; ...", "1.0", this.calcValue(node).toString());
        node = xJep.continueParsing();
        this.myAssertEquals("..., y=2; ...", "2.0", this.calcValue(node).toString());
        node = xJep.continueParsing();
        this.myAssertEquals("..., z=x+y;", "3.0", this.calcValue(node).toString());
        node = xJep.continueParsing();
        XJepTest.assertNull((String)"empty string ", (Object)node);
    }

    public void testFormat() throws ParseException {
        XJep xJep = (XJep)this.j;
        NumberFormat numberFormat = NumberFormat.getInstance();
        xJep.getPrintVisitor().setNumberFormat(numberFormat);
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(0);
        String string = "[10,0,0.1,0.11,0.111,0.1111]";
        String string2 = xJep.toString(this.j.parse(string));
        String string3 = "[0.9,0.99,0.999,0.9999]";
        String string4 = xJep.toString(this.j.parse(string3));
        this.myAssertEquals(string, string2, "[10,0,0.1,0.11,0.111,0.111]");
        this.myAssertEquals(string3, string4, "[0.9,0.99,0.999,1]");
        xJep.println(this.j.parse("[0,1,i,1+i]"));
        xJep.getPrintVisitor().setMode(2, true);
        xJep.println(xJep.simplify(this.j.parse("(2+i)+(1+i)")));
        Complex complex = (Complex)this.calcValue("(2+i)+(1+i)");
        System.out.println(complex.toString(numberFormat, true));
    }

    public void testVarInEqn() throws Exception {
        XJep xJep = (XJep)this.j;
        Node node = this.j.parse("a+b+c+d");
        Vector vector = xJep.getVarsInEquation(node, new Vector());
        XJepTest.assertTrue((String)"Does not contain a", (boolean)vector.contains(this.j.getSymbolTable().getVar("a")));
        XJepTest.assertTrue((String)"Does not contain b", (boolean)vector.contains(this.j.getSymbolTable().getVar("b")));
        XJepTest.assertTrue((String)"Does not contain c", (boolean)vector.contains(this.j.getSymbolTable().getVar("c")));
        XJepTest.assertTrue((String)"Does not contain d", (boolean)vector.contains(this.j.getSymbolTable().getVar("d")));
        xJep.preprocess(this.j.parse("x=a+b t"));
        xJep.preprocess(this.j.parse("y=c+d t"));
        xJep.preprocess(this.j.parse("f=x*y"));
        xJep.preprocess(this.j.parse("g=x+y"));
        Node node2 = xJep.preprocess(this.j.parse("f+g"));
        Vector vector2 = xJep.recursiveGetVarsInEquation(node2, new Vector());
        Vector<Variable> vector3 = new Vector<Variable>();
        vector3.add(this.j.getVar("a"));
        vector3.add(this.j.getVar("b"));
        vector3.add(this.j.getVar("t"));
        vector3.add(this.j.getVar("x"));
        vector3.add(this.j.getVar("c"));
        vector3.add(this.j.getVar("d"));
        vector3.add(this.j.getVar("y"));
        vector3.add(this.j.getVar("f"));
        vector3.add(this.j.getVar("g"));
        System.out.println(vector2.toString());
        XJepTest.assertEquals((String)"Bad element seq", vector3, (Object)vector2);
    }

    public void testUndecVar() throws ParseException {
        this.j.setAllowUndeclared(true);
        Node node = ((XJep)this.j).parse("zap * biff * gosh");
        ((XJep)this.j).preprocess(node);
    }

    public void testSum() throws Exception {
        this.valueTest("Sum(x,x,1,10)", 55.0);
        this.valueTest("Sum(x^2,x,1,5)", 55.0);
        this.valueTest("Product(x,x,1,5)", 120.0);
        this.valueTest("Min(x^2,x,1,5)", 1.0);
        this.valueTest("Max(x^2,x,1,5)", 25.0);
        this.valueTest("MinArg(x^2,x,1,5)", 1.0);
        this.valueTest("MaxArg(x^2,x,1,5)", 5.0);
    }

    public void testHex() throws Exception {
        this.valueTest("toHex(0)", "0x0");
        this.valueTest("toHex(0,1)", "0x0.0");
        this.valueTest("toHex(0,2)", "0x0.00");
        this.valueTest("toHex(1)", "0x1");
        this.valueTest("toHex(1,1)", "0x1.0");
        this.valueTest("toHex(1,2)", "0x1.00");
        this.valueTest("toHex(-1)", "-0x1");
        this.valueTest("toHex(-1,1)", "-0x1.0");
        this.valueTest("toHex(-1,2)", "-0x1.00");
        this.valueTest("toHex(7)", "0x7");
        this.valueTest("toHex(7,1)", "0x7.0");
        this.valueTest("toHex(7,2)", "0x7.00");
        this.valueTest("toHex(-7)", "-0x7");
        this.valueTest("toHex(-7,1)", "-0x7.0");
        this.valueTest("toHex(-7,2)", "-0x7.00");
        this.valueTest("toHex(8)", "0x8");
        this.valueTest("toHex(8,1)", "0x8.0");
        this.valueTest("toHex(8,2)", "0x8.00");
        this.valueTest("toHex(-8)", "-0x8");
        this.valueTest("toHex(-8,1)", "-0x8.0");
        this.valueTest("toHex(-8,2)", "-0x8.00");
        this.valueTest("toHex(10)", "0xa");
        this.valueTest("toHex(10,1)", "0xa.0");
        this.valueTest("toHex(10,2)", "0xa.00");
        this.valueTest("toHex(-10)", "-0xa");
        this.valueTest("toHex(-10,1)", "-0xa.0");
        this.valueTest("toHex(-10,2)", "-0xa.00");
        this.valueTest("toHex(15)", "0xf");
        this.valueTest("toHex(15,1)", "0xf.0");
        this.valueTest("toHex(15,2)", "0xf.00");
        this.valueTest("toHex(-15)", "-0xf");
        this.valueTest("toHex(-15,1)", "-0xf.0");
        this.valueTest("toHex(-15,2)", "-0xf.00");
        this.valueTest("toHex(16)", "0x10");
        this.valueTest("toHex(16,1)", "0x10.0");
        this.valueTest("toHex(16,2)", "0x10.00");
        this.valueTest("toHex(-16)", "-0x10");
        this.valueTest("toHex(-16,1)", "-0x10.0");
        this.valueTest("toHex(-16,2)", "-0x10.00");
        this.valueTest("toHex(17)", "0x11");
        this.valueTest("toHex(17,1)", "0x11.0");
        this.valueTest("toHex(17,2)", "0x11.00");
        this.valueTest("toHex(-17)", "-0x11");
        this.valueTest("toHex(-17,1)", "-0x11.0");
        this.valueTest("toHex(-17,2)", "-0x11.00");
        this.valueTest("toHex(256)", "0x100");
        this.valueTest("toHex(256,1)", "0x100.0");
        this.valueTest("toHex(256,2)", "0x100.00");
        this.valueTest("toHex(-256)", "-0x100");
        this.valueTest("toHex(-256,1)", "-0x100.0");
        this.valueTest("toHex(-256,2)", "-0x100.00");
        this.valueTest("toHex(1/16)", "0x0");
        this.valueTest("toHex(1/16,1)", "0x0.1");
        this.valueTest("toHex(1/16,2)", "0x0.10");
        this.valueTest("toHex(-1/16)", "-0x0");
        this.valueTest("toHex(-1/16,1)", "-0x0.1");
        this.valueTest("toHex(-1/16,2)", "-0x0.10");
        this.valueTest("toHex(7/16)", "0x0");
        this.valueTest("toHex(7/16,1)", "0x0.7");
        this.valueTest("toHex(7/16,2)", "0x0.70");
        this.valueTest("toHex(-7/16)", "-0x0");
        this.valueTest("toHex(-7/16,1)", "-0x0.7");
        this.valueTest("toHex(-7/16,2)", "-0x0.70");
        this.valueTest("toHex(8/16)", "0x1");
        this.valueTest("toHex(8/16,1)", "0x0.8");
        this.valueTest("toHex(8/16,2)", "0x0.80");
        this.valueTest("toHex(-8/16)", "-0x1");
        this.valueTest("toHex(-8/16,1)", "-0x0.8");
        this.valueTest("toHex(-8/16,2)", "-0x0.80");
        this.valueTest("toHex(10/16)", "0x1");
        this.valueTest("toHex(10/16,1)", "0x0.a");
        this.valueTest("toHex(10/16,2)", "0x0.a0");
        this.valueTest("toHex(-10/16)", "-0x1");
        this.valueTest("toHex(-10/16,1)", "-0x0.a");
        this.valueTest("toHex(-10/16,2)", "-0x0.a0");
        this.valueTest("toHex(15/16)", "0x1");
        this.valueTest("toHex(15/16,1)", "0x0.f");
        this.valueTest("toHex(15/16,2)", "0x0.f0");
        this.valueTest("toHex(-15/16)", "-0x1");
        this.valueTest("toHex(-15/16,1)", "-0x0.f");
        this.valueTest("toHex(-15/16,2)", "-0x0.f0");
        this.valueTest("toHex(17/16)", "0x1");
        this.valueTest("toHex(17/16,1)", "0x1.1");
        this.valueTest("toHex(17/16,2)", "0x1.10");
        this.valueTest("toHex(-17/16)", "-0x1");
        this.valueTest("toHex(-17/16,1)", "-0x1.1");
        this.valueTest("toHex(-17/16,2)", "-0x1.10");
        this.valueTest("toHex(31/16)", "0x2");
        this.valueTest("toHex(31/16,1)", "0x1.f");
        this.valueTest("toHex(31/16,2)", "0x1.f0");
        this.valueTest("toHex(-31/16)", "-0x2");
        this.valueTest("toHex(-31/16,1)", "-0x1.f");
        this.valueTest("toHex(-31/16,2)", "-0x1.f0");
        this.valueTest("toHex(1/256)", "0x0");
        this.valueTest("toHex(1/256,1)", "0x0.0");
        this.valueTest("toHex(1/256,2)", "0x0.01");
        this.valueTest("toHex(-1/256)", "-0x0");
        this.valueTest("toHex(-1/256,1)", "-0x0.0");
        this.valueTest("toHex(-1/256,2)", "-0x0.01");
        this.valueTest("toHex(15/256)", "0x0");
        this.valueTest("toHex(15/256,1)", "0x0.1");
        this.valueTest("toHex(15/256,2)", "0x0.0f");
        this.valueTest("toHex(-15/256)", "-0x0");
        this.valueTest("toHex(-15/256,1)", "-0x0.1");
        this.valueTest("toHex(-15/256,2)", "-0x0.0f");
        this.valueTest("toHex(17/256)", "0x0");
        this.valueTest("toHex(17/256,1)", "0x0.1");
        this.valueTest("toHex(17/256,2)", "0x0.11");
        this.valueTest("toHex(-17/256)", "-0x0");
        this.valueTest("toHex(-17/256,1)", "-0x0.1");
        this.valueTest("toHex(-17/256,2)", "-0x0.11");
        this.valueTest("toHex(127/256)", "0x0");
        this.valueTest("toHex(127/256,1)", "0x0.8");
        this.valueTest("toHex(127/256,2)", "0x0.7f");
        this.valueTest("toHex(-127/256)", "-0x0");
        this.valueTest("toHex(-127/256,1)", "-0x0.8");
        this.valueTest("toHex(-127/256,2)", "-0x0.7f");
        this.valueTest("toHex(128/256)", "0x1");
        this.valueTest("toHex(128/256,1)", "0x0.8");
        this.valueTest("toHex(128/256,2)", "0x0.80");
        this.valueTest("toHex(-128/256)", "-0x1");
        this.valueTest("toHex(-128/256,1)", "-0x0.8");
        this.valueTest("toHex(-128/256,2)", "-0x0.80");
        this.valueTest("toHex(240/256)", "0x1");
        this.valueTest("toHex(240/256,1)", "0x0.f");
        this.valueTest("toHex(240/256,2)", "0x0.f0");
        this.valueTest("toHex(-240/256)", "-0x1");
        this.valueTest("toHex(-240/256,1)", "-0x0.f");
        this.valueTest("toHex(-240/256,2)", "-0x0.f0");
        this.valueTest("toHex(248/256)", "0x1");
        this.valueTest("toHex(248/256,1)", "0x1.0");
        this.valueTest("toHex(248/256,2)", "0x0.f8");
        this.valueTest("toHex(-248/256)", "-0x1");
        this.valueTest("toHex(-248/256,1)", "-0x1.0");
        this.valueTest("toHex(-248/256,2)", "-0x0.f8");
        this.valueTest("toHex(1/4096)", "0x0");
        this.valueTest("toHex(1/4096,1)", "0x0.0");
        this.valueTest("toHex(1/4096,2)", "0x0.00");
        this.valueTest("toHex(1/4096,3)", "0x0.001");
        this.valueTest("toHex(1/4096,4)", "0x0.0010");
        this.valueTest("toHex(1+1/4096)", "0x1");
        this.valueTest("toHex(1+1/4096,1)", "0x1.0");
        this.valueTest("toHex(1+1/4096,2)", "0x1.00");
        this.valueTest("toHex(1+1/4096,3)", "0x1.001");
        this.valueTest("toHex(1+1/4096,4)", "0x1.0010");
        XJep xJep = (XJep)this.j;
        BaseFormat baseFormat = new BaseFormat(16, "0x");
        baseFormat.setMaximumFractionDigits(0);
        xJep.getPrintVisitor().setNumberFormat(baseFormat);
        String string = "10 x+15 x^2 - 16 x^3 + 32 x^4 - 256 x^5";
        Node node = xJep.parse(string);
        String string2 = xJep.toString(node);
        this.myAssertEquals(string, "0xa*x+0xf*x^0x2-0x10*x^0x3+0x20*x^0x4-0x100*x^0x5", string2);
    }

    public void testDefine() throws Exception {
        XJep xJep = (XJep)this.j;
    }

    public void testBad() throws Exception {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

