/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.nfunk.jep.JEP;

class Console {
    private String prompt = "JEP > ";
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] stringArray) throws IOException {
        Console console = new Console();
        console.run(stringArray);
    }

    public void run(String[] stringArray) throws IOException {
        String string = "";
        JEP jEP = new JEP();
        jEP.addStandardConstants();
        jEP.addStandardFunctions();
        jEP.addComplex();
        if (stringArray.length > 0) {
            String string2 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + " " + stringArray[i];
            }
            jEP.parseExpression(string2);
            if (jEP.hasError()) {
                System.out.println(jEP.getErrorInfo());
            } else {
                System.out.println(jEP.getValueAsObject());
            }
        } else {
            System.out.println("JEP - Enter q to quit");
            System.out.print(this.prompt);
            while ((string = this.getCommand()) != null) {
                jEP.parseExpression(string);
                if (jEP.hasError()) {
                    System.out.println(jEP.getErrorInfo());
                } else {
                    Object object = jEP.getValueAsObject();
                    if (jEP.hasError()) {
                        System.out.println(jEP.getErrorInfo());
                    } else {
                        System.out.println(object);
                    }
                }
                System.out.print(this.prompt);
            }
        }
    }

    private String getCommand() throws IOException {
        if (this.br == null) {
            return null;
        }
        String string = this.br.readLine();
        if (string == null) {
            return null;
        }
        if (string.equals("q") || string.equals("quit") || string.equals("exit")) {
            return null;
        }
        return string;
    }
}

