/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.nfunk.jep.JEP;

public class Evaluator
extends Applet {
    private static final long serialVersionUID = 4592714713689369505L;
    private JEP myParser;
    private double xValue;
    private TextField exprField;
    private TextField xField;
    private TextArea errorTextArea;
    private Label resultLabel;
    private Checkbox implicitCheckbox;
    private Checkbox undeclaredCheckbox;

    public static void main(String[] stringArray) {
        Evaluator evaluator = new Evaluator();
        evaluator.init();
        evaluator.start();
        Frame frame = new Frame("Evaluator");
        frame.add("Center", evaluator);
        frame.setSize(400, 200);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public void init() {
        this.xValue = 10.0;
        this.addGUIComponents();
        this.myParser = new JEP();
        this.myParser.initFunTab();
        this.myParser.addStandardFunctions();
        this.myParser.setTraverse(true);
        this.optionsChanged();
    }

    private void addGUIComponents() {
        this.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        Label label = new Label("Expression: ", 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.weightx = 0.8;
        this.exprField = new TextField(27);
        gridBagLayout.setConstraints(this.exprField, gridBagConstraints);
        this.add(this.exprField);
        gridBagConstraints.weightx = 0.0;
        Label label2 = new Label("x: ", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 0;
        this.xField = new TextField("" + this.xValue, 4);
        gridBagLayout.setConstraints(this.xField, gridBagConstraints);
        this.add(this.xField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        Label label3 = new Label("Result: ", 2);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.add(label3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.resultLabel = new Label("", 0);
        gridBagLayout.setConstraints(this.resultLabel, gridBagConstraints);
        this.add(this.resultLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        Label label4 = new Label("Options: ", 2);
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.add(label4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.implicitCheckbox = new Checkbox("Implicit multiplication", true);
        gridBagLayout.setConstraints(this.implicitCheckbox, gridBagConstraints);
        this.add(this.implicitCheckbox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        Label label5 = new Label(" ", 2);
        gridBagLayout.setConstraints(label5, gridBagConstraints);
        this.add(label5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.undeclaredCheckbox = new Checkbox("Allow undeclared identifiers");
        gridBagLayout.setConstraints(this.undeclaredCheckbox, gridBagConstraints);
        this.add(this.undeclaredCheckbox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 11;
        Label label6 = new Label("Errors: ", 2);
        gridBagLayout.setConstraints(label6, gridBagConstraints);
        this.add(label6);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.errorTextArea = new TextArea("");
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setBackground(Color.white);
        gridBagLayout.setConstraints(this.errorTextArea, gridBagConstraints);
        this.add(this.errorTextArea);
        this.exprField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                Evaluator.this.exprFieldTextValueChanged();
            }
        });
        this.xField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                Evaluator.this.xFieldTextValueChanged();
            }
        });
        this.implicitCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Evaluator.this.optionsChanged();
            }
        });
        this.undeclaredCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Evaluator.this.optionsChanged();
            }
        });
    }

    private void parseExpression() {
        this.myParser.initSymTab();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", this.xValue);
        this.myParser.parseExpression(this.exprField.getText());
    }

    private void exprFieldTextValueChanged() {
        this.parseExpression();
        this.updateResult();
    }

    private void xFieldTextValueChanged() {
        try {
            this.xValue = Double.valueOf(this.xField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid format in xField");
            this.xValue = 0.0;
        }
        this.myParser.addVariable("x", this.xValue);
        this.updateResult();
    }

    private void optionsChanged() {
        this.myParser.setImplicitMul(this.implicitCheckbox.getState());
        this.myParser.setAllowUndeclared(this.undeclaredCheckbox.getState());
        this.parseExpression();
        this.updateResult();
    }

    private void updateResult() {
        Object object = this.myParser.getValueAsObject();
        if (object != null) {
            this.resultLabel.setText(object.toString());
        } else {
            this.resultLabel.setText("");
        }
        String string = this.myParser.getErrorInfo();
        if (string != null) {
            this.errorTextArea.setText(string);
        } else {
            this.errorTextArea.setText("");
        }
    }
}

