/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.TextField;
import java.util.Date;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.evaluation.CommandElement;
import org.nfunk.jep.evaluation.CommandEvaluator;
import org.nfunk.jep.evaluation.ExpressionCompiler;
import org.nfunk.jep.type.Complex;

public class FractalCanvas
extends Canvas {
    private static final long serialVersionUID = -593341831485283712L;
    private int scaleX = 100;
    private int scaleY = 100;
    private Dimension dimensions = this.getSize();
    private int iterations = 20;
    private int nEvals = 0;
    private boolean hasError = true;
    private JEP myParser;
    private ExpressionCompiler expressionCompiler;
    private CommandEvaluator evaluator;
    private CommandElement[] commands;
    private SymbolTable symTab;
    private TextField exprField;

    public FractalCanvas(String string, TextField textField) {
        this.exprField = textField;
        this.initParser(string);
        this.expressionCompiler = new ExpressionCompiler();
        this.evaluator = new CommandEvaluator();
        this.symTab = this.myParser.getSymbolTable();
    }

    private void initParser(String string) {
        this.myParser = new JEP();
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("z", 0.0, 0.0);
        this.myParser.addVariable("c", 0.0, 0.0);
        this.setExpressionString(string);
    }

    public void setExpressionString(String string) {
        this.nEvals = 0;
        this.myParser.parseExpression(string);
        this.hasError = this.myParser.hasError();
        if (this.hasError) {
            this.exprField.setForeground(Color.red);
        } else {
            this.exprField.setForeground(Color.black);
        }
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    private void paintWhite(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.dimensions.width, this.dimensions.height);
    }

    private void paintFractalSansJEP(Graphics graphics) {
        System.out.println("paintFractalSansJEP()");
        System.out.println("done.");
    }

    private void paintRegion(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            double d = (double)(n + n3 / 2 - 230) / (double)this.scaleX;
            double d2 = (double)(n2 + n4 / 2 - 150) / (double)this.scaleY;
            int n7 = 0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            while (n7 < this.iterations && d5 + d6 < 4.0) {
                double d7 = 2.0 * d3 * d4;
                d3 = d5 - d6 + d;
                d4 = d7 + d2;
                ++n7;
                d5 = d3 * d3;
                d6 = d4 * d4;
                ++this.nEvals;
            }
            if (n7 != this.iterations) {
                graphics.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(n7) / Math.sqrt(this.iterations)))));
                graphics.fillRect(n, n2, n3, n4);
            }
        } else {
            this.paintRegion(graphics, n, n2, n3 / 2, n4 - n4 / 2, n5 + 1, n6);
            this.paintRegion(graphics, n + n3 / 2, n2, n3 - n3 / 2, n4 / 2, n5 + 1, n6);
            this.paintRegion(graphics, n, n2 + n4 / 2, n3 / 2, n4 - n4 / 2, n5 + 1, n6);
            this.paintRegion(graphics, n + n3 / 2, n2 + n4 / 2, n3 - n3 / 2, n4 - n4 / 2, n5 + 1, n6);
        }
    }

    private void paintFractal(Graphics graphics) {
        Complex complex = this.myParser.addVariable("c", 0.0, 0.0);
        Complex complex2 = this.myParser.addVariable("z", 0.0, 0.0);
        for (int i = 0; i <= this.dimensions.width - 1; ++i) {
            for (int j = 0; j <= this.dimensions.height - 1; ++j) {
                int n = 0;
                complex.set((double)(i - 230) / (double)this.scaleX, (double)(j - 150) / (double)this.scaleY);
                complex2.set(0.0, 0.0);
                while (n < this.iterations && complex2.abs2() < 4.0) {
                    complex2.set(this.myParser.getComplexValue());
                    ++n;
                    ++this.nEvals;
                }
                if (n == this.iterations) continue;
                graphics.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(n) / Math.sqrt(this.iterations)))));
                graphics.fillRect(i, j, 1, 1);
            }
        }
    }

    private void paintFractalWithCompiler(Graphics graphics) {
        Complex complex = this.myParser.addVariable("c", 0.0, 0.0);
        Complex complex2 = this.myParser.addVariable("z", 0.0, 0.0);
        try {
            this.commands = this.expressionCompiler.compile(this.myParser.getTopNode());
        }
        catch (ParseException parseException) {
            System.out.println("Failed to compile expression");
            parseException.printStackTrace();
        }
        for (int i = 0; i <= this.dimensions.width - 1; ++i) {
            for (int j = 0; j <= this.dimensions.height - 1; ++j) {
                int n = 0;
                complex.set((double)(i - 230) / (double)this.scaleX, (double)(j - 150) / (double)this.scaleY);
                complex2.set(0.0, 0.0);
                while (n < this.iterations && complex2.abs2() < 4.0) {
                    try {
                        Complex complex3 = (Complex)this.evaluator.evaluate(this.commands, this.symTab);
                        complex2.set(complex3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                    ++this.nEvals;
                }
                if (n == this.iterations) continue;
                graphics.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(n) / Math.sqrt(this.iterations)))));
                graphics.fillRect(i, j, 1, 1);
            }
        }
    }

    private void paintNonJEPFractal(Graphics graphics) {
        for (int i = 0; i <= this.dimensions.width - 1; ++i) {
            for (int j = 0; j <= this.dimensions.height - 1; ++j) {
                double d = (double)(i - 230) / (double)this.scaleX;
                double d2 = (double)(j - 150) / (double)this.scaleY;
                int n = 0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                while (n < this.iterations && d5 + d6 < 4.0) {
                    double d7 = 2.0 * d3 * d4;
                    d3 = d5 - d6 + d;
                    d4 = d7 + d2;
                    d5 = d3 * d3;
                    d6 = d4 * d4;
                    ++n;
                    ++this.nEvals;
                }
                if (n == this.iterations) continue;
                graphics.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(n) / Math.sqrt(this.iterations)))));
                graphics.fillRect(i, j, 1, 1);
            }
        }
    }

    public void paint(Graphics graphics) {
        this.dimensions = this.getSize();
        this.paintWhite(graphics);
        if (!this.hasError) {
            System.out.println("Painting... ");
            Date date = new Date();
            this.nEvals = 0;
            this.paintFractalWithCompiler(graphics);
            Date date2 = new Date();
            System.out.print("done. sec/eval: ");
            double d = (double)(date2.getTime() - date.getTime()) / 1000.0;
            System.out.println(d / (double)this.nEvals);
        }
    }
}

