/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TextField;
import org.nfunk.jep.JEP;

public class GraphCanvas
extends Canvas {
    private static final long serialVersionUID = -3169263228971794887L;
    private int scaleX = 1;
    private int scaleY = 1;
    private Dimension dimensions = this.getSize();
    private Image buffer;
    private boolean initializedBuffer = false;
    private boolean changedFunction = true;
    private boolean hasError = true;
    private JEP myParser;
    private TextField exprField;

    public GraphCanvas(String string, TextField textField) {
        this.exprField = textField;
        this.initParser(string);
    }

    private void initParser(String string) {
        this.myParser = new JEP();
        this.myParser.setImplicitMul(true);
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", 0.0);
        this.setExpressionString(string);
    }

    public void setExpressionString(String string) {
        this.myParser.parseExpression(string);
        this.hasError = this.myParser.hasError();
        if (this.hasError) {
            this.exprField.setForeground(Color.red);
        } else {
            this.exprField.setForeground(Color.black);
        }
        this.changedFunction = true;
    }

    private double getYValue(double d) {
        this.myParser.addVariable("x", d);
        return this.myParser.getValue();
    }

    private void paintWhite(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.dimensions.width, this.dimensions.height);
    }

    private void paintAxes(Graphics graphics) {
        graphics.setColor(new Color(204, 204, 204));
        graphics.drawLine(0, this.dimensions.height / 2, this.dimensions.width - 1, this.dimensions.height / 2);
        graphics.drawLine(this.dimensions.width / 2, 0, this.dimensions.width / 2, this.dimensions.height - 1);
    }

    private void paintCurve(Graphics2D graphics2D) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        graphics2D.setColor(Color.black);
        int n3 = 0;
        while (n3 <= this.dimensions.width - 1) {
            double d = (n3 - this.dimensions.width / 2) / this.scaleX;
            double d2 = this.getYValue(d);
            int n4 = (int)(-d2 * (double)this.scaleY + (double)(this.dimensions.height / 2));
            if (n4 > this.dimensions.height) {
                n4 = this.dimensions.height;
            }
            if (n4 < -1) {
                n4 = -1;
            }
            if (!bl) {
                graphics2D.drawLine(n, n2, n3, n4);
            } else {
                bl = false;
            }
            n = n3++;
            n2 = n4;
        }
    }

    public void paint(Graphics graphics) {
        boolean bl = !this.dimensions.equals(this.getSize());
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.initializedBuffer || bl) {
            this.dimensions = this.getSize();
            this.buffer = this.createImage(this.dimensions.width, this.dimensions.height);
            this.initializedBuffer = true;
        }
        Graphics2D graphics2D2 = (Graphics2D)this.buffer.getGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.changedFunction || bl) {
            this.paintWhite(graphics2D2);
            this.paintAxes(graphics2D2);
            if (!this.hasError) {
                this.paintCurve(graphics2D2);
            }
            this.changedFunction = false;
        }
        graphics2D.drawImage(this.buffer, 0, 0, null);
    }
}

