/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jeptesting;

import java.util.Enumeration;
import java.util.Random;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;

public class BugsTest
extends TestCase {
    private JEP jep;

    public BugsTest(String string) {
        super(string);
    }

    public void setUp() {
        this.jep = new JEP();
        this.jep.setImplicitMul(true);
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addComplex();
        this.jep.setTraverse(false);
    }

    public void testOpSetBug() {
        JEP jEP = new JEP(false, true, true, null);
        Assert.assertNotNull((Object)jEP.getOperatorSet());
    }

    public void testHasError() {
        this.jep.addFunction("custFunc", new CustFunc());
        this.jep.parseExpression("custFunc(-1)");
        Assert.assertTrue((!this.jep.hasError() ? 1 : 0) != 0);
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("custFunc(1, 1)");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("1+");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("sin([1, 1])");
        Assert.assertTrue((!this.jep.hasError() ? 1 : 0) != 0);
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
    }

    public void testSetAllowUndeclared() {
        this.jep.initSymTab();
        this.jep.setAllowUndeclared(true);
        this.jep.parseExpression("x");
        SymbolTable symbolTable = this.jep.getSymbolTable();
        int n = 0;
        Enumeration enumeration = symbolTable.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            Assert.assertTrue((boolean)variable.getName().equals("x"));
            ++n;
        }
        Assert.assertTrue((n == 1 ? 1 : 0) != 0);
    }

    public void testBug1563324() {
        this.jep.initSymTab();
        this.jep.setAllowUndeclared(true);
        this.jep.parseExpression("abs(x)");
        this.jep.addVariable("x", new Random());
        Object object = this.jep.getValueAsObject();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.addVariable("x", -1.0);
        object = this.jep.getValueAsObject();
        Assert.assertTrue((object instanceof Double && (Double)object == 1.0 ? 1 : 0) != 0);
    }

    private class CustFunc
    extends PostfixMathCommand {
        public CustFunc() {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (!(e instanceof Number) || !(((Number)e).doubleValue() > 0.0)) {
                System.out.println("Throwing exception");
                throw new ParseException("Parameter is not a Number or not >0");
            }
            stack.push(e);
        }
    }
}

