/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jeptesting;

import java.io.BufferedReader;
import java.io.FileReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nfunk.jep.JEP;
import org.nfunk.jep.type.Complex;

public class JEPTest
extends TestCase {
    JEP myParser;
    int lineCount;

    public JEPTest(String string) {
        super(string);
    }

    public void setUp() {
        this.myParser = new JEP();
        this.myParser.setImplicitMul(true);
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.setTraverse(false);
        this.lineCount = 0;
    }

    public void runTest() {
        String string = "JEPTestExpressions.txt";
        this.testWithFile(string);
        this.testGetValue();
        this.testGetComplexValue();
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        } else {
            string = "JEPTestExpressions.txt";
            JEPTest.println("Using default input file: " + string);
            JEPTest.println("Start with \"java org.nfunk.jepexamples.JEPTest <filename>\" to load a different input file.");
        }
        JEPTest jEPTest = new JEPTest("JEP Test");
        jEPTest.setUp();
        jEPTest.testWithFile(string);
    }

    public void testWithFile() {
        this.testWithFile("JEPTestExpressions.txt");
    }

    public void testWithFile(String string) {
        BufferedReader bufferedReader;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)false);
            JEPTest.println("File \"" + string + "\" not found");
            return;
        }
        this.lineCount = 0;
        JEPTest.println("Evaluating and comparing expressions...");
        while (true) {
            Object object;
            Object object2;
            try {
                object2 = this.parseNextLine(bufferedReader);
                object = this.parseNextLine(bufferedReader);
            }
            catch (Exception exception) {
                JEPTest.println(exception.getMessage());
                bl = true;
                break;
            }
            if (object2 == null || object == null) {
                JEPTest.println("Reached end of file.");
                break;
            }
            if (this.equal(object2, object)) continue;
            bl = true;
            JEPTest.print("Line: " + this.lineCount + ": ");
            JEPTest.println(object2.toString() + " != " + object.toString());
            Assert.fail();
        }
        JEPTest.print("\n" + this.lineCount + " lines processed. ");
        if (bl) {
            JEPTest.print("Errors were found.\n\n");
        } else {
            JEPTest.print("No errors were found.\n\n");
        }
    }

    private Object parseNextLine(BufferedReader bufferedReader) throws Exception {
        String string;
        do {
            if ((string = bufferedReader.readLine()) == null) {
                return null;
            }
            ++this.lineCount;
        } while (string.length() == 0 || string.trim().charAt(0) == '#');
        this.myParser.parseExpression(string);
        if (this.myParser.hasError()) {
            String string2 = this.myParser.getErrorInfo();
            throw new Exception("Error while parsing line " + this.lineCount + ": " + string2);
        }
        Object object = this.myParser.getValueAsObject();
        if (object == null || this.myParser.hasError()) {
            String string3 = this.myParser.getErrorInfo();
            throw new Exception("Error while evaluating line " + this.lineCount + ": " + string3);
        }
        return object;
    }

    private boolean equal(Object object, Object object2) {
        double d = 1.0E-15;
        if (object instanceof Complex && object2 instanceof Complex) {
            return ((Complex)object).equals((Complex)object2, d);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return ((Complex)object).equals(new Complex((Number)object2), d);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return ((Complex)object2).equals(new Complex((Number)object), d);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return Math.abs(((Number)object).doubleValue() - ((Number)object2).doubleValue()) < d;
        }
        return object.equals(object2);
    }

    public void testGetValue() {
        this.myParser.parseExpression("2.1345");
        Assert.assertEquals((double)this.myParser.getValue(), (double)2.1345, (double)0.0);
        this.myParser.parseExpression("i");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
        this.myParser.parseExpression("\"asdf\"");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
    }

    public void testGetComplexValue() {
        this.myParser.parseExpression("2.1345");
        Assert.assertTrue((boolean)new Complex(2.1345, 0.0).equals(this.myParser.getComplexValue(), 0.0));
        this.myParser.parseExpression("i");
        Complex complex = this.myParser.getComplexValue();
        Assert.assertTrue((complex != null ? 1 : 0) != 0);
        Assert.assertTrue((complex.re() == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((complex.im() == 1.0 ? 1 : 0) != 0);
        this.myParser.parseExpression("\"asdf\"");
        Assert.assertTrue((boolean)Double.isNaN(this.myParser.getValue()));
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void println(String string) {
        System.out.println(string);
    }
}

