/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.route.navigation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.infor.node.SegmentWay;
import ru.infor.route.navigation.DBProvider;
import ru.infor.route.navigation.DijkstraNode;
import ru.infor.route.navigation.IRoutingParameter;
import ru.infor.route.navigation.LengthParam;
import ru.infor.route.navigation.NRelations;
import ru.infor.route.navigation.Navigator;
import ru.infor.route.navigation.NodeStatus;
import ru.infor.route.navigation.RouteFitnessID;
import ru.infor.route.navigation.TimeParam;

public class Calculation
implements Navigator {
    private List<DijkstraNode> comingRoute = new ArrayList<DijkstraNode>();
    private Double shortLength = Double.POSITIVE_INFINITY;
    private Map<Long, Double> localDist = new HashMap<Long, Double>();
    private DijkstraNode startPoint;
    private DijkstraNode finishPoint;
    private Connection conn;
    private DBProvider provider;
    static Map<RouteFitnessID, IRoutingParameter> paramList = new HashMap<RouteFitnessID, IRoutingParameter>();

    static {
        paramList.put(RouteFitnessID.LENGTH, new LengthParam());
        paramList.put(RouteFitnessID.TIME, new TimeParam());
    }

    public Double getShortLength() {
        return this.shortLength;
    }

    public void setProvider(DBProvider provider) {
        this.provider = provider;
    }

    public DijkstraNode[] getRouteWith(DijkstraNode a, DijkstraNode b, Double limitRange, RouteFitnessID param) {
        DijkstraNode cur;
        if (param == null) {
            param = RouteFitnessID.LENGTH;
        }
        this.conn = this.provider.getConnection();
        this.startPoint = a;
        this.startPoint.setId(-1L);
        this.finishPoint = b;
        this.finishPoint.setId(-1000L);
        this.getStartNodesWithParam(param);
        this.getFinishNodesWithParam(param);
        while (true) {
            Collections.sort(this.comingRoute, new Comparator<DijkstraNode>(){

                @Override
                public int compare(DijkstraNode o1, DijkstraNode o2) {
                    if (o1.isVisited()) {
                        return 1;
                    }
                    if (o2.isVisited()) {
                        return -1;
                    }
                    return o1.getFitness().compareTo(o2.getFitness());
                }
            });
            cur = this.comingRoute.get(0);
            if (cur.isVisited() || cur.getFitness() == Double.POSITIVE_INFINITY) break;
            this.wayLengthWithParam(cur, limitRange, param);
        }
        this.provider.closeConnection(this.conn);
        cur = this.finishPoint;
        if (cur.getPrev() == null) {
            return null;
        }
        ArrayList<DijkstraNode> result = new ArrayList<DijkstraNode>();
        while (cur != null) {
            result.add(0, cur);
            cur = cur.getPrev();
        }
        return result.toArray(new DijkstraNode[result.size()]);
    }

    @Override
    public DijkstraNode[] getRouteWithParameter(DijkstraNode a, DijkstraNode b, RouteFitnessID param) {
        return this.getRoute(a, b, null, param);
    }

    @Override
    public DijkstraNode[] getRoute(DijkstraNode a, DijkstraNode b, Double limitRange) {
        return this.getRoute(a, b, limitRange, null);
    }

    @Override
    public DijkstraNode[] getRoute(DijkstraNode a, DijkstraNode b) {
        return this.getRoute(a, b, null, null);
    }

    private void getStartNodesWithParam(RouteFitnessID param) {
        this.startPoint.setFitness(0.0);
        this.comingRoute.add(this.startPoint);
        try {
            Statement stNodes = this.conn.createStatement();
            String queryText = "select st_numPoints(st_transform(ST_line_substring(st_transform(tab.ls,2319), 0, line_point),4326)) as num, way_id, ST_line_locate_point (st_transform(tab.ls,2319),st_transform(start_point,2319)) as koef, st_x(st_transform(ST_line_interpolate_point(st_transform(tab.ls,2319), line_point),4326)) as koordx, st_y(st_transform(ST_line_interpolate_point(st_transform(tab.ls,2319), line_point),4326)) as koordy from (select ST_Distance_Spheroid(st_transform(ST_line_interpolate_point(st_transform(w.linestring,2319), ST_line_locate_point (st_transform(w.linestring,2319),st_transform(start_point,2319))),4326), start_point,'SPHEROID[\"WGS-84\",6378137,298.257223563]') as dist, w.linestring as ls, w.id as way_id, start_point, ST_line_locate_point (st_transform(w.linestring,2319),st_transform(start_point,2319)) as line_point from ways as w, way_tags as wt, ST_SetSRID(ST_POINT(" + this.startPoint.getLongitude() + "," + this.startPoint.getLatitude() + "), 4326) as start_point " + "where (w.id = wt.way_id and wt.k = 'highway' and not (wt.v='footway') ) " + "order by dist limit 1) as tab";
            ResultSet nodes = stNodes.executeQuery(queryText);
            Integer seq_id_bot = null;
            Integer seq_id_top = null;
            Long start_line = null;
            DijkstraNode secNode = new DijkstraNode(-2L);
            while (nodes.next()) {
                start_line = nodes.getLong("way_id");
                seq_id_top = nodes.getInt("num") - 1;
                secNode.setLongitude(nodes.getDouble("koordx"));
                secNode.setLatitude(nodes.getDouble("koordy"));
                secNode.setPrev(this.startPoint);
                secNode.setStatus(NodeStatus.ONLINE);
                if (nodes.getDouble("koef") > 0.0 && nodes.getDouble("koef") < 1.0) {
                    seq_id_bot = nodes.getInt("num") - 2;
                    continue;
                }
                if (nodes.getInt("koef") >= 1) continue;
                seq_id_top = 0;
            }
            NRelations startRelat = new NRelations(secNode);
            double nd = Double.POSITIVE_INFINITY;
            for (Map.Entry<RouteFitnessID, IRoutingParameter> row : paramList.entrySet()) {
                nd = row.getValue().calc(this.startPoint, secNode, this.provider);
                if (row.getKey().equals(param)) {
                    startRelat.setFitness(nd);
                    secNode.setFitness(nd);
                    continue;
                }
                startRelat.putParameter(row.getKey(), nd);
                secNode.putParamMap(row.getKey(), nd);
            }
            this.comingRoute.add(secNode);
            this.startPoint.addRelations(startRelat);
            Statement neighborSt = this.conn.createStatement();
            queryText = "select wn.node_id, st_x(n.geom) as lon, st_y(n.geom) as lat from way_nodes as wn, nodes as n where wn.way_id = " + start_line + " and wn.node_id = n.id " + " and wn.sequence_id in (" + seq_id_top;
            if (seq_id_bot != null) {
                queryText = queryText.concat("," + seq_id_bot);
            }
            queryText = queryText.concat(")");
            DijkstraNode nod = null;
            List<SegmentWay> segment = null;
            ResultSet node_id = neighborSt.executeQuery(queryText);
            while (node_id.next()) {
                nod = new DijkstraNode(node_id.getLong(1));
                nod.setPrev(secNode);
                nod.setLongitude(node_id.getDouble("lon"));
                nod.setLatitude(node_id.getDouble("lat"));
                NRelations relations = new NRelations(nod);
                nd = Double.POSITIVE_INFINITY;
                for (Map.Entry<RouteFitnessID, IRoutingParameter> row : paramList.entrySet()) {
                    nd = row.getValue().calc(secNode, nod, this.provider);
                    if (row.getKey().equals(param)) {
                        relations.setFitness(nd);
                        nod.setFitness(nd);
                        continue;
                    }
                    relations.putParameter(row.getKey(), nd);
                    nod.putParamMap(row.getKey(), nd);
                }
                secNode.addRelations(relations);
                this.comingRoute.add(nod);
            }
            if (secNode.getRelations().size() > 1 && (segment = this.provider.getRestrictions(secNode.getRelations().get(0).getDest().getId())) != null) {
                NRelations holeRel = null;
                for (SegmentWay segmentWay : segment) {
                    if (!segmentWay.getNode1().equals(secNode.getRelations().get(1).getDest()) && !segmentWay.getNode2().equals(secNode.getRelations().get(1).getDest())) continue;
                    if ((secNode.getLatitude() - secNode.getRelations().get(0).getDest().getLatitude()) * (secNode.getLatitude() - segmentWay.getLinePoint().getLatitude()) > 0.0) {
                        holeRel = new NRelations(secNode.getRelations().get(0).getDest());
                        this.comingRoute.remove(secNode.getRelations().get(0).getDest());
                        continue;
                    }
                    holeRel = new NRelations(secNode.getRelations().get(1).getDest());
                    this.comingRoute.remove(secNode.getRelations().get(1).getDest());
                }
                secNode.remRelation(holeRel);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public DijkstraNode createDijkstraNode(Double lon, Double lat, Long id) {
        DijkstraNode dPoint = new DijkstraNode(id);
        dPoint.setLatitude(lat);
        dPoint.setLongitude(lon);
        dPoint.setStatus(NodeStatus.PRIMARY);
        return dPoint;
    }

    private void getFinishNodesWithParam(RouteFitnessID param) {
        this.comingRoute.add(this.finishPoint);
        try {
            List<SegmentWay> segment;
            ArrayList<DijkstraNode> predFinish = new ArrayList<DijkstraNode>();
            this.conn = this.provider.getConnection();
            Statement stNodes = this.conn.createStatement();
            String queryText = "select st_numPoints(st_transform(ST_line_substring(st_transform(tab.ls,2319), 0, line_point),4326)) as num, way_id, ST_line_locate_point (st_transform(tab.ls,2319),st_transform(start_point,2319)) as koef, st_x(st_transform(ST_line_interpolate_point(st_transform(tab.ls,2319), line_point),4326)) as koordx, st_y(st_transform(ST_line_interpolate_point(st_transform(tab.ls,2319), line_point),4326)) as koordy from (select ST_Distance_Spheroid(st_transform(ST_line_interpolate_point(st_transform(w.linestring,2319), ST_line_locate_point (st_transform(w.linestring,2319),st_transform(start_point,2319))),4326), start_point,'SPHEROID[\"WGS-84\",6378137,298.257223563]') as dist, w.linestring as ls, w.id as way_id, start_point, ST_line_locate_point (st_transform(w.linestring,2319),st_transform(start_point,2319)) as line_point from ways as w, way_tags as wt, ST_SetSRID(ST_POINT(" + this.finishPoint.getLongitude() + "," + this.finishPoint.getLatitude() + "), 4326) as start_point " + "where (w.id = wt.way_id and wt.k = 'highway' and not (wt.v='footway') ) " + "order by dist limit 1) as tab";
            ResultSet nodes = stNodes.executeQuery(queryText);
            Integer seq_id_bot = null;
            Integer seq_id_top = null;
            Long start_line = null;
            DijkstraNode secNode = new DijkstraNode(-200L);
            if (nodes.next()) {
                start_line = nodes.getLong("way_id");
                seq_id_top = nodes.getInt("num") - 1;
                secNode.setLongitude(nodes.getDouble("koordx"));
                secNode.setLatitude(nodes.getDouble("koordy"));
                secNode.setStatus(NodeStatus.ONLINE);
                if (nodes.getDouble("koef") > 0.0 && nodes.getDouble("koef") < 1.0) {
                    seq_id_bot = nodes.getInt("num") - 2;
                } else if (nodes.getInt("koef") < 1) {
                    seq_id_top = 0;
                }
                NRelations startRelat = new NRelations(this.finishPoint);
                double nd = Double.POSITIVE_INFINITY;
                for (Map.Entry entry : paramList.entrySet()) {
                    nd = ((IRoutingParameter)entry.getValue()).calc(secNode, this.finishPoint, this.provider);
                    if (((RouteFitnessID)entry.getKey()).equals(param)) {
                        startRelat.setFitness(nd);
                        continue;
                    }
                    startRelat.putParameter((RouteFitnessID)entry.getKey(), nd);
                }
                secNode.addRelations(startRelat);
                this.comingRoute.add(secNode);
            }
            Statement neighborSt = this.conn.createStatement();
            queryText = "select wn.node_id, st_x(n.geom) as lon, st_y(n.geom) as lat from way_nodes as wn, nodes as n where way_id = " + start_line + " and wn.node_id = n.id and sequence_id in (" + seq_id_top;
            if (seq_id_bot != null) {
                queryText = queryText.concat("," + seq_id_bot);
            }
            queryText = queryText.concat(")");
            ResultSet node_id = neighborSt.executeQuery(queryText);
            while (node_id.next()) {
                DijkstraNode nod = new DijkstraNode(node_id.getLong(1));
                nod.setLongitude(node_id.getDouble("lon"));
                nod.setLatitude(node_id.getDouble("lat"));
                nod.setStatus(NodeStatus.MAPFINISH);
                NRelations nRelations = new NRelations(secNode);
                double nd = Double.POSITIVE_INFINITY;
                for (Map.Entry<RouteFitnessID, IRoutingParameter> row : paramList.entrySet()) {
                    nd = row.getValue().calc(nod, secNode, this.provider);
                    if (row.getKey().equals(param)) {
                        nRelations.setFitness(nd);
                        continue;
                    }
                    nRelations.putParameter(row.getKey(), nd);
                }
                nod.addRelations(nRelations);
                this.comingRoute.add(nod);
                predFinish.add(nod);
            }
            if (predFinish.size() > 1 && (segment = this.provider.getRestrictions(((DijkstraNode)predFinish.get(0)).getId())) != null) {
                for (SegmentWay segmentWay : segment) {
                    if (!segmentWay.getNode1().equals(predFinish.get(1)) && !segmentWay.getNode2().equals(predFinish.get(1))) continue;
                    if ((secNode.getLatitude() - ((DijkstraNode)predFinish.get(0)).getLatitude()) * (secNode.getLatitude() - segmentWay.getLinePoint().getLatitude()) > 0.0) {
                        this.comingRoute.remove(predFinish.get(0));
                        continue;
                    }
                    this.comingRoute.remove(predFinish.get(1));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void wayLengthWithParam(DijkstraNode startNode, Double limitRange, RouteFitnessID param) {
        startNode.setVisited(true);
        Double curLength = startNode.getFitness();
        if (limitRange != null && curLength > limitRange) {
            return;
        }
        if (curLength > this.shortLength) {
            return;
        }
        List<DijkstraNode> neighborNodes = this.getNeighborNodes1(startNode, param);
        int i = 0;
        while (i < neighborNodes.size()) {
            DijkstraNode segmentName = neighborNodes.get(i);
            if (!this.comingRoute.contains(segmentName)) {
                this.comingRoute.add(segmentName);
            } else {
                segmentName = this.comingRoute.get(this.comingRoute.indexOf(segmentName));
            }
            NRelations relat = new NRelations(segmentName);
            Double dist1 = this.localDist.get(segmentName.getId());
            relat.setFitness(dist1);
            if (dist1 + curLength < segmentName.getFitness()) {
                segmentName.setFitness(dist1 + curLength);
                segmentName.setPrev(startNode);
                NRelations curRelat = startNode.getRelations().get(startNode.getRelations().indexOf(relat));
                for (Map.Entry<RouteFitnessID, Double> parameter : curRelat.getParameters().entrySet()) {
                    segmentName.putParamMap(parameter.getKey(), startNode.getParamMapItem(parameter.getKey()) + parameter.getValue());
                }
            }
            startNode.addRelations(relat);
            ++i;
        }
        if (neighborNodes.contains(this.finishPoint) && neighborNodes.get(neighborNodes.indexOf(this.finishPoint)).getFitness() < this.shortLength) {
            this.finishPoint = neighborNodes.get(neighborNodes.indexOf(this.finishPoint));
            this.shortLength = this.finishPoint.getFitness();
            return;
        }
    }

    private List<DijkstraNode> getNeighborNodes1(DijkstraNode node, RouteFitnessID param) {
        ArrayList<DijkstraNode> neighborNodes = new ArrayList<DijkstraNode>();
        this.localDist.clear();
        if (node.getStatus() != NodeStatus.MAPNODE) {
            int i = 0;
            while (i < node.getRelations().size()) {
                neighborNodes.add(node.getRelations().get(i).getDest());
                this.localDist.put(node.getRelations().get(i).getDest().getId(), node.getRelations().get(i).getFitness());
                ++i;
            }
            return neighborNodes;
        }
        String queryText = "select distinct node_id as id, st_x(n1.geom) as lon, st_y(n1.geom) as lat from way_tags as wt, way_nodes as wn join (select w.way_id, w.sequence_id, n.geom as geom from way_nodes as w, nodes as n where w.node_id = " + node.getId() + " and w.node_id=n.id) as tt " + "on (wn.way_id = tt.way_id) and (abs(wn.sequence_id - tt.sequence_id)=1) " + "join nodes as n1 on n1.id=wn.node_id " + "where wn.way_id=wt.way_id and wt.k = 'highway' and not (wt.v='footway') ";
        try {
            Statement stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery(queryText);
            List<SegmentWay> restrictionList = this.provider.getRestrictions(node.getId());
            while (rs.next()) {
                boolean flagClear = true;
                Long d = rs.getLong("id");
                DijkstraNode cur = new DijkstraNode(d);
                if (restrictionList != null) {
                    for (SegmentWay segmentWay : restrictionList) {
                        if (!segmentWay.getNode1().equals(cur) && !segmentWay.getNode2().equals(cur)) continue;
                        flagClear = false;
                    }
                }
                if (this.comingRoute.contains(cur) && this.comingRoute.get(this.comingRoute.indexOf(cur)).isVisited() || !flagClear) continue;
                cur.setLongitude(rs.getDouble("lon"));
                cur.setLatitude(rs.getDouble("lat"));
                double nd = Double.POSITIVE_INFINITY;
                NRelations relat = new NRelations(cur);
                for (Map.Entry<RouteFitnessID, IRoutingParameter> row : paramList.entrySet()) {
                    nd = row.getValue().calc(node, cur, this.provider);
                    if (row.getKey().equals(param)) {
                        relat.setFitness(nd);
                        this.localDist.put(d, nd);
                        continue;
                    }
                    relat.putParameter(row.getKey(), nd);
                }
                node.addRelations(relat);
                neighborNodes.add(cur);
            }
            stat.close();
            return neighborNodes;
        }
        catch (SQLException e) {
            System.out.println(queryText);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DijkstraNode[] getRoute(DijkstraNode dijkstranode, DijkstraNode dijkstranode1, RouteFitnessID param) {
        return this.getRoute(dijkstranode, dijkstranode1, null, param);
    }

    @Override
    public DijkstraNode[] getRoute(DijkstraNode dijkstranode, DijkstraNode dijkstranode1, Double limitRange, RouteFitnessID param) {
        return this.getRouteWith(dijkstranode, dijkstranode1, limitRange, param);
    }
}

