/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.route.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.infor.route.navigation.NRelations;
import ru.infor.route.navigation.NodeStatus;
import ru.infor.route.navigation.RouteFitnessID;

public class DijkstraNode {
    private long id;
    private Double fitness = Double.POSITIVE_INFINITY;
    private boolean visited = false;
    private DijkstraNode prev = null;
    private NodeStatus status = NodeStatus.MAPNODE;
    private List<NRelations> relations = new ArrayList<NRelations>();
    private Double longitude = null;
    private Double latitude = null;
    private HashMap<RouteFitnessID, Double> paramMap;

    public String toString() {
        return this.longitude + "," + this.latitude;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DijkstraNode)) {
            return false;
        }
        return this.id == ((DijkstraNode)obj).getId();
    }

    public List<NRelations> getRelations() {
        return this.relations;
    }

    public void addRelations(NRelations relations) {
        this.relations.add(relations);
    }

    public void remRelation(NRelations relations) {
        this.relations.remove(relations);
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus virtual) {
        this.status = virtual;
    }

    public DijkstraNode getPrev() {
        return this.prev;
    }

    public void setPrev(DijkstraNode prev) {
        this.prev = prev;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Double getFitness() {
        return this.fitness;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public DijkstraNode(Long id) {
        this.id = id;
        this.paramMap = new HashMap();
    }

    public void setParamMap(HashMap<RouteFitnessID, Double> paramMap) {
        this.paramMap = paramMap;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void putParamMap(RouteFitnessID key, Double value) {
        this.paramMap.put(key, value);
    }

    public Double getParamMapItem(RouteFitnessID key) {
        return this.paramMap.get(key);
    }

    public HashMap<RouteFitnessID, Double> getParamMap() {
        return this.paramMap;
    }
}

