/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.cartography;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import ru.infor.ws.objects.cartography.entities.MapEntryKey;
import ru.infor.ws.objects.cartography.entities.MapEntryKeyDateRange;
import ru.infor.ws.objects.cartography.entities.MapEntryKeyValue;

public class MapEntryKeyFilter
implements Serializable {
    private static final long serialVersionUID = -818868187486984051L;
    private MapEntryKeyValue[] values;
    private MapEntryKeyDateRange[] dateRanges;
    private Integer invertion;

    public MapEntryKeyValue[] getValues() {
        return this.values;
    }

    public void setValues(MapEntryKeyValue[] values) {
        this.values = values;
    }

    public MapEntryKeyDateRange[] getDateRanges() {
        return this.dateRanges;
    }

    public void setDateRanges(MapEntryKeyDateRange[] dateRanges) {
        this.dateRanges = dateRanges;
    }

    public MapEntryKey[] retrieveKeys() {
        ArrayList<MapEntryKey> res = new ArrayList<MapEntryKey>();
        if (this.values != null && this.values.length > 0) {
            res.addAll(Arrays.asList(this.values));
        }
        if (this.dateRanges != null && this.dateRanges.length > 0) {
            res.addAll(Arrays.asList(this.dateRanges));
        }
        return res.isEmpty() ? null : res.toArray(new MapEntryKey[res.size()]);
    }

    protected static final MapEntryKeyFilter getInstance(MapEntryKey[] keys) {
        MapEntryKeyFilter f = new MapEntryKeyFilter();
        if (keys == null || keys.length == 0) {
            return f;
        }
        ArrayList<MapEntryKeyValue> values = new ArrayList<MapEntryKeyValue>();
        ArrayList<MapEntryKeyDateRange> dateRanges = new ArrayList<MapEntryKeyDateRange>();
        MapEntryKey[] mapEntryKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            MapEntryKey key = mapEntryKeyArray[n2];
            if (key instanceof MapEntryKeyValue) {
                MapEntryKeyValue v = (MapEntryKeyValue)key;
                values.add(v);
            } else {
                dateRanges.add((MapEntryKeyDateRange)key);
            }
            ++n2;
        }
        if (!values.isEmpty()) {
            f.setValues(values.toArray(new MapEntryKeyValue[values.size()]));
        }
        if (!dateRanges.isEmpty()) {
            f.setDateRanges(dateRanges.toArray(new MapEntryKeyDateRange[dateRanges.size()]));
        }
        return f;
    }

    public Integer getInvertion() {
        return this.invertion;
    }

    public void setInvertion(Integer invertion) {
        this.invertion = invertion;
    }

    public String toString() {
        return "MapEntryKeyFilter {values = " + Arrays.toString((Object[])this.values) + ", dateRanges = " + Arrays.toString((Object[])this.dateRanges) + ", invertion = " + this.invertion + "}";
    }
}

