/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import ru.infor.beanviewer.core.BaseNode;

public abstract class AbstractNode
implements BaseNode {
    private static final long serialVersionUID = 624832721702188389L;
    private Integer orderNode;
    private transient BaseNode parent;
    private transient List<BaseNode> children = new ArrayList<BaseNode>();

    @Override
    public BaseNode addChild(BaseNode child) {
        ((AbstractNode)child).setParent(this);
        this.children.add(child);
        Collections.sort(this.children);
        return child;
    }

    private void removeFromParent() {
        ((AbstractNode)this.getParent()).removeChild(this);
    }

    @Override
    public void moveChild(BaseNode child) {
        ((AbstractNode)child).removeFromParent();
        this.children.add(child);
        Collections.sort(this.children);
    }

    @Override
    public void removeChild(BaseNode child) {
        this.children.remove(child);
    }

    public List<BaseNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<BaseNode> children) {
        this.children = children;
    }

    public Enumeration<BaseNode> children() {
        return new Enumeration<BaseNode>(){
            Iterator<BaseNode> iterator;
            {
                this.iterator = AbstractNode.this.children.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public BaseNode nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public BaseNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public BaseNode getParent() {
        return this.parent;
    }

    public void setParent(BaseNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    public void removeAllChildren() {
        this.children.clear();
    }

    @Override
    public Integer getOrderNode() {
        return this.orderNode;
    }

    @Override
    public void setOrderNode(Integer order) {
        this.orderNode = order;
    }

    @Override
    public int compareTo(AbstractNode o) {
        int ret = 0;
        if (this.getOrderNode() == null || o.getOrderNode() == null) {
            return this.getName().compareTo(o.getName());
        }
        ret = this.getOrderNode().compareTo(o.getOrderNode());
        if (ret == 0) {
            return this.getName().compareTo(o.getName());
        }
        return ret;
    }

    public void sortChildren() {
        Collections.sort(this.children);
    }
}

