/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.core.DirectoryItemsReader;

public abstract class BaseDirectory
implements Comparable<BaseDirectory>,
Serializable {
    public static String name = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a";
    private static final long serialVersionUID = 3860532138510632440L;
    private static HashMap<Class<?>, List<BaseDirectory>> values = new HashMap();
    private static DirectoryItemsReader directoryItemsReader;
    private String title;

    public static <E extends BaseDirectory> List<BaseDirectory> getValues(Class<E> cls) {
        BaseDirectory.addItemsFromSource(cls);
        return values.get(cls) == null ? null : new CopyOnWriteArrayList(values.get(cls));
    }

    public static <E extends BaseDirectory> void addItemsFromSource(Class<E> cls) {
        if (directoryItemsReader != null) {
            BaseDirectory.clearItemList(cls);
            BaseDirectory.addItems(cls, directoryItemsReader.read(cls));
        }
    }

    public static <E extends BaseDirectory> void addItems(Class<E> cls, List<E> items) {
        if (values.get(cls) == null) {
            values.put(cls, new ArrayList<E>(items));
        } else {
            values.get(cls).addAll(items);
        }
    }

    public static <E extends BaseDirectory> void clearItemList(Class<E> cls) {
        values.put(cls, null);
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435")})
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public int compareTo(BaseDirectory o) {
        return this.getTitle() == null ? -1 : (o.getTitle() == null ? -1 : this.getTitle().compareToIgnoreCase(o.getTitle()));
    }

    public static DirectoryItemsReader getDirectoryItemsReader() {
        return directoryItemsReader;
    }

    public static void setDirectoryItemsReader(DirectoryItemsReader directoryItemsReader) {
        BaseDirectory.directoryItemsReader = directoryItemsReader;
    }
}

