/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.Master;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.additional.AddFieldManager;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.core.processor.ActionViewerDefinition;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.swing.CreateFieldViewerException;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.ContextHolder;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.menu.MenuAction;

public abstract class BeanPanel<T>
extends UISetter<T> {
    private List<FieldPresentation<T>> rows;
    protected HashMap<FieldPresentation<T>, Boolean> rowsVisible = new HashMap();
    protected FieldViewer<T> fv = null;
    private List<FieldViewer<T>> viewers = new ArrayList<FieldViewer<T>>();
    protected Object obj;
    HashMap<Long, String> valuesAdd = null;
    List<Long> valuesAddId = null;
    String title;
    String keyView;
    Class<?> contentClass;
    private Object oldValue;
    private HashMap<FieldPresentation<T>, Object> oldValues = new HashMap();
    private UIGLayoutManager<T> layout;
    private boolean transitionOnEnter;
    String[] properties;
    String[] blink = null;
    boolean notClose = false;
    private Integer blinkInterval;
    String titleForm;
    private Dimension minSize = null;
    private Dimension maxSize = null;
    private Dimension size = null;
    protected boolean initialized = false;

    public List<FieldPresentation<T>> getRows() {
        return this.rows;
    }

    public String getKeyView() {
        return this.keyView;
    }

    @Override
    public void storeOldValues() {
        this.oldValues = new HashMap();
        if (this.obj != null && this.fv == null) {
            if (this.rows != null) {
                try {
                    for (FieldPresentation<T> row : this.rows) {
                        if (row.getSetter() == null && !row.isAddField() || row.isReadOnly()) continue;
                        Object val = this.getNewValue(row, this.obj);
                        this.oldValues.put(row, val);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.oldValue = this.obj;
        }
    }

    @Override
    public Object getNewValue(FieldPresentation<T> row, Object obj) {
        if (row.isAddField()) {
            if (this.valuesAdd != null) {
                return this.valuesAdd.get(row.getId());
            }
            return null;
        }
        try {
            Object val = row.getGetter().invoke(obj, new Object[0]);
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setNewValue(FieldPresentation<T> row, Object obj, Object newValue) {
        if (row.isAddField()) {
            this.valuesAdd.put(row.getId(), (String)newValue);
        } else {
            try {
                row.getSetter().invoke(obj, newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void restoreOldValues() {
        if (this.obj != null) {
            try {
                if (this.fv == null) {
                    for (FieldPresentation<T> row : this.rows) {
                        Object newValue = this.oldValues.get(row);
                        if (row == null || row.getSetter() == null && !row.isAddField() || row.isReadOnly() || newValue instanceof BeanViewerAction) continue;
                        this.setNewValue(row, this.obj, newValue);
                    }
                } else {
                    this.obj = this.oldValue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public UIGLayoutManager<T> getLayout() {
        return this.layout;
    }

    public BeanPanel(Class<?> contentClass, Class<?> cls, Object obj, ViewerContext vc, UIFactory<T> factory, String keyView) {
        this.factory = factory;
        this.keyView = keyView;
        this.selfInit(contentClass, cls, vc, factory);
        this.init(obj);
    }

    public BeanPanel() {
    }

    public abstract T addActionToManagementPanel(BeanViewerAction<PanelContext> var1);

    protected abstract FieldViewer<T> addComponent(Class<?> var1, Class<? extends FieldViewer<T>> var2, UIGLayoutManager<T> var3) throws CreateFieldViewerException;

    protected abstract void addField(FieldPresentation<T> var1, UIFactory<T> var2, UIGLayoutManager<T> var3);

    public void addNewField(FieldPresentation<T> fr, UIFactory<T> factory, UIGLayoutManager<T> layout) {
        this.rows.add(fr);
        this.addField(fr, factory, layout);
    }

    public void setContext(ViewerContext context) {
        this.pc.setParentContext(context);
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    public abstract T getPanel();

    @Override
    public Optional<FieldPresentation<T>> getPresentator(String label) {
        return this.rows.parallelStream().filter(p -> p.getLabel().equals(label)).findAny();
    }

    @Override
    public FieldPresentation<T> getPresentatorForName(String name) {
        for (FieldPresentation<T> p : this.rows) {
            if (!p.getProperty().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Object getRowNewValue(FieldPresentation<T> row) {
        if (row.isAddField()) {
            return BeanPanel.getNewValue(String.class, row.getViewer().getValue());
        }
        Method setter = row.getSetter();
        if (setter != null) {
            Class<?> argClass = setter.getParameterTypes()[0];
            return BeanPanel.getNewValue(argClass, row.getViewer().getValue());
        }
        return null;
    }

    @Override
    public List<Object> getSelectedItems() {
        ArrayList<Object> selected = new ArrayList<Object>();
        for (FieldPresentation<T> fieldPresentation : this.rows) {
            List<Object> o = fieldPresentation.getSelectedItems();
            if (o == null) continue;
            for (Object object : o) {
                selected.add(object);
            }
        }
        for (FieldViewer fieldViewer : this.viewers) {
            if (!BigContentViewer.class.isAssignableFrom(fieldViewer.getClass()) || !((BigContentViewer)fieldViewer).isCanSelect()) continue;
            selected.addAll(((BigContentViewer)fieldViewer).getSelectedItems());
        }
        return selected;
    }

    public String getTitle() {
        if (this.getMethodGetTitle() == null || this.getObject() == null) {
            return this.title;
        }
        try {
            return (String)this.getMethodGetTitle().invoke(this.getObject(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.title;
        }
    }

    public Object help() {
        return null;
    }

    public abstract void setDynamicTitle(String var1);

    public void setDynamicTitle() {
        this.setDynamicTitle(this.getTitle());
    }

    public abstract void hideManagementPanel();

    protected abstract void init(Object var1);

    private UIGLayoutManager<T> installLayoutManager(ClassDefinition cd) {
        if (cd.getLayoutKeys() != null) {
            for (String s : cd.getLayoutKeys()) {
                Class<UIGLayoutManager<?>> lm = this.getFactory().getUIGLayoutManagerbyKey(s);
                if (lm == null || !this.getFactory().canManage(lm)) continue;
                try {
                    Constructor<?>[] constr = lm.getConstructors();
                    if (constr != null) {
                        for (Constructor<?> c : constr) {
                            Class<?>[] par = c.getParameterTypes();
                            if (par.length != 1 || !par[0].equals(UIFactory.class)) continue;
                            return lm.getConstructor(UIFactory.class).newInstance(this.getFactory());
                        }
                    }
                    return lm.newInstance();
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).severe("Can`t create instance of " + lm.getClass().getName());
                }
            }
        }
        return this.getFactory().getDefaultLayoutManager();
    }

    public abstract boolean isVisible();

    public void save() {
        this.updateMainObject();
    }

    protected List<FieldPresentation<T>> parseRows(Class<?> cls) {
        return FieldPresentation.parse(cls, this, this.factory, "panel", this.keyView);
    }

    protected List<ActionViewerDefinition> getActions(ClassDefinition cd) {
        return cd == null ? null : cd.getActionsForPanel();
    }

    public String[] getProperties() {
        return this.properties;
    }

    public boolean isNotClose() {
        return this.notClose;
    }

    public String[] getBlink() {
        return this.blink;
    }

    public Integer getBlinkInterval() {
        return this.blinkInterval;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
        if (properties != null) {
            for (String s : properties) {
                String[] s2;
                String[] ss = s.split("=");
                if ("size".equals(ss[0])) {
                    s2 = ss[1].split("x");
                    this.size = new Dimension(Integer.parseInt(s2[0]), Integer.parseInt(s2[1]));
                    continue;
                }
                if ("minsize".equals(ss[0])) {
                    s2 = ss[1].split("x");
                    this.minSize = new Dimension(Integer.parseInt(s2[0]), Integer.parseInt(s2[1]));
                    continue;
                }
                if ("maxsize".equals(ss[0])) {
                    s2 = ss[1].split("x");
                    this.maxSize = new Dimension(Integer.parseInt(s2[0]), Integer.parseInt(s2[1]));
                    continue;
                }
                if ("blink".equals(ss[0])) {
                    this.blink = ss[1].split(";");
                    continue;
                }
                if ("blinkInterval".equals(ss[0])) {
                    this.blinkInterval = Integer.parseInt(ss[1]);
                    continue;
                }
                if ("notClose".equals(ss[0])) {
                    this.notClose = Boolean.parseBoolean(ss[1]);
                    continue;
                }
                if ("titlePanel".equals(ss[0])) {
                    this.notClose = Boolean.parseBoolean(ss[1]);
                    continue;
                }
                if (!"titleForm".equals(ss[0])) continue;
                this.titleForm = ss[1];
            }
        }
    }

    public String getTitleForm() {
        return this.titleForm;
    }

    public void setTitleForm(String titleForm) {
        this.titleForm = titleForm;
    }

    public Dimension getMinSize() {
        return this.minSize;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    public Dimension getSize() {
        return this.size;
    }

    protected void selfInit(Class<?> contentClass, Class<?> cls, ViewerContext vc, UIFactory<T> factory) {
        List<ActionViewerDefinition> listActions;
        this.contentClass = contentClass;
        if (vc != null) {
            this.pc.setKeyPage(vc.getKeyPage());
        }
        this.pc.setParentContext(vc);
        this.pc.setPanel(this);
        ClassDefinition cd = FieldPresentation.getClassDefinition(cls, this.getKeyView());
        this.transitionOnEnter = cd.isTransitionEnter();
        this.layout = this.installLayoutManager(cd);
        this.setProperties(cd.getProperties());
        this.rows = this.parseRows(cls);
        List<FieldPresentation<T>> rowsAdd = AddFieldManager.getAddFieldRowsToClass(factory, cls);
        this.valuesAddId = new ArrayList<Long>();
        for (FieldPresentation<T> fr : this.rows) {
            this.addField(fr, factory, this.layout);
            this.rowsVisible.put(fr, true);
        }
        if (rowsAdd != null) {
            this.layout.setPropertiesAdd(rowsAdd);
            for (FieldPresentation<T> fr : rowsAdd) {
                this.rows.add(fr);
                this.addField(fr, factory, this.layout);
                this.rowsVisible.put(fr, true);
                this.valuesAddId.add(fr.getId());
            }
        }
        for (FieldPresentation<T> fp : this.rows) {
            FieldViewer<T> m;
            ViewerContext viewerContext = new ViewerContext();
            viewerContext.setParentContext(this.pc);
            viewerContext.setPresentator(fp);
            fp.getViewer().setViewerContext(viewerContext);
            if (fp.getMaster().equals("") || !Master.class.isAssignableFrom((m = this.getPresentatorForName(fp.getMaster()).getViewer()).getClass())) continue;
            ((Master)((Object)m)).addDetail(fp);
        }
        if (this.transitionOnEnter && this.transitionOnEnter) {
            for (int i = 0; i < this.rows.size(); ++i) {
                this.rows.get(i).getViewer().addChangeActionOnEnter(new ActionOnEnter(i));
            }
        }
        if ((listActions = this.getActions(cd)) != null && listActions.size() > 0) {
            HashMap<ActionViewerDefinition, Boolean> m = null;
            if (Settings.getAccessRightForAction() != null) {
                String kp = "";
                if (this.getPanelContext() != null) {
                    kp = this.getPanelContext().getKeyPage();
                }
                m = Settings.getAccessRightForAction().getAccessViewerActionList(listActions, kp);
            }
            for (ActionViewerDefinition acd : listActions) {
                try {
                    BeanViewerAction<PanelContext> bva = this.createActionView(acd, m);
                    this.actions.put(bva, this.addActionToManagementPanel(bva));
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).severe("Coudn't create action of " + acd.getClazz().getName() + ":" + e.getMessage());
                }
            }
        }
    }

    protected BeanViewerAction<PanelContext> createActionView(ActionViewerDefinition acd, HashMap<ActionViewerDefinition, Boolean> m) throws InstantiationException, IllegalAccessException {
        BeanViewerAction<PanelContext> bva = acd.getClazz().newInstance();
        bva.setContext(this.pc);
        bva.setOrder(acd.getOrder());
        Boolean e = true;
        if (m != null && (e = m.get(acd)) == null) {
            e = false;
        }
        bva.setEnable(e);
        bva.setRightForEnable(e);
        return bva;
    }

    @Override
    public void setField(String title, Object value) {
        for (FieldPresentation<T> row : this.rows) {
            if (!row.getLabel().equals(title)) continue;
            row.getViewer().setValue(value);
        }
    }

    @Override
    public void setObject(Object obj) {
        if (obj != null) {
            this.initialized = true;
            ActionCalculatedObject.initializing = true;
            this.obj = obj;
            if (obj != null) {
                this.valuesAdd = AddFieldManager.getValues(obj, this.valuesAddId.toArray(new Long[0]));
            }
            this.validities.clear();
            this.pc.setObject(obj);
            if (obj instanceof ContextHolder) {
                ((ContextHolder)obj).setContext(this.pc);
            }
            for (BeanViewerAction beanViewerAction : this.actions.keySet()) {
                beanViewerAction.setContext(this.pc);
            }
            if (this.fv == null) {
                if (this.rows != null) {
                    try {
                        for (FieldPresentation fieldPresentation : this.rows) {
                            ViewerContext bvac = fieldPresentation.getViewer().getViewerContext();
                            if (bvac == null) {
                                bvac = new ViewerContext();
                                fieldPresentation.getViewer().setViewerContext(bvac);
                            }
                            bvac.setParentContext(this.pc);
                            bvac.setPresentator(fieldPresentation);
                            fieldPresentation.getViewer().setBeanViewerActionContextToValidators(bvac);
                            fieldPresentation.getViewer().setBeanViewerActionContextToActions(bvac);
                            if (!fieldPresentation.getMaster().equals("")) continue;
                            Object val = this.getNewValue(fieldPresentation, obj);
                            if (val instanceof BeanViewerAction) {
                                ((BeanViewerAction)val).setContext(bvac);
                            }
                            if (val instanceof ContextHolder) {
                                ((ContextHolder)val).setContext(bvac);
                            }
                            fieldPresentation.getViewer().setValue(val);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.fv.setValue(obj);
            }
            ActionCalculatedObject.initializing = false;
        }
        this.setDynamicTitle();
        this.beforeShow();
    }

    public void beforeShow() {
        if (this.getMethodBeforeShow() == null || this.getObject() == null) {
            return;
        }
        try {
            this.getMethodBeforeShow().invoke(this.getObject(), this.pc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void beforeDestroy() {
        if (this.getMethodBeforeDestroy() == null || this.getObject() == null) {
            return;
        }
        try {
            this.getMethodBeforeDestroy().invoke(this.getObject(), this.pc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void update(Object object) {
        this.setObject(object);
    }

    private List<FieldPresentation<T>> getRowByName(String name) {
        ArrayList<FieldPresentation<T>> ret = new ArrayList<FieldPresentation<T>>();
        for (FieldPresentation<T> row : this.rows) {
            if (!row.getProperty().equals(name)) continue;
            ret.add(row);
        }
        return ret;
    }

    public void setVisibleToField(FieldPresentation<T> fp, boolean visible) {
        this.getLayout().setVisibleToFieldPresentation(fp, visible);
        this.rowsVisible.put(fp, visible);
    }

    @Override
    public void updateField(FieldPresentation<T> fp) {
        if (this.obj != null && this.fv == null && fp != null && !fp.isReadOnly()) {
            try {
                Object newValue = this.getRowNewValue(fp);
                if (!(fp == null || fp.getSetter() == null && !fp.isAddField() || newValue instanceof BeanViewerAction || fp.isReadOnly())) {
                    this.setNewValue(fp, this.obj, newValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateMainObject() {
        if (this.obj != null) {
            try {
                if (this.fv == null) {
                    for (FieldPresentation<T> row : this.rows) {
                        Object newValue = this.getRowNewValue(row);
                        if (row == null || row.getSetter() == null && !row.isAddField() || newValue instanceof BeanViewerAction && !(this.obj instanceof MenuAction) || row.isReadOnly()) continue;
                        this.setNewValue(row, this.obj, newValue);
                    }
                    if (this.valuesAdd != null) {
                        AddFieldManager.setValues(this.obj, this.valuesAdd);
                    }
                } else {
                    this.obj = this.fv.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Class<?> getContentClass() {
        return this.contentClass;
    }

    @Override
    public void updateUI() {
        if (this.obj != null) {
            ActionCalculatedObject.initializing = true;
            if (this.fv == null) {
                if (this.rows != null) {
                    try {
                        for (FieldPresentation<T> row : this.rows) {
                            if (!row.getMaster().equals("")) continue;
                            Object val = this.getNewValue(row, this.obj);
                            row.getViewer().update(val, null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.fv.update(this.obj, null);
            }
            ActionCalculatedObject.initializing = false;
        }
    }

    @Override
    public void updateUIForPresentatorName(String name) {
        if (this.obj != null) {
            List<FieldPresentation<T>> fps = this.getRowByName(name);
            for (FieldPresentation<T> fp : fps) {
                if (fp == null) continue;
                ActionCalculatedObject.initializing = true;
                try {
                    Object val = this.getNewValue(fp, this.obj);
                    fp.getViewer().update(val, null);
                    ActionCalculatedObject.initializing = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean getComparableToOnlyOrder() {
        return this.layout == null ? false : this.layout.getComparableToOnlyOrder();
    }

    @Override
    public void runCalculatedObject() {
        if (Settings.getCalculate() != null && Settings.getCalculate().isAssignableFrom(this.obj.getClass())) {
            Method[] mm = Settings.getCalculate().getMethods();
            for (int i = 0; i < mm.length; ++i) {
                if (mm[i].getParameterTypes().length != 0) continue;
                try {
                    mm[i].invoke(this.obj, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.obj != null) {
            this.beforeDestroy();
            if (this.fv == null) {
                if (this.rows != null) {
                    for (FieldPresentation<T> row : this.rows) {
                        if (!row.getMaster().equals("")) continue;
                        row.getViewer().destroy();
                    }
                }
            } else {
                this.fv.destroy();
            }
        }
    }

    public void setDefaultFocus() {
        if (this.fv == null) {
            if (this.rows != null) {
                for (FieldPresentation<T> row : this.rows) {
                    if (row.getUIProperties() == null || !"true".equals(row.getUIProperties().get("defaultfocus"))) continue;
                    this.getLayout().setFocusOnComponent(row);
                    break;
                }
            }
        } else {
            this.fv.setFocus();
        }
    }

    class ActionOnEnter
    extends BeanViewerAction<ViewerContext> {
        Integer indexCurrentField;

        public ActionOnEnter(Integer indexCurrentField) {
            this.indexCurrentField = indexCurrentField;
        }

        @Override
        public void actionPerformed(Object message) {
            int i;
            for (i = this.indexCurrentField + 1; !(i >= BeanPanel.this.rows.size() || ((FieldPresentation)BeanPanel.this.rows.get(i)).getViewer().isEditable() && BeanPanel.this.rowsVisible.get(BeanPanel.this.rows.get(i)).booleanValue()); ++i) {
            }
            if (i < BeanPanel.this.rows.size()) {
                ((FieldPresentation)BeanPanel.this.rows.get(i)).getViewer().setFocus();
            } else {
                BeanPanel.this.setFocusOnFirstAction();
            }
        }
    }
}

