/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.TableCellDefaultViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.swing.viewers.DefaultViewerUIProperties;
import ru.infor.beanviewer.viewer.BeanViewerAction;

public class DefaultViewer<T>
extends FieldViewer<T>
implements SwingItem {
    protected T jtf;
    private DefaultViewerUIProperties viewerProperty;
    private boolean selectOnFocus = false;
    private boolean mustbenull = false;

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return TableCellDefaultViewer.class;
    }

    public DefaultViewer(UIFactory<T> factory) {
        super(factory);
        this.jtf = factory.getTextField();
        this.getFactory().setPropertyToComponent("minsize", "100x24", this.jtf);
        this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.jtf);
        this.setEditable(false);
        this.getFactory().setActionOnFocusComponent(this.jtf, new BeanViewerAction(){

            @Override
            public void actionPerformed(Object message) {
                if (DefaultViewer.this.editable && DefaultViewer.this.selectOnFocus) {
                    DefaultViewer.this.getFactory().selectTextIntoTextField(DefaultViewer.this.jtf, null);
                }
            }
        }, true, false);
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.jtf;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.getFactory().setComponentSize(this.jtf, 100, 24);
            this.getFactory().setTextToComponent(this.jtf, "");
        } else {
            this.getFactory().setTextToComponent(this.jtf, object.toString());
        }
    }

    @Override
    public void selectValue(Integer select) {
        this.getFactory().selectTextIntoTextField(this.jtf, select);
    }

    @Override
    public Object getValue() {
        String s = this.getFactory().getTextFromComponent(this.jtf);
        if (this.mustbenull && "".equals(s)) {
            return null;
        }
        return s;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.getFactory().setComponentEditable(this.jtf, editable);
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
        this.getFactory().addActionToComponent(this.jtf, changeAction);
    }

    @Override
    public Object getUIProperties() {
        return this.viewerProperty;
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        this.viewerProperty = (DefaultViewerUIProperties)viewerProperty;
        int al = this.viewerProperty.getHorizontalAlignment();
        if (al == 2) {
            this.getFactory().setPropertyToComponent("horizontalalignment", "left", this.jtf);
        } else if (al == 4) {
            this.getFactory().setPropertyToComponent("horizontalalignment", "right", this.jtf);
        } else if (al == 0) {
            this.getFactory().setPropertyToComponent("horizontalalignment", "center", this.jtf);
        }
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return DefaultViewerUIProperties.class;
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("selectonfocus")) {
            this.selectOnFocus = Boolean.parseBoolean(value);
        }
        if (key.toLowerCase().equals("mustbenull")) {
            this.mustbenull = Boolean.parseBoolean(value);
        }
        super.setPropertyField(key, value);
    }
}

