/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.Selector;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.processor.FieldDefinition;
import ru.infor.beanviewer.core.processor.ListClassDefinition;
import ru.infor.beanviewer.core.processor.UIDefinitionProcessor;
import ru.infor.beanviewer.core.processor.raw.RawProcessor;
import ru.infor.beanviewer.viewer.BigContentViewer;

public class FieldPresentation<T>
implements Comparable<FieldPresentation<T>> {
    private Integer order;
    private String label;
    private FieldViewer<T> viewer;
    private Method setter;
    private Method getter;
    private boolean visible = true;
    private boolean showInManagerPanel;
    private String propertiesLayout;
    private String master = "";
    private Method setMasterObjects;
    private boolean readOnly = false;
    private String labelInManagerPanel;
    private boolean comparableToOnlyOrder = false;
    private boolean notEnableWithEmptySelection = false;
    private boolean addField = false;
    private Long id = null;
    private String property;
    private HashMap<String, String> uiProperties;
    private HashMap<String, String> fieldProperties;
    private List<Check> checks = null;
    public static Map<String, Object> rowsCache = new HashMap<String, Object>();
    public static RawProcessor rawProcessor = new RawProcessor();

    public void addUIProperty(String key, String value) {
        if (this.uiProperties == null) {
            this.uiProperties = new HashMap();
        }
        this.uiProperties.put(key.toLowerCase(), value.toLowerCase());
    }

    public void addFieldProperty(String key, String value) {
        if (this.fieldProperties == null) {
            this.fieldProperties = new HashMap();
        }
        this.fieldProperties.put(key.toLowerCase(), value.toLowerCase());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isAddField() {
        return this.addField;
    }

    public void setAddField(boolean addField) {
        this.addField = addField;
    }

    public boolean isNotEnableWithEmptySelection() {
        return this.notEnableWithEmptySelection;
    }

    public void setNotEnableWithEmptySelection(boolean notEnableWithEmptySelection) {
        this.notEnableWithEmptySelection = notEnableWithEmptySelection;
    }

    public boolean isComparableToOnlyOrder() {
        return this.comparableToOnlyOrder;
    }

    public void setComparableToOnlyOrder(boolean comparableToOnlyOrder) {
        this.comparableToOnlyOrder = comparableToOnlyOrder;
    }

    public Method getSetMasterObjects() {
        return this.setMasterObjects;
    }

    public void setSetMasterObjects(Method setMasterObjects) {
        this.setMasterObjects = setMasterObjects;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int compareTo(FieldPresentation<T> fr) {
        if (this.comparableToOnlyOrder || this.viewer == null || fr.getViewer() == null || this.viewer.getShape() == fr.getViewer().getShape()) {
            return this.order.compareTo(fr.order);
        }
        return new Integer(this.viewer.getShape()).compareTo(fr.getViewer().getShape());
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public FieldViewer<T> getViewer() {
        return this.viewer;
    }

    public void setViewer(FieldViewer<T> field) {
        this.viewer = field;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public List<Object> getSelectedItems() {
        if (Selector.class.isAssignableFrom(this.viewer.getClass()) && ((Selector)((Object)this.viewer)).isCanSelect()) {
            return ((Selector)((Object)this.viewer)).getSelectedItems();
        }
        return null;
    }

    public int[] getSelectedRows() {
        if (Selector.class.isAssignableFrom(this.viewer.getClass()) && ((Selector)((Object)this.viewer)).isCanSelect()) {
            return ((Selector)((Object)this.viewer)).getSelectedRows();
        }
        return null;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public void setChecks(List<Check> checks) {
        this.checks = checks;
    }

    public void addChecks(Check check) {
        if (this.checks == null) {
            this.checks = new ArrayList<Check>();
        }
        this.checks.add(check);
    }

    public static synchronized ListClassDefinition getListClassDefinition(Class<?> item) {
        for (Class<?> clazz = item; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (UIDefinitionProcessor udp : UIDefinitionProcessor.getProcessors()) {
                if (!udp.canProcess(clazz)) continue;
                ListClassDefinition l = udp.getClassDefinition(clazz);
                for (ClassDefinition cd : l.getListDefinition()) {
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                        for (FieldDefinition fd : cd.getFields()) {
                            PropertyDescriptor propertyDescriptor = null;
                            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                                if (!pd.getName().equals(fd.getBeanPropertyName())) continue;
                                propertyDescriptor = pd;
                                break;
                            }
                            fd.setTypeField(propertyDescriptor.getPropertyType());
                        }
                    }
                    catch (IntrospectionException ie) {
                        ie.printStackTrace();
                    }
                }
                return l;
            }
        }
        return null;
    }

    public static synchronized ClassDefinition getClassDefinition(Class<?> item, String keyView) {
        ClassDefinition cd = FieldPresentation.getClassDefinitionByProcessor(item, keyView);
        if (cd != null) {
            return cd;
        }
        return rawProcessor.getCachedClassDefinition(item, keyView);
    }

    public static synchronized ClassDefinition getClassDefinition(Class<?> item) {
        return FieldPresentation.getClassDefinition(item, "");
    }

    public static synchronized ClassDefinition getClassDefinitionByProcessor(Class<?> item, String keyView) {
        for (Class<?> clazz = item; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            for (UIDefinitionProcessor udp : UIDefinitionProcessor.getProcessors()) {
                if (!udp.canProcess(clazz)) continue;
                return udp.getCachedClassDefinition(clazz, keyView);
            }
        }
        return null;
    }

    public static <T> List<FieldPresentation<T>> parse(Class<?> item, UISetter<T> panel, UIFactory<T> factory, String extraKey, String keyView) {
        return FieldPresentation.parse(item, panel, factory, UIDefinitionProcessor.getProcessors(), extraKey, keyView);
    }

    public static <T> List<FieldPresentation<T>> parse(Class<?> item, UISetter<T> panel, UIFactory<T> factory, String extraKey) {
        return FieldPresentation.parse(item, panel, factory, extraKey, "");
    }

    public static <T> List<FieldPresentation<T>> parseInManager(Class<?> item, UISetter<T> panel, UIFactory<T> factory, String extraKey, String keyView) {
        List<FieldPresentation<T>> l = FieldPresentation.parse(item, panel, factory, UIDefinitionProcessor.getProcessors(), extraKey, keyView);
        return ((Stream)l.stream().parallel()).filter(fp -> fp.showInManagerPanel).sorted().collect(Collectors.toList());
    }

    public static <T> List<FieldPresentation<T>> parseInManager(Class<?> item, UISetter<T> panel, UIFactory<T> factory, String extraKey) {
        return FieldPresentation.parseInManager(item, panel, factory, extraKey, "");
    }

    public static <T> List<FieldPresentation<T>> parse(Class<?> clazz, UISetter panel, UIFactory<T> factory, List<UIDefinitionProcessor> udpl, String extraKey, String keyView) {
        String key = (clazz == null ? "" : clazz.getName()) + (extraKey == null ? "" : extraKey) + (keyView == null ? "" : keyView);
        if ("tunedviewer".equals(extraKey) && rowsCache.get(key) != null) {
            return (List)rowsCache.get(key);
        }
        List<FieldPresentation<T>> rows = null;
        for (Class<?> item = clazz; item != null && !item.equals(Object.class); item = item.getSuperclass()) {
            for (UIDefinitionProcessor udp : udpl) {
                if (!udp.canProcess(item)) continue;
                List<FieldPresentation<T>> ret = udp.processRows(item, panel, factory, extraKey, keyView);
                rows = ret;
                break;
            }
            if (rows != null) break;
        }
        if (rows == null) {
            rows = rawProcessor.processRows(clazz, panel, factory, extraKey, keyView);
        }
        String kp = "";
        if (panel != null && panel.getPanelContext() != null) {
            kp = panel.getPanelContext().getKeyPage();
        }
        if (!"tunedviewer".equals(extraKey)) {
            HashMap<String, Boolean> r;
            ArrayList<FieldPresentation<T>> rowsInvisible = new ArrayList<FieldPresentation<T>>();
            if (Settings.getAccessRight() != null && (r = Settings.getAccessRight().getAccessFieldObject(clazz, kp)) != null) {
                for (FieldPresentation<T> fp : rows) {
                    Boolean b = r.get(fp.getProperty());
                    if (b == null) {
                        rowsInvisible.add(fp);
                        continue;
                    }
                    fp.getViewer().setEditable(!fp.isReadOnly() && b != false);
                    fp.setReadOnly(fp.isReadOnly() || b == false);
                }
            }
            if (Settings.getAccessRightForAction() != null) {
                for (FieldPresentation<Object> fieldPresentation : rows) {
                    if (fieldPresentation.getChecks() == null || fieldPresentation.getChecks().size() <= 0) continue;
                    Boolean b = Settings.getAccessRightForAction().getAccessFieldButton(fieldPresentation.getChecks(), kp);
                    if (b == null) {
                        b = false;
                    }
                    fieldPresentation.getViewer().setEditable(b);
                    if (b.booleanValue() || !(fieldPresentation.getViewer() instanceof BigContentViewer)) continue;
                    rowsInvisible.add(fieldPresentation);
                }
            }
            for (FieldPresentation<Object> fieldPresentation : rowsInvisible) {
                rows.remove(fieldPresentation);
            }
        }
        if ("tunedviewer".equals(extraKey)) {
            rowsCache.put(key, rows);
        }
        return rows;
    }

    public String getLabelInManagerPanel() {
        return this.labelInManagerPanel;
    }

    public void setLabelInManagerPanel(String labelInManagerPanel) {
        this.labelInManagerPanel = labelInManagerPanel;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isShowInManagerPanel() {
        return this.showInManagerPanel;
    }

    public void setShowInManagerPanel(boolean showInManagerPanel) {
        this.showInManagerPanel = showInManagerPanel;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public String getPropertiesLayout() {
        return this.propertiesLayout;
    }

    public void setPropertiesLayout(String propertiesLayout) {
        this.propertiesLayout = propertiesLayout;
    }

    public HashMap<String, String> getUIProperties() {
        return this.uiProperties;
    }

    public HashMap<String, String> getFieldProperties() {
        return this.fieldProperties;
    }

    public void setFieldProperties(HashMap<String, String> fieldProperties) {
        this.fieldProperties = fieldProperties;
    }

    public static <T> List<FieldPresentation<T>> parse(Class<?> item) {
        for (UIDefinitionProcessor udp : UIDefinitionProcessor.getProcessors()) {
            if (!udp.canProcess(item)) continue;
            return udp.processRows(item, "");
        }
        return new ArrayList<FieldPresentation<T>>();
    }
}

