/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.Extractor;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.core.processor.ActionViewerDefinition;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class ManagerBeanPanel<T>
extends BeanPanel<T> {
    private T panel;
    private T content;
    private T managemtpanel;
    private String name;
    private Extractor extractor;
    private Class<?> contentCl;
    private boolean visiblePanel;
    private BeanViewerAction<PanelContext> defaultEnterActionOnManagerPanel;

    public boolean isVisiblePanel() {
        return this.visiblePanel;
    }

    public Class<?> getContentCl() {
        return this.contentCl;
    }

    public Extractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(Extractor e) {
        this.extractor = e;
    }

    public ManagerBeanPanel(Class<?> contentClass, Class<?> cls, Object obj, ViewerContext vc, UIFactory<T> factory, String name, String keyView) {
        super(contentClass, cls, obj, vc, factory, keyView);
        this.contentCl = contentClass;
        this.name = name;
    }

    @Override
    protected List<ActionViewerDefinition> getActions(ClassDefinition cd) {
        return cd == null ? null : cd.getActionsForManagerPanel();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T addActionToManagementPanel(BeanViewerAction<PanelContext> a) {
        T c = this.getFactory().getAction(a, null);
        if (this.managemtpanel == null) {
            this.managemtpanel = this.getFactory().getPanelInManager();
        }
        this.getFactory().putObjectToContainer(c, this.managemtpanel, null);
        return c;
    }

    @Override
    protected BeanViewerAction<PanelContext> createActionView(ActionViewerDefinition acd, HashMap<ActionViewerDefinition, Boolean> m) throws InstantiationException, IllegalAccessException {
        BeanViewerAction<PanelContext> v = super.createActionView(acd, m);
        if (acd.isDefaultEnterActionOnManagerPanel()) {
            this.defaultEnterActionOnManagerPanel = v;
        }
        return v;
    }

    @Override
    protected void selfInit(Class<?> contentClass, Class<?> cls, ViewerContext vc, UIFactory<T> factory) {
        super.selfInit(contentClass, cls, vc, factory);
        if (this.defaultEnterActionOnManagerPanel != null) {
            BeanViewerAction<ViewerContext> v = new BeanViewerAction<ViewerContext>(){

                @Override
                public void actionPerformed(Object message) {
                    if (ManagerBeanPanel.this.defaultEnterActionOnManagerPanel.isEnable() && ManagerBeanPanel.this.defaultEnterActionOnManagerPanel.isRightForEnable()) {
                        ManagerBeanPanel.this.defaultEnterActionOnManagerPanel.actionPerformed(message);
                    }
                }
            };
            this.getRows().parallelStream().forEach(r -> r.getViewer().addChangeActionOnEnter(v));
        }
    }

    @Override
    protected FieldViewer<T> addComponent(Class<?> cls, Class<? extends FieldViewer<T>> view, UIGLayoutManager<T> layout) {
        FieldViewer<T> fv = null;
        try {
            fv = view.getConstructor(UIFactory.class).newInstance(this.getFactory());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        fv.setKey(fv.getClass().getName() + cls.getName() + this.getContentCl().getName());
        this.fv = fv;
        if (this.content == null) {
            this.content = this.getFactory().getPanelInManager();
        }
        this.getFactory().putObjectToContainer(fv.getComponent(false, false), this.content, null);
        fv.setContentClass(cls);
        return fv;
    }

    @Override
    protected void addField(FieldPresentation<T> fr, UIFactory<T> factory, UIGLayoutManager<T> layout) {
        Object pan = this.getFactory().getPanel();
        String label = fr.getLabelInManagerPanel() == null ? fr.getLabel() : fr.getLabelInManagerPanel();
        this.getFactory().putObjectToContainer(this.getFactory().getLabelField(label), pan, null);
        this.getFactory().putObjectToContainer(fr.getViewer().getComponent(false, false), pan, null);
        if (this.content == null) {
            this.content = this.getFactory().getPanelInManager();
        }
        this.getFactory().putObjectToContainer(pan, this.content, null);
    }

    @Override
    public T getPanel() {
        return this.panel;
    }

    @Override
    public void hideManagementPanel() {
    }

    @Override
    public void init(Object obj) {
        this.panel = this.getFactory().init(obj, this, this.content, this.managemtpanel);
    }

    @Override
    public boolean isVisible() {
        return this.panel != null;
    }

    @Override
    public void setContext(ViewerContext context) {
        this.pc.setParentContext(context);
    }

    @Override
    protected List<FieldPresentation<T>> parseRows(Class<?> cls) {
        return FieldPresentation.parseInManager(cls, this, this.getFactory(), "managerpanel" + this.toString(), this.getKeyView());
    }

    public void setPanelContextManager() {
        if (this.extractor != null) {
            this.extractor.setPanelContextManager(this.pc);
            this.getFactory().setVisibleObject(this.panel, this.extractor.getVisible());
        }
    }

    @Override
    public void setObject(Object obj) {
        super.setObject(obj);
        if (this.extractor != null) {
            this.extractor.setPanelContextManager(this.pc);
            this.getFactory().setVisibleObject(this.panel, this.extractor.getVisible());
        }
    }

    @Override
    public void setDynamicTitle(String name) {
    }
}

