/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;

public abstract class PropertyManager {
    private static PropertyManager saver;
    private static Map<String, StatisticEntry> statistic;

    public static PropertyManager getSaver() {
        return saver;
    }

    public static void setSaver(PropertyManager ps) {
        saver = ps;
    }

    public String getStatisticString() throws JAXBException {
        List s = new List();
        s.setEntries(new ArrayList<StatisticEntry>(statistic.values()));
        return PropertyManager.propertiesToXML(s);
    }

    public void saveStatistic(String key) {
        try {
            this.save(key, this.getStatisticString());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<StatisticEntry> loadStatistic(String key) {
        try {
            List entries;
            statistic.clear();
            String stat = this.load(key);
            if (stat != null && (entries = PropertyManager.xmlToProperties(List.class, stat)).getEntries() != null) {
                Collections.sort(entries.getEntries());
                for (StatisticEntry se : entries.getEntries()) {
                    statistic.put(se.getKey(), se);
                }
                return entries.getEntries();
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract void save(String var1, String var2);

    public abstract void saveAll(String[] var1, String[] var2);

    public abstract String load(String var1);

    public abstract String[] loadAll(String[] var1);

    public static String propertiesToXML(Object properties) throws JAXBException {
        StringWriter string = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{properties.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(properties, (Writer)string);
        return string.toString();
    }

    public static <T> T xmlToProperties(Class<T> cls, String string) throws JAXBException {
        StringReader reader = new StringReader(string);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{cls});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Reader)reader);
    }

    public static void addStatistic(String key, String keyView) {
        String keyMap = key + keyView;
        if (!statistic.containsKey(keyMap)) {
            statistic.put(keyMap, new StatisticEntry(key, keyView));
        } else {
            statistic.get(keyMap).addFreq();
        }
    }

    static {
        statistic = new HashMap<String, StatisticEntry>();
    }

    @XmlRootElement
    private static class List {
        private ArrayList<StatisticEntry> entries;

        private List() {
        }

        public void setEntries(ArrayList<StatisticEntry> entries) {
            this.entries = entries;
        }

        public ArrayList<StatisticEntry> getEntries() {
            return this.entries;
        }
    }

    public static class StatisticEntry
    implements Comparable<StatisticEntry> {
        private String key;
        private Integer freq = 0;
        private String keyView = "";

        public StatisticEntry() {
        }

        public StatisticEntry(String key, String keyView) {
            this.setKey(key);
            this.setKeyView(keyView);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Integer getFreq() {
            return this.freq;
        }

        public void setFreq(Integer freq) {
            this.freq = freq;
        }

        public void addFreq() {
            this.freq = this.freq + 1;
        }

        public String getKeyView() {
            return this.keyView;
        }

        public void setKeyView(String keyView) {
            this.keyView = keyView;
        }

        @Override
        public int compareTo(StatisticEntry o) {
            return o.getFreq().compareTo(this.getFreq());
        }
    }
}

