/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public abstract class UISetter<T> {
    protected Map<ViewerContext, Boolean> validities = new HashMap<ViewerContext, Boolean>();
    protected UIFactory<T> factory;
    protected PanelContext pc = new PanelContext();
    protected HashMap<BeanViewerAction<PanelContext>, T> actions = new HashMap();
    private Method methodGetTitle;
    private Method methodBeforeShow;
    private Method methodBeforeDestroy;
    private boolean validate = true;

    public PanelContext getPanelContext() {
        return this.pc;
    }

    public abstract void setField(String var1, Object var2);

    public abstract void setObject(Object var1);

    public abstract void setTitle(String var1);

    public abstract void updateMainObject();

    public abstract void updateUI();

    public abstract Class<?> getContentClass();

    public abstract Optional<FieldPresentation<T>> getPresentator(String var1);

    public abstract FieldPresentation<T> getPresentatorForName(String var1);

    public abstract void updateUIForPresentatorName(String var1);

    public abstract void destroy();

    public abstract Object getObject();

    public abstract List<?> getSelectedItems();

    public abstract void storeOldValues();

    public abstract void restoreOldValues();

    public Method getMethodBeforeShow() {
        return this.methodBeforeShow;
    }

    public Method getMethodBeforeDestroy() {
        return this.methodBeforeDestroy;
    }

    public void setMethodBeforeDestroy(Method methodBeforeDestroy) {
        this.methodBeforeDestroy = methodBeforeDestroy;
    }

    public void setMethodBeforeShow(Method methodBeforeShow) {
        this.methodBeforeShow = methodBeforeShow;
    }

    public Method getMethodGetTitle() {
        return this.methodGetTitle;
    }

    public void setMethodGetTitle(Method methodGetTitle) {
        this.methodGetTitle = methodGetTitle;
    }

    public boolean getComparableToOnlyOrder() {
        return false;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void stopCellEditor() {
    }

    public void canselCellEditor() {
    }

    public UIFactory<T> getFactory() {
        return this.factory;
    }

    public void runCalculatedObject() {
        if (Settings.getCalculate() != null && Settings.getCalculate().isAssignableFrom(this.getObject().getClass())) {
            Method[] mm = Settings.getCalculate().getMethods();
            for (int i = 0; i < mm.length; ++i) {
                if (mm[i].getParameterTypes().length != 0) continue;
                try {
                    mm[i].invoke(this.getObject(), new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void showValidate() {
        boolean f = true;
        for (ViewerContext viewerContext : this.validities.keySet()) {
            if (!(f &= this.validities.get(viewerContext).booleanValue())) break;
        }
        for (BeanViewerAction beanViewerAction : this.actions.keySet()) {
            if (!beanViewerAction.isFormValidatorAcceptor()) continue;
            this.getFactory().setComponentEditable(this.actions.get(beanViewerAction), beanViewerAction.isEnable() && f);
            beanViewerAction.setRightForEnable(beanViewerAction.isEnable() && f);
        }
        this.setValidate(f);
    }

    public void setValidity(boolean validity, ViewerContext viewerContext, String v) {
        this.validities.put(viewerContext, validity);
        this.showValidate();
    }

    public BeanViewerAction<PanelContext> getBVAbyClass(Class<?> c) {
        for (BeanViewerAction<PanelContext> bva : this.actions.keySet()) {
            if (!bva.getClass().equals(c)) continue;
            return bva;
        }
        return null;
    }

    public void setEnabledToAction(Class<?> bvaClass, boolean enabled) {
        BeanViewerAction<PanelContext> bva = this.getBVAbyClass(bvaClass);
        if (bva != null) {
            bva.setEnable(enabled);
            this.getFactory().setComponentEditable(this.actions.get(bva), bva.isEnable());
        }
    }

    public void setVisibleToAction(Class<?> bvaClass, boolean visible) {
        BeanViewerAction<PanelContext> bva = this.getBVAbyClass(bvaClass);
        if (bva != null) {
            bva.setVisible(visible);
            this.getFactory().setComponentVisible(this.actions.get(bva), bva.isVisible());
        }
    }

    public boolean canClosed() {
        return true;
    }

    public static Object getNewValue(Class<?> argClass, Object newValue) {
        if (newValue != null && newValue.getClass().equals(String.class)) {
            if (Double.class.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? null : Double.valueOf(Double.parseDouble(((String)newValue).replaceAll(",", ".")));
            } else if (Double.TYPE.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? 0.0 : Double.parseDouble(((String)newValue).replaceAll(",", "."));
            } else if (Integer.class.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? null : Integer.valueOf(Integer.parseInt((String)newValue));
            } else if (Integer.TYPE.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? 0 : Integer.parseInt((String)newValue);
            } else if (Long.class.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? null : Long.valueOf(Long.parseLong((String)newValue));
            } else if (Long.TYPE.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? 0L : Long.parseLong((String)newValue);
            } else if (Float.class.isAssignableFrom(argClass)) {
                newValue = ((String)newValue).equals("") ? null : Float.valueOf(Float.parseFloat(((String)newValue).replaceAll(",", ".")));
            } else if (Float.TYPE.isAssignableFrom(argClass)) {
                newValue = Float.valueOf(((String)newValue).equals("") ? 0.0f : Float.parseFloat(((String)newValue).replaceAll(",", ".")));
            }
        }
        return newValue;
    }

    public abstract void updateField(FieldPresentation<T> var1);

    public UIGLayoutManager<T> getLayout() {
        return null;
    }

    public Set<BeanViewerAction<PanelContext>> getActions() {
        return this.actions.keySet();
    }

    public HashMap<BeanViewerAction<PanelContext>, T> getActionsWithComponent() {
        return this.actions;
    }

    public BeanViewerAction<PanelContext> getFirstAction() {
        Set<BeanViewerAction<PanelContext>> aa = this.actions.keySet();
        Integer order = Integer.MAX_VALUE;
        BeanViewerAction<PanelContext> res = null;
        for (BeanViewerAction<PanelContext> bva : aa) {
            if (bva.getOrder() >= order) continue;
            res = bva;
            order = bva.getOrder();
        }
        return res;
    }

    public T getFirstActionComponent() {
        Set<BeanViewerAction<PanelContext>> aa = this.actions.keySet();
        Integer order = Integer.MAX_VALUE;
        BeanViewerAction<PanelContext> res = null;
        for (BeanViewerAction<PanelContext> bva : aa) {
            if (bva.getOrder() >= order || !bva.isRightForEnable()) continue;
            res = bva;
            order = bva.getOrder();
        }
        if (res != null) {
            return this.actions.get(res);
        }
        return null;
    }

    public void setFocusOnFirstAction() {
        T c = this.getFirstActionComponent();
        if (c != null) {
            this.getFactory().setFocusOnComponent(c);
        }
    }
}

