/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.layout;

import java.util.HashMap;
import java.util.List;
import ru.infor.beanviewer.core.FieldPresentation;

public abstract class UIGLayoutManager<T> {
    public HashMap<FieldPresentation<T>, Components<T>> mapComponents = new HashMap();

    public T getLabelForPresentator(FieldPresentation<T> fp) {
        Components<T> t = this.mapComponents.get(fp);
        return t.getLabel();
    }

    public void setVisibleToFieldPresentation(FieldPresentation<T> fp, boolean visible) {
        Components<T> t = this.mapComponents.get(fp);
        if (t.getLabel() != null) {
            fp.getViewer().getFactory().setVisibleObject(t.getLabel(), visible);
        }
        fp.getViewer().getFactory().setVisibleObject(t.getField(), visible);
    }

    public abstract void addComponent(T var1, T var2);

    public abstract T addField(T var1, FieldPresentation<T> var2);

    public abstract T getPanel();

    public abstract boolean getComparableToOnlyOrder();

    public abstract void setFocusOnComponent(FieldPresentation<T> var1);

    public void setVisibleToTab(String comp, boolean visible) {
    }

    public void setPropertiesAdd(List<FieldPresentation<T>> rows) {
    }

    public static class Components<T> {
        private T label;
        private T field;

        public T getLabel() {
            return this.label;
        }

        public void setLabel(T label) {
            this.label = label;
        }

        public T getField() {
            return this.field;
        }

        public void setField(T field) {
            this.field = field;
        }

        public Components(T label, T field) {
            this.label = label;
            this.field = field;
        }
    }
}

