/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.definitionui.ClassWrapperSelectorAction;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

@ListView(views={@View(title="\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", actions={@ActionViewer(clazz=PanelContext.OKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class ActionFieldDefinition
implements Comparable<ActionFieldDefinition> {
    private Class<? extends BeanViewerAction<ViewerContext>> clazz;
    private List<Check> checks;
    private Integer order = 0;
    private boolean doubleclick = false;
    private String keyView = "";

    public static Simple getSimple(ActionFieldDefinition ad) {
        Simple s = new Simple();
        s.actionsUI = ad.getActionsUI();
        List<Check> chk = ad.getChecks();
        s.checks = chk == null ? Collections.emptyList() : chk.stream().map(Check::getSimple).collect(Collectors.toList());
        s.clazz = ad.getClazz().getName();
        s.doubleClick = ad.isDoubleclick();
        s.keyView = ad.getKeyView();
        s.order = ad.getOrder();
        return s;
    }

    public static List<ActionFieldDefinition> getActionFieldDefinitionForActionField(ActionField[] af) {
        ArrayList<ActionFieldDefinition> l = new ArrayList<ActionFieldDefinition>();
        for (ActionField f : af) {
            ActionFieldDefinition afd = new ActionFieldDefinition();
            afd.setClazz(f.clazz());
            afd.setOrder(f.order());
            afd.setDoubleclick(f.doubleclick());
            afd.setKeyView(f.keyView());
            ArrayList<Check> lc = new ArrayList<Check>();
            for (ru.infor.beanviewer.annotation.Check c : f.checks()) {
                lc.add(new Check(c.checkId()));
            }
            afd.setChecks(lc);
            l.add(afd);
        }
        Collections.sort(l);
        return l;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a", order=0)})
    @XmlAttribute
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0421\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u043f\u043e \u0434\u0432\u043e\u0439\u043d\u043e\u043c\u0443 \u043a\u043b\u0438\u043a\u0443", order=15000)})
    public boolean isDoubleclick() {
        return this.doubleclick;
    }

    public void setDoubleclick(boolean doubleclick) {
        this.doubleclick = doubleclick;
    }

    @XmlAttribute
    public Class<? extends BeanViewerAction<ViewerContext>> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<? extends BeanViewerAction<ViewerContext>> clazz) {
        this.clazz = clazz;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438", content=ru.infor.beanviewer.annotation.Check.class, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<Check> getChecks() {
        return this.checks;
    }

    public void setChecks(List<Check> lc) {
        this.checks = lc;
    }

    @XmlTransient
    @ListField(fields={@Field(title="\u0418\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430", order=10000, viewer={ClassWrapperSelectorAction.class})})
    public String getActionsUI() {
        return this.clazz == null ? null : this.clazz.getName();
    }

    public void setActionsUI(String w) {
        try {
            this.clazz = Class.forName(w);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int compareTo(ActionFieldDefinition o) {
        return this.order.compareTo(o.getOrder());
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f", order=10000)})
    public String getKeyView() {
        return this.keyView;
    }

    public void setKeyView(String keyView) {
        this.keyView = keyView;
    }

    public static class Simple {
        public String actionsUI;
        public List<Check.Simple> checks;
        public String clazz;
        public String keyView;
        public int order;
        public boolean doubleClick;
    }
}

