/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.definitionui.ClassWrapperSelectorAction;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;

@ListView(views={@View(title="\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", actions={@ActionViewer(clazz=PanelContext.OKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class ActionViewerDefinition
implements Comparable<ActionViewerDefinition> {
    private Class<? extends BeanViewerAction<PanelContext>> clazz;
    private Integer order = 0;
    private boolean showInManagerPanel = false;
    private boolean showInPanel = true;
    private boolean defaultEnterActionOnManagerPanel = false;
    private List<Check> checks;

    public static Simple getSimple(ActionViewerDefinition ad) {
        Simple s = new Simple();
        List<Check> chk = ad.getChecks();
        s.checks = chk == null ? Collections.emptyList() : chk.stream().map(Check::getSimple).collect(Collectors.toList());
        s.clazz = ad.getClazz().getName();
        try {
            BeanViewerAction<PanelContext> act = ad.getClazz().newInstance();
            s.hint = act.getHint();
            s.icon = act.getIcon();
            s.name = act.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.defaultEnterActionOnManagerPanel = ad.isDefaultEnterActionOnManagerPanel();
        s.order = ad.getOrder();
        s.showInManagerPanel = ad.isShowInManagerPanel();
        s.showInPanel = ad.isShowInPanel();
        return s;
    }

    @XmlAttribute
    public Class<? extends BeanViewerAction<PanelContext>> getClazz() {
        return this.clazz;
    }

    public static List<ActionViewerDefinition> getActionViewerDefinitionForActionViewer(ActionViewer[] af) {
        ArrayList<ActionViewerDefinition> l = new ArrayList<ActionViewerDefinition>();
        for (ActionViewer f : af) {
            ActionViewerDefinition afd = new ActionViewerDefinition();
            afd.setClazz(f.clazz());
            afd.setOrder(f.order());
            afd.setShowInManagerPanel(f.showInManagerPanel());
            afd.setShowInPanel(f.showInPanel());
            afd.setDefaultEnterActionOnManagerPanel(f.defaultEnterActionOnManagerPanel());
            ArrayList<Check> lc = new ArrayList<Check>();
            for (ru.infor.beanviewer.annotation.Check c : f.checks()) {
                lc.add(new Check(c.checkId()));
            }
            afd.setChecks(lc);
            l.add(afd);
        }
        Collections.sort(l);
        return l;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a", order=0)})
    @XmlAttribute
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setClazz(Class<? extends BeanViewerAction<PanelContext>> clazz) {
        this.clazz = clazz;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438", content=ru.infor.beanviewer.annotation.Check.class, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<Check> getChecks() {
        return this.checks;
    }

    public void setChecks(List<Check> lc) {
        this.checks = lc;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438", order=200)})
    @XmlAttribute
    public boolean isShowInManagerPanel() {
        return this.showInManagerPanel;
    }

    public void setShowInManagerPanel(boolean showInManagerPanel) {
        this.showInManagerPanel = showInManagerPanel;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u043f\u0430\u043d\u0435\u043b\u0438", order=250)})
    @XmlAttribute
    public boolean isShowInPanel() {
        return this.showInPanel;
    }

    public void setShowInPanel(boolean showInPanel) {
        this.showInPanel = showInPanel;
    }

    @XmlTransient
    @ListField(fields={@Field(title="\u0418\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430", order=100, viewer={ClassWrapperSelectorAction.class})})
    public String getActionsUI() {
        return this.clazz == null ? null : this.clazz.getName();
    }

    public void setActionsUI(String w) {
        try {
            this.clazz = Class.forName(w);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int compareTo(ActionViewerDefinition o) {
        return this.order.compareTo(o.getOrder());
    }

    @ListField(fields={@Field(title="\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 '\u0412\u0432\u043e\u0434' \u043d\u0430 \u043f\u043e\u043b\u044f\u0445", order=750)})
    @XmlAttribute
    public boolean isDefaultEnterActionOnManagerPanel() {
        return this.defaultEnterActionOnManagerPanel;
    }

    public void setDefaultEnterActionOnManagerPanel(boolean defaultEnterActionOnManagerPanel) {
        this.defaultEnterActionOnManagerPanel = defaultEnterActionOnManagerPanel;
    }

    public static class Simple {
        public List<Check.Simple> checks;
        public String clazz;
        public int order;
        public boolean defaultEnterActionOnManagerPanel;
        public boolean showInManagerPanel;
        public boolean showInPanel;
        public String hint;
        public String icon;
        public String name;
    }
}

