/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.processor.ActionViewerDefinition;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.processor.FieldDefinition;
import ru.infor.beanviewer.core.processor.ListClassDefinition;
import ru.infor.beanviewer.core.processor.PanelFieldDefinition;
import ru.infor.beanviewer.core.processor.UIDefinitionProcessor;

public class AnnotationProcessor
extends UIDefinitionProcessor {
    public AnnotationProcessor() {
        this.setOrder(100);
    }

    @Override
    public synchronized boolean canProcess(Class<?> clazz) {
        return clazz.isAnnotationPresent(ListView.class);
    }

    @Override
    public synchronized ListClassDefinition getClassDefinition(Class<?> clazz) {
        ListView lv = clazz.getAnnotation(ListView.class);
        ListClassDefinition lcd = new ListClassDefinition(clazz);
        if (lv == null) {
            return null;
        }
        for (View view : lv.views()) {
            ClassDefinition classDefinition = new ClassDefinition();
            classDefinition.setIcon(view.icon());
            classDefinition.setTitle(view.title());
            classDefinition.setProperties(view.properties());
            classDefinition.setActions(ActionViewerDefinition.getActionViewerDefinitionForActionViewer(view.actions()));
            classDefinition.setLayoutKeys(view.layoutKeys());
            classDefinition.setKeyView(view.keyView());
            ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
            classDefinition.setFields(fields);
            classDefinition.setTransitionEnter(view.transitionEnter());
            lcd.addClassDefinition(classDefinition);
        }
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                ListField lf;
                ListField listField = lf = pd.getReadMethod() == null ? null : pd.getReadMethod().getAnnotation(ListField.class);
                if (lf == null) continue;
                for (Field field : lf.fields()) {
                    ClassDefinition cd2;
                    ClassDefinition cd = lcd.getClassDefinition(field.keyView());
                    if (cd == null) continue;
                    FieldDefinition fd = new FieldDefinition();
                    fd.setBeanPropertyName(pd.getName());
                    fd.setPanels(PanelFieldDefinition.getPanels(field.panels()));
                    fd.setMaster(field.master());
                    fd.setChangeAction(field.changeAction());
                    fd.setContent(field.content());
                    fd.setEmptyItemPresent(field.emptyItemPresent());
                    fd.setOrder(field.order());
                    fd.setReadOnly(field.readOnly());
                    fd.setValidators(field.validators());
                    fd.setPropertiesUI(field.propertiesUI());
                    fd.setPropertiesLayout(field.propertiesLayout());
                    fd.setPropertiesField(field.propertiesField());
                    fd.setShowInManagerPanel(field.showInManagerPanel());
                    fd.setVisible(field.visible());
                    String title = field.title().equals("#") ? ((cd2 = FieldPresentation.getClassDefinition(pd.getPropertyType())) != null ? cd2.getTitle() : pd.getDisplayName()) : field.title();
                    fd.setTitle(title);
                    fd.setTitleInManagerPanel(field.titleInManagerPanel().equals("#") ? null : field.titleInManagerPanel());
                    fd.setViewer(field.viewer());
                    fd.setNotEnableWithEmptySelection(field.notEnableWithEmptySelection());
                    ArrayList<Check> lc = new ArrayList<Check>();
                    for (ru.infor.beanviewer.annotation.Check c : field.checks()) {
                        lc.add(new Check(c.checkId()));
                    }
                    fd.setChecks(lc);
                    cd.getFields().add(fd);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return lcd;
    }
}

