/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.definitionui.ChangeActionWrapper;
import ru.infor.beanviewer.core.definitionui.FieldViewerClassWrapper;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.core.processor.PanelFieldDefinition;
import ru.infor.beanviewer.core.system.ClassHeritorsLoader;
import ru.infor.beanviewer.validator.Validator;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;

@ListView(views={@View(title="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044f", actions={@ActionViewer(clazz=PanelContext.OKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class FieldDefinition {
    String beanPropertyName;
    String title;
    int order = 0;
    Class<?> content;
    Class<? extends FieldViewer<?>>[] viewer;
    boolean readOnly = false;
    boolean emptyItemPresent = false;
    boolean showInManagerPanel = false;
    String master = "";
    boolean visible = true;
    List<PanelFieldDefinition> panels;
    Class<? extends BeanViewerAction<ViewerContext>>[] changeAction;
    String[] validators;
    String[] propertiesUI;
    String[] propertiesField;
    String propertiesLayout;
    String titleInManagerPanel = null;
    private boolean notEnableWithEmptySelection = false;
    private Class<?> typeField;
    private List<Check> checks;

    public static Simple getSimple(FieldDefinition fd) {
        Simple s = new Simple();
        s.beanPropertyName = fd.getBeanPropertyName();
        s.typeField = fd.getTypeField().getName();
        Class<? extends BeanViewerAction<ViewerContext>>[] ca = fd.getChangeAction();
        s.changeAction = ca == null ? Collections.emptyList() : Arrays.stream(ca).map(c -> c.getName()).collect(Collectors.toList());
        List<Check> ch = fd.getChecks();
        s.checks = ch == null ? Collections.emptyList() : ch.stream().map(Check::getSimple).collect(Collectors.toList());
        Class<?> cnt = fd.getContent();
        s.content = cnt == null ? "" : cnt.getName();
        s.emptyItemPresent = fd.isEmptyItemPresent();
        s.master = fd.getMaster();
        s.notEnableWithEmptySelection = fd.isNotEnableWithEmptySelection();
        s.order = fd.order;
        s.panels = Optional.ofNullable(fd.getPanels()).orElse(Collections.emptyList()).stream().map(PanelFieldDefinition::getSimple).collect(Collectors.toList());
        s.propertiesField = fd.getPropertiesField();
        s.propertiesLayout = fd.getPropertiesLayout();
        s.propertiesUI = fd.getPropertiesUI();
        s.readOnly = fd.isReadOnly();
        s.showInManagerPanel = fd.isShowInManagerPanel();
        s.title = fd.getTitle();
        s.titleInManagerPanel = fd.getTitleInManagerPanel();
        s.validators = fd.getValidators();
        Class<? extends FieldViewer<?>>[] vw = fd.getViewer();
        if (vw == null) {
            vw = new Class[]{};
        }
        s.viewer = Arrays.stream(vw).map(v -> v.getName()).collect(Collectors.toList());
        s.visible = fd.isVisible();
        return s;
    }

    public String toString() {
        return this.getTitle();
    }

    public Class<?> getTypeField() {
        return this.typeField;
    }

    public void setTypeField(Class<?> typeField) {
        this.typeField = typeField;
    }

    @XmlAttribute
    public boolean isNotEnableWithEmptySelection() {
        return this.notEnableWithEmptySelection;
    }

    public void setNotEnableWithEmptySelection(boolean notEnableWithEmptySelection) {
        this.notEnableWithEmptySelection = notEnableWithEmptySelection;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", order=100)})
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f", order=300)})
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043c\u0430\u0441\u0442\u0435\u0440", order=2000)})
    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435", order=500)})
    public Class<?> getContent() {
        return this.content;
    }

    public void setContent(Class<?> content) {
        this.content = content;
    }

    public Class<? extends FieldViewer<?>>[] getViewer() {
        return this.viewer;
    }

    public void setViewer(Class<? extends FieldViewer<?>> ... viewer) {
        this.viewer = viewer;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u0435\u043b\u0438", content=FieldViewerClassWrapper.class, order=1000, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    @XmlTransient
    public List<FieldViewerClassWrapper> getViewerUI() {
        ArrayList<FieldViewerClassWrapper> ret = new ArrayList<FieldViewerClassWrapper>();
        if (this.viewer != null) {
            for (Class<FieldViewer<?>> clazz : this.viewer) {
                FieldViewerClassWrapper w = new FieldViewerClassWrapper();
                w.setClassName(clazz.getName());
                ret.add(w);
            }
        }
        return ret;
    }

    public void setViewerUI(List<FieldViewerClassWrapper> viewerui) {
        ArrayList vv = new ArrayList();
        for (FieldViewerClassWrapper w : viewerui) {
            try {
                vv.add(Class.forName(w.getClassName()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.viewer == null) {
            this.viewer = new Class[0];
        }
        this.viewer = vv.toArray(this.viewer);
    }

    public String[] getValidators() {
        return this.validators;
    }

    public void setValidators(String ... validators) {
        this.validators = validators;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u043b\u044c\u0449\u0438\u043a\u0438", content=ValidatorUI.class, order=1000, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    @XmlTransient
    public List<ValidatorUI> getValidatorUI() {
        ArrayList<ValidatorUI> ret = new ArrayList<ValidatorUI>();
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                String[] def = this.validators[i].split(":");
                if (def.length < 3) continue;
                ValidatorUI vui = new ValidatorUI();
                vui.setName(def[0].trim());
                vui.setMessage(def[1].trim());
                vui.setParameters(def[2].trim());
                ret.add(vui);
            }
        }
        return ret;
    }

    public void setValidatorUI(List<ValidatorUI> validatorui) {
        String[] vv = new String[validatorui.size()];
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = validatorui.get(i).getName() + ":" + validatorui.get(i).getMessage() + ":" + validatorui.get(i).getParameters();
        }
        this.setValidators(vv);
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0422\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f", order=630)})
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", order=640)})
    public boolean isEmptyItemPresent() {
        return this.emptyItemPresent;
    }

    public void setEmptyItemPresent(boolean emptyItemPresent) {
        this.emptyItemPresent = emptyItemPresent;
    }

    @ListField(fields={@Field(title="\u041f\u0430\u043d\u0435\u043b\u0438", content=PanelFieldDefinition.class, order=1100, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<PanelFieldDefinition> getPanels() {
        return this.panels;
    }

    public void setPanels(List<PanelFieldDefinition> panels) {
        this.panels = panels;
    }

    public Class<? extends BeanViewerAction<ViewerContext>>[] getChangeAction() {
        return this.changeAction;
    }

    public void setChangeAction(Class<? extends BeanViewerAction<ViewerContext>> ... changeAction) {
        this.changeAction = changeAction;
    }

    @ListField(fields={@Field(title="\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u044f", content=ChangeActionWrapper.class, emptyItemPresent=true, order=800, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    @XmlTransient
    public List<ChangeActionWrapper> getChangeActionUI() {
        ArrayList<ChangeActionWrapper> ret = new ArrayList<ChangeActionWrapper>();
        if (this.changeAction != null) {
            for (Class<? extends BeanViewerAction<ViewerContext>> cls : this.changeAction) {
                ChangeActionWrapper w = new ChangeActionWrapper();
                w.setClassName(cls.getName());
                ret.add(w);
            }
        }
        return ret;
    }

    public void setChangeActionUI(List<ChangeActionWrapper> changeActionUI) {
        ArrayList vv = new ArrayList();
        for (ChangeActionWrapper w : changeActionUI) {
            try {
                vv.add(Class.forName(w.getClassName()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.changeAction == null) {
            this.changeAction = new Class[0];
        }
        Class[] ff = new Class[]{};
        this.changeAction = vv.toArray(ff);
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0418\u043c\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 Java", order=200, readOnly=true)})
    public String getBeanPropertyName() {
        return this.beanPropertyName;
    }

    public void setBeanPropertyName(String beanPropertyName) {
        this.beanPropertyName = beanPropertyName;
    }

    public String[] getPropertiesUI() {
        return this.propertiesUI;
    }

    public void setPropertiesUI(String[] propertiesUI) {
        this.propertiesUI = propertiesUI;
    }

    public String[] getPropertiesField() {
        return this.propertiesField;
    }

    public void setPropertiesField(String[] propertiesField) {
        this.propertiesField = propertiesField;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u043f\u0430\u043d\u0435\u043b\u0438", order=2000)})
    public boolean isShowInManagerPanel() {
        return this.showInManagerPanel;
    }

    public void setShowInManagerPanel(boolean showInManagerPanel) {
        this.showInManagerPanel = showInManagerPanel;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b layout", order=2000)})
    public String getPropertiesLayout() {
        return this.propertiesLayout;
    }

    public void setPropertiesLayout(String propertiesLayout) {
        this.propertiesLayout = propertiesLayout;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0432 \u043f\u0430\u043d\u0435\u043b\u0438", order=2000)})
    public String getTitleInManagerPanel() {
        return this.titleInManagerPanel;
    }

    public void setTitleInManagerPanel(String titleInManagerPanel) {
        this.titleInManagerPanel = titleInManagerPanel;
    }

    @XmlAttribute
    @ListField(fields={@Field(title="\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u044f", order=2100)})
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438", content=ru.infor.beanviewer.annotation.Check.class, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<Check> getChecks() {
        return this.checks;
    }

    public void setChecks(List<Check> lc) {
        this.checks = lc;
    }

    @ListView(views={@View(title="\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u043b\u044c\u0449\u0438\u043a", actions={@ActionViewer(clazz=PanelContext.OKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
    public static class ValidatorUI {
        String name;
        String message;
        String parameters;

        @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", viewer={ValidatorDirectoryViewer.class}, emptyItemPresent=true, order=10)})
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ListField(fields={@Field(title="\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", order=30)})
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @ListField(fields={@Field(title="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", order=20)})
        public String getParameters() {
            return this.parameters;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }
    }

    public static class ValidatorDirectoryViewer<T>
    extends BaseDirectoryViewer<T> {
        private List<String> names = new ArrayList<String>();

        public ValidatorDirectoryViewer(UIFactory<T> factory) {
            super(factory);
            List<Class<Validator>> vc = ClassHeritorsLoader.getHeritors(Validator.class);
            this.names.clear();
            for (Class<Validator> class1 : vc) {
                try {
                    String[] n;
                    for (String string : n = (String[])class1.getMethod("getNames", new Class[0]).invoke((Object)class1.newInstance(), new Object[0])) {
                        this.names.add(string);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected List<?> getDirectoryItems() {
            return this.names;
        }
    }

    public static class Simple {
        public String beanPropertyName;
        public String title;
        public int order;
        public String content;
        public List<String> viewer;
        public boolean readOnly;
        public boolean emptyItemPresent;
        public boolean showInManagerPanel;
        public String master;
        public boolean visible;
        public List<PanelFieldDefinition.Simple> panels;
        public List<String> changeAction;
        public String[] validators;
        public String[] propertiesUI;
        public String propertiesLayout;
        public String[] propertiesField;
        public String titleInManagerPanel;
        public boolean notEnableWithEmptySelection;
        public List<Check.Simple> checks;
        public String typeField;
    }
}

