/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.processor.ActionFieldDefinition;
import ru.infor.beanviewer.core.processor.ClassViewDefinition;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;

@ListView(views={@View(title="\u041f\u0430\u043d\u0435\u043b\u044c", actions={@ActionViewer(clazz=PanelContext.OKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class PanelFieldDefinition
implements Comparable<PanelFieldDefinition> {
    Integer order = 0;
    String name = "";
    private List<ActionFieldDefinition> actions;
    private List<ClassViewDefinition> classView;

    public static Simple getSimple(PanelFieldDefinition pd) {
        Simple s = new Simple();
        List<ActionFieldDefinition> act = pd.getActions();
        s.actions = act == null ? Collections.emptyList() : act.stream().map(ActionFieldDefinition::getSimple).collect(Collectors.toList());
        List<ClassViewDefinition> cv = pd.getClassView();
        s.classView = cv == null ? Collections.emptyList() : cv.stream().map(ClassViewDefinition::getSimple).collect(Collectors.toList());
        s.name = pd.getName();
        s.order = pd.getOrder();
        return s;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a", order=0)})
    @XmlAttribute
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043d\u0435\u043b\u0438", order=10)})
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439", content=ActionFieldDefinition.class, order=20, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<ActionFieldDefinition> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionFieldDefinition> actions) {
        this.actions = actions;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043b\u0430\u0441\u0441\u043e\u0432", content=ClassViewDefinition.class, order=30, panels={@PanelField(actions={@ActionField(clazz=BeanViewerAction.Adder.class, checks={}), @ActionField(clazz=BeanViewerAction.Editor.class, checks={}), @ActionField(clazz=BeanViewerAction.Remover.class, checks={})})})})
    public List<ClassViewDefinition> getClassView() {
        return this.classView;
    }

    public void setClassView(List<ClassViewDefinition> classView) {
        this.classView = classView;
    }

    public static List<PanelFieldDefinition> getPanels(PanelField[] pfl) {
        ArrayList<PanelFieldDefinition> l = new ArrayList<PanelFieldDefinition>();
        for (PanelField pf : pfl) {
            PanelFieldDefinition pfd = new PanelFieldDefinition();
            pfd.setName(pf.name());
            pfd.setOrder(pf.order());
            pfd.setActions(ActionFieldDefinition.getActionFieldDefinitionForActionField(pf.actions()));
            pfd.setClassView(ClassViewDefinition.getClassViewerDefinitionForActionViewer(pf.classView()));
            l.add(pfd);
        }
        Collections.sort(l);
        return l;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(PanelFieldDefinition o) {
        return this.order.compareTo(o.getOrder());
    }

    @XmlTransient
    public List<Object> getActionAndClass() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.actions != null && this.actions.size() > 0) {
            for (ActionFieldDefinition af : this.actions) {
                l.add(af);
            }
        }
        int i = 0;
        if (this.classView != null && this.classView.size() > 0) {
            for (ClassViewDefinition cw : this.classView) {
                boolean f = false;
                while (!f) {
                    if (i >= l.size()) {
                        l.add(cw);
                        f = true;
                        ++i;
                        continue;
                    }
                    int o = ((ActionFieldDefinition)l.get(i)).getOrder();
                    if (cw.getOrder() <= o) {
                        l.add(i, cw);
                        f = true;
                    }
                    ++i;
                }
            }
        }
        return l;
    }

    public static class Simple {
        public List<ActionFieldDefinition.Simple> actions;
        public List<ClassViewDefinition.Simple> classView;
        public String name;
        public int order;
    }
}

