/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import ru.infor.beanviewer.core.BaseDirectoryPresentator;
import ru.infor.beanviewer.core.CollectionTypeTouched;
import ru.infor.beanviewer.core.Extractor;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.ManagerBeanPanel;
import ru.infor.beanviewer.core.ManyActionManager;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.processor.ActionFieldDefinition;
import ru.infor.beanviewer.core.processor.AnnotationProcessor;
import ru.infor.beanviewer.core.processor.Check;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.processor.ClassViewDefinition;
import ru.infor.beanviewer.core.processor.FieldDefinition;
import ru.infor.beanviewer.core.processor.ListClassDefinition;
import ru.infor.beanviewer.core.processor.PanelFieldDefinition;
import ru.infor.beanviewer.core.processor.xml.XMLDefinitionProcessor;
import ru.infor.beanviewer.validator.Validator;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public abstract class UIDefinitionProcessor
implements Comparable<UIDefinitionProcessor> {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int order = Integer.MAX_VALUE;
    private static Map<Class<?>, ListClassDefinition> definitions = new HashMap();
    private static List<UIDefinitionProcessor> processors = new ArrayList<UIDefinitionProcessor>();

    public abstract boolean canProcess(Class<?> var1);

    public abstract ListClassDefinition getClassDefinition(Class<?> var1);

    /*
     * WARNING - void declaration
     */
    public <T> List<FieldPresentation<T>> processRows(Class<?> clazz, UISetter<T> setter, UIFactory<T> factory, String extraKey, String keyView) {
        Method[] mtds;
        ClassDefinition cd = this.getCachedClassDefinition(clazz, keyView);
        if (setter != null) {
            setter.setTitle(cd.getTitle());
        }
        ArrayList<FieldPresentation<T>> rows = new ArrayList<FieldPresentation<T>>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (FieldDefinition fieldDefinition : cd.getFields()) {
                void var11_16;
                if (!fieldDefinition.isVisible()) continue;
                Object var11_17 = null;
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(fieldDefinition.getBeanPropertyName())) continue;
                    PropertyDescriptor propertyDescriptor = pd;
                    break;
                }
                if (var11_16 == null) continue;
                rows.add(UIDefinitionProcessor.createFieldPresentation(extraKey, setter, fieldDefinition.getTitle() != null ? fieldDefinition.getTitle() : var11_16.getDisplayName(), fieldDefinition.getOrder(), fieldDefinition.getChangeAction(), fieldDefinition.getViewer(), factory, (PropertyDescriptor)var11_16, fieldDefinition.getContent(), fieldDefinition.isEmptyItemPresent(), fieldDefinition.getPanels(), fieldDefinition.isReadOnly(), fieldDefinition.getValidatorUI(), fieldDefinition.getPropertiesUI(), fieldDefinition.getPropertiesLayout(), fieldDefinition.getPropertiesField(), fieldDefinition.isShowInManagerPanel(), fieldDefinition.master, clazz, fieldDefinition.getTitleInManagerPanel(), fieldDefinition.isNotEnableWithEmptySelection(), fieldDefinition.getChecks()));
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        Collections.sort(rows);
        if (!"panelInlist".equals(extraKey) && !"tunedviewer".equals(extraKey) && PropertyManager.getSaver() != null) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList fpl = new ArrayList();
            for (FieldPresentation fieldPresentation : rows) {
                if (fieldPresentation.getViewer().getUIPropertiesClass() == null) continue;
                keys.add(fieldPresentation.getViewer().getKey());
                fpl.add(fieldPresentation.getViewer());
            }
            String[] stringArray = PropertyManager.getSaver().loadAll(keys.toArray(new String[0]));
            boolean bl = false;
            for (FieldViewer fieldViewer : fpl) {
                void var11_22;
                String p;
                if ((p = stringArray[++var11_22]) == null || "".equals(p)) continue;
                try {
                    fieldViewer.setUIProperties(PropertyManager.xmlToProperties(fieldViewer.getUIPropertiesClass(), p));
                }
                catch (JAXBException e1) {
                    this.logger.severe("Can't load properties for " + fieldViewer.getKey());
                }
            }
        }
        Method[] methodArray = mtds = clazz == null ? null : clazz.getMethods();
        if (setter != null && mtds != null) {
            void var11_24;
            Method[] methodArray2 = mtds;
            int n = methodArray2.length;
            boolean bl = false;
            while (var11_24 < n) {
                Method m = methodArray2[var11_24];
                if (m.getName().toLowerCase().equals("getdynamictitle")) {
                    setter.setMethodGetTitle(m);
                }
                if (m.getName().toLowerCase().equals("beforeshow")) {
                    setter.setMethodBeforeShow(m);
                }
                if (m.getName().toLowerCase().equals("beforedestroy")) {
                    setter.setMethodBeforeDestroy(m);
                }
                ++var11_24;
            }
        }
        return rows;
    }

    public <T> List<FieldPresentation<T>> processRows(Class<?> clazz, String keyView) {
        ClassDefinition cd = this.getCachedClassDefinition(clazz, keyView);
        ArrayList<FieldPresentation<T>> rows = new ArrayList<FieldPresentation<T>>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (FieldDefinition fd : cd.getFields()) {
                if (!fd.isVisible()) continue;
                FeatureDescriptor propertyDescriptor = null;
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(fd.getBeanPropertyName())) continue;
                    propertyDescriptor = pd;
                    break;
                }
                if (propertyDescriptor == null) continue;
                rows.add(UIDefinitionProcessor.createFieldPresentation(fd.getTitle() != null ? fd.getTitle() : propertyDescriptor.getDisplayName(), fd.getOrder(), (PropertyDescriptor)propertyDescriptor));
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        return rows;
    }

    public ListClassDefinition getCachedListClassDefinition(Class<?> clazz) {
        ListClassDefinition lcd;
        if (definitions.containsKey(clazz)) {
            lcd = definitions.get(clazz);
        } else {
            lcd = this.getClassDefinition(clazz);
            definitions.put(clazz, lcd);
        }
        return lcd;
    }

    public ClassDefinition getCachedClassDefinition(Class<?> clazz, String key) {
        ListClassDefinition l;
        if (definitions.containsKey(clazz)) {
            l = definitions.get(clazz);
        } else {
            l = this.getClassDefinition(clazz);
            definitions.put(clazz, l);
        }
        ClassDefinition cd = l.getClassDefinition(key);
        if (cd == null) {
            cd = l.getClassDefinition("");
        }
        return cd;
    }

    public static <T> FieldPresentation<T> createFieldPresentation(String extraKey, UISetter setter, String title, int order, Class<? extends BeanViewerAction<ViewerContext>>[] changeActionClass, Class<? extends FieldViewer<?>>[] posibleViewers, UIFactory<T> factory, PropertyDescriptor propertyDescriptor, Class<?> contentClass, boolean emptyItemPresence, List<PanelFieldDefinition> panels, boolean readOnly, List<FieldDefinition.ValidatorUI> validators, String[] propertiesUI, String propertiesLayout, String[] propertiesField, boolean showInManagerPanel, String master, Class<?> clazz, String titleInManagerPanel, boolean notEnableWithEmptySelection, List<Check> checks) {
        FieldPresentation<T> fr = new FieldPresentation<T>();
        fr.setLabel(title);
        fr.setOrder(order);
        if (propertyDescriptor != null) {
            fr.setProperty(propertyDescriptor.getName());
        }
        if ("tunedviewer".equals(extraKey)) {
            fr.setGetter(propertyDescriptor == null ? null : propertyDescriptor.getReadMethod());
            if (propertiesField != null) {
                for (String property : propertiesField) {
                    String[] pair = property.split("=", 2);
                    if (pair.length != 2) continue;
                    fr.addFieldProperty(pair[0].trim(), pair[1].trim());
                }
            }
        } else {
            String[] pair;
            fr.setChecks(checks);
            fr.setMaster(master);
            fr.setPropertiesLayout(propertiesLayout);
            fr.setLabelInManagerPanel(titleInManagerPanel);
            fr.setNotEnableWithEmptySelection(notEnableWithEmptySelection);
            FieldViewer<Object> viewer = null;
            if (factory != null) {
                Method[] mtds;
                if (posibleViewers != null) {
                    for (int i = 0; i < posibleViewers.length; ++i) {
                        try {
                            if (!factory.canManage(posibleViewers[i])) continue;
                            viewer = posibleViewers[i].getConstructor(UIFactory.class).newInstance(factory);
                            break;
                        }
                        catch (Exception e) {
                            Logger.getLogger(UIDefinitionProcessor.class.getName()).severe("Can't create viewer " + posibleViewers[i].getName() + " " + e.getMessage());
                        }
                    }
                }
                if (viewer == null) {
                    viewer = factory.getViewer(propertyDescriptor == null ? contentClass : propertyDescriptor.getPropertyType());
                }
                viewer.setTitle(fr.getLabel());
                viewer.setContentClass(propertyDescriptor != null && (propertyDescriptor.getPropertyType().isArray() || Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) && contentClass != null ? contentClass : (propertyDescriptor == null ? contentClass : propertyDescriptor.getPropertyType()));
                if (BaseDirectoryPresentator.class.isAssignableFrom(viewer.getClass())) {
                    ((BaseDirectoryPresentator)((Object)viewer)).setEmptyItemPresent(emptyItemPresence);
                }
                if (CollectionTypeTouched.class.isAssignableFrom(viewer.getClass())) {
                    CollectionTypeTouched lv = (CollectionTypeTouched)((Object)viewer);
                    lv.setListClass(propertyDescriptor.getPropertyType());
                }
                if (propertiesField != null) {
                    for (String property : propertiesField) {
                        pair = property.split("=", 2);
                        if (pair.length != 2) continue;
                        viewer.setPropertyField(pair[0].trim(), pair[1].trim());
                        fr.addFieldProperty(pair[0].trim(), pair[1].trim());
                    }
                }
                Method[] methodArray = mtds = clazz == null ? null : clazz.getMethods();
                if (ManyActionManager.class.isAssignableFrom(viewer.getClass())) {
                    ManyActionManager bcv = (ManyActionManager)((Object)viewer);
                    if (panels != null) {
                        for (PanelFieldDefinition pfd : panels) {
                            List<Object> ll = pfd.getActionAndClass();
                            HashMap<ActionFieldDefinition, Boolean> m = null;
                            if (Settings.getAccessRightForAction() != null) {
                                String kp = "";
                                if (setter != null && setter.getPanelContext() != null) {
                                    kp = setter.getPanelContext().getKeyPage();
                                }
                                m = Settings.getAccessRightForAction().getAccessFieldActionList(pfd.getActions(), kp);
                            }
                            for (Object o : ll) {
                                if (o instanceof ActionFieldDefinition) {
                                    ActionFieldDefinition bvad = (ActionFieldDefinition)o;
                                    try {
                                        BeanViewerAction<ViewerContext> bva_instance = bvad.getClazz().newInstance();
                                        Boolean e = true;
                                        if (m != null && (e = m.get(bvad)) == null) {
                                            e = false;
                                        }
                                        bva_instance.setEnable(e);
                                        bva_instance.setRightForEnable(e);
                                        bva_instance.setDoubleclick(bvad.isDoubleclick());
                                        bva_instance.setKeyView(bvad.getKeyView());
                                        bcv.addAction(bva_instance, pfd.getName());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                if (!(o instanceof ClassViewDefinition)) continue;
                                ClassViewDefinition c = (ClassViewDefinition)o;
                                Extractor e = null;
                                Class<?> cont = c.getClazz();
                                try {
                                    e = ((ClassViewDefinition)o).getExtractor().newInstance();
                                    Class<?> cl = e.getContentClassForClassValue(setter.getContentClass());
                                    if (cl != null) {
                                        cont = cl;
                                    }
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                ManagerBeanPanel<T> mbp = new ManagerBeanPanel<T>(cont, cont, null, null, factory, c.getName(), c.getKeyView());
                                mbp.setExtractor(e);
                                bcv.addPanels(mbp, pfd.getName());
                            }
                        }
                    }
                }
                if ((ManyActionManager.class.isAssignableFrom(viewer.getClass()) || master != null && !master.equals("")) && mtds != null) {
                    for (Method m : mtds) {
                        if (!m.equals(propertyDescriptor.getReadMethod()) && m.getName().startsWith("setMasterObjects") && m.getName().substring(16).toLowerCase().equals(propertyDescriptor.getName().toLowerCase())) {
                            fr.setSetMasterObjects(m);
                        }
                        if (!ManyActionManager.class.isAssignableFrom(viewer.getClass())) continue;
                        ManyActionManager bcv = (ManyActionManager)((Object)viewer);
                        if (!m.equals(propertyDescriptor.getReadMethod()) && m.getName().startsWith("create") && (m.getName().substring(6, 7).toLowerCase() + m.getName().substring(7).toLowerCase()).equals(propertyDescriptor.getName().toLowerCase())) {
                            bcv.setCreator(m);
                        }
                        if (!m.equals(propertyDescriptor.getReadMethod()) && m.getName().startsWith("remove") && m.getName().substring(6).toLowerCase().equals(propertyDescriptor.getName().toLowerCase())) {
                            bcv.setRemover(m);
                        }
                        if (!m.equals(propertyDescriptor.getReadMethod()) && m.getName().startsWith("edit") && m.getName().substring(4).toLowerCase().equals(propertyDescriptor.getName().toLowerCase())) {
                            bcv.setEditor(m);
                        }
                        if (m.equals(propertyDescriptor.getReadMethod()) || !m.getName().startsWith("popup") || !m.getName().substring(5).toLowerCase().equals(propertyDescriptor.getName().toLowerCase())) continue;
                        bcv.setPopupMenuGetter(m);
                    }
                }
                viewer.setEditable(!readOnly || !master.equals(""));
            }
            if (master.equals("")) {
                fr.setSetter(propertyDescriptor == null ? null : propertyDescriptor.getWriteMethod());
            }
            if (fr.getSetter() == null || readOnly) {
                fr.setReadOnly(true);
            }
            if (setter != null) {
                fr.setComparableToOnlyOrder(setter.getComparableToOnlyOrder());
            }
            fr.setGetter(propertyDescriptor == null ? null : propertyDescriptor.getReadMethod());
            if (viewer != null) {
                if (changeActionClass != null) {
                    for (int i = 0; i < changeActionClass.length; ++i) {
                        if (changeActionClass[i].equals(Object.class)) continue;
                        try {
                            BeanViewerAction<ViewerContext> bva = changeActionClass[i].newInstance();
                            ViewerContext bvac = new ViewerContext();
                            bvac.setPresentator(fr);
                            bva.setContext(bvac);
                            viewer.addChangeAction(bva);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (validators != null) {
                    for (FieldDefinition.ValidatorUI v : validators) {
                        try {
                            viewer.addValidator(Validator.getValidator(v.getName()).newInstance(), v.getMessage(), v.getParameters(), v.getName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (propertiesUI != null) {
                    for (String property : propertiesUI) {
                        pair = property.split("=", 2);
                        if (pair.length != 2) continue;
                        viewer.setPropertyUI(pair[0].trim(), pair[1].trim());
                        fr.addUIProperty(pair[0].trim(), pair[1].trim());
                    }
                }
            }
            fr.setShowInManagerPanel(showInManagerPanel);
            fr.setViewer(viewer);
            if (viewer != null) {
                viewer.setKey(viewer.getClass().getName() + (clazz == null ? "" : clazz.getName()) + (propertyDescriptor == null ? "" : propertyDescriptor.getDisplayName()));
            }
            if (!"panelInlist".equals(extraKey) && viewer instanceof BigContentViewer) {
                ((BigContentViewer)viewer).initDefault();
            }
        }
        return fr;
    }

    public static <T> FieldPresentation<T> createFieldPresentation(String title, int order, PropertyDescriptor propertyDescriptor) {
        FieldPresentation fr = new FieldPresentation();
        fr.setLabel(title);
        fr.setOrder(order);
        if (propertyDescriptor != null) {
            fr.setProperty(propertyDescriptor.getName());
        }
        fr.setGetter(propertyDescriptor == null ? null : propertyDescriptor.getReadMethod());
        return fr;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public int compareTo(UIDefinitionProcessor o) {
        return this.getOrder().compareTo(o.getOrder());
    }

    public static void registerProcessor(Class<? extends UIDefinitionProcessor> clazz) throws InstantiationException, IllegalAccessException {
        processors.add(clazz.newInstance());
        Collections.sort(processors);
    }

    public static List<UIDefinitionProcessor> getProcessors() {
        return processors;
    }

    static {
        try {
            UIDefinitionProcessor.registerProcessor(XMLDefinitionProcessor.class);
            UIDefinitionProcessor.registerProcessor(AnnotationProcessor.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

