/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.processor.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.processor.FieldDefinition;
import ru.infor.beanviewer.core.processor.ListClassDefinition;
import ru.infor.beanviewer.core.processor.UIDefinitionProcessor;

public class XMLDefinitionProcessor
extends UIDefinitionProcessor {
    static String xmlDefinitionsLocationPrefix = "/definitions/xml/";
    private static HashMap<Class<?>, Boolean> map = new HashMap();

    public XMLDefinitionProcessor() {
        this.setOrder(50);
    }

    private File getFile(Class<?> clazz) {
        File f = null;
        List<String> lx = Settings.getListXmlPath();
        if (lx != null) {
            for (String s : lx) {
                f = new File(s + clazz.getName() + ".xml");
                if (!f.isFile()) continue;
                return f;
            }
        }
        return f;
    }

    @Override
    public boolean canProcess(Class<?> clazz) {
        String res_name;
        Boolean b = map.get(clazz);
        if (b != null) {
            return b;
        }
        File f = this.getFile(clazz);
        b = f != null && f.isFile() ? Boolean.valueOf(true) : Boolean.valueOf(clazz.getResource(res_name = xmlDefinitionsLocationPrefix + clazz.getName() + ".xml") != null);
        map.put(clazz, b);
        return b;
    }

    @Override
    public ListClassDefinition getClassDefinition(Class<?> clazz) {
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ListClassDefinition.class});
            File f = this.getFile(clazz);
            ListClassDefinition ret = f != null && f.isFile() ? (ListClassDefinition)c.createUnmarshaller().unmarshal(f) : (ListClassDefinition)c.createUnmarshaller().unmarshal(clazz.getResourceAsStream(xmlDefinitionsLocationPrefix + clazz.getName() + ".xml"));
            ret.updateMap();
            ret.setClazz(clazz);
            BeanInfo bi = null;
            for (ClassDefinition cd : ret.getListDefinition()) {
                for (FieldDefinition fd : cd.getFields()) {
                    if (fd.getTitle() != null) continue;
                    if (bi == null) {
                        bi = Introspector.getBeanInfo(clazz);
                    }
                    for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                        if (!pd.getName().equals(fd.getBeanPropertyName())) continue;
                        ClassDefinition cd1 = FieldPresentation.getClassDefinition(pd.getPropertyType(), "");
                        String title = cd1 != null ? cd1.getTitle() : pd.getDisplayName();
                        fd.setTitle(title);
                    }
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createXMLFromClass(Class<?> clazz, OutputStream os) throws JAXBException {
        for (UIDefinitionProcessor udp : UIDefinitionProcessor.getProcessors()) {
            if (udp instanceof XMLDefinitionProcessor || !udp.canProcess(clazz)) continue;
            ListClassDefinition cd = udp.getCachedListClassDefinition(clazz);
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ListClassDefinition.class});
            c.createMarshaller().marshal((Object)cd, os);
            break;
        }
    }

    public static void saveXMLDefinition(ListClassDefinition cd, File file) throws JAXBException {
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ClassDefinition.class});
            c.createMarshaller().marshal((Object)cd, (OutputStream)new FileOutputStream(file, false));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String getXMLDefinition(ListClassDefinition cd) throws JAXBException {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ClassDefinition.class});
        StringWriter sw = new StringWriter();
        c.createMarshaller().marshal((Object)cd, (Writer)sw);
        return sw.toString();
    }
}

