/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.report;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.processor.FieldDefinition;
import ru.infor.beanviewer.core.report.FieldPresentationReport;
import ru.infor.beanviewer.core.report.Report;

public class ReportProcessor {
    public static List<FieldPresentationReport> buildPresentation(Class<?> clazz, String keyView, Report r) {
        ClassDefinition cd = FieldPresentation.getClassDefinitionByProcessor(clazz, keyView);
        if (r != null) {
            r.setClassDefinition(cd);
        }
        if (cd == null) {
            return null;
        }
        ArrayList<FieldPresentationReport> rows = new ArrayList<FieldPresentationReport>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (FieldDefinition fd : cd.getFields()) {
                FeatureDescriptor propertyDescriptor = null;
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(fd.getBeanPropertyName())) continue;
                    propertyDescriptor = pd;
                    break;
                }
                if (propertyDescriptor == null) continue;
                rows.add(ReportProcessor.createFPR(fd.getTitle() != null ? fd.getTitle() : propertyDescriptor.getDisplayName(), fd.getOrder(), fd.getPropertiesLayout(), fd.getPropertiesField(), (PropertyDescriptor)propertyDescriptor, fd.getContent(), fd.getMaster(), fd.isShowInManagerPanel(), fd.getTitleInManagerPanel(), clazz));
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return rows;
    }

    public static FieldPresentationReport createFPR(String title, int order, String propertiesLayout, String[] propertiesField, PropertyDescriptor propertyDescriptor, Class<?> contentClass, String master, boolean showInManagerPanel, String titleInManagerPanel, Class<?> clazz) {
        FieldPresentationReport fr = new FieldPresentationReport();
        fr.setLabel(title);
        fr.setOrder(order);
        if (propertyDescriptor != null) {
            fr.setProperty(propertyDescriptor.getName());
        }
        fr.setMaster(master);
        fr.setPropertiesLayout(propertiesLayout);
        fr.setLabelInManagerPanel(titleInManagerPanel);
        fr.setContent(propertyDescriptor != null && (propertyDescriptor.getPropertyType().isArray() || Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) && contentClass != null ? contentClass : (propertyDescriptor == null ? contentClass : propertyDescriptor.getPropertyType()));
        fr.setPropertyType(propertyDescriptor.getPropertyType());
        fr.setGetter(propertyDescriptor == null ? null : propertyDescriptor.getReadMethod());
        if (propertiesField != null) {
            for (String property : propertiesField) {
                String[] pair = property.split("=", 2);
                if (pair.length != 2) continue;
                fr.addFieldProperty(pair[0].trim(), pair[1].trim());
            }
        }
        fr.setShowInManagerPanel(showInManagerPanel);
        return fr;
    }
}

