/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.system;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ClassHeritorsLoader {
    private Logger logger = Logger.getLogger(ClassHeritorsLoader.class.getName());
    private List<String> projectClasses = new ArrayList<String>();
    private static ClassHeritorsLoader classHeritorsLoader;

    private ClassHeritorsLoader() {
        this.getClassesList();
    }

    private void getClassesList() {
        URL url = ClassLoader.getSystemClassLoader().getResource("ru");
        try {
            URI uri = url.toURI();
            this.logger.fine(uri.toASCIIString());
            File f = new File(uri);
            String prefix = f.getAbsolutePath().substring(0, f.getAbsolutePath().lastIndexOf("ru")).replace(File.separatorChar, '&');
            this.getDirectories(f, prefix);
        }
        catch (Exception e) {
            this.logger.severe("exception = " + e.getMessage());
            this.loadFromResurce();
        }
    }

    private void loadFromResurce() {
        URL resource = this.getClass().getResource("classes.lst");
        this.logger.fine("path to classes.lst: " + resource);
        if (resource == null) {
            throw new RuntimeException("unable to locate classes.lst");
        }
        StringBuffer sb = this.readFile(this.getClass().getResourceAsStream("classes.lst"));
        String[] classes = sb.toString().split("\n");
        this.projectClasses.addAll(Arrays.asList(classes));
        this.logger.fine("projectClasses: " + this.projectClasses);
    }

    private StringBuffer readFile(InputStream is) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = is.read(buff)) > 0) {
                sb.append(new String(buff, 0, len));
            }
        }
        catch (IOException e) {
            this.logger.severe("exception = " + e.getMessage());
        }
        return sb;
    }

    private <E> void getDirectories(File f, String prefix) {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pn) {
                    return pn.isDirectory() || pn.getAbsolutePath().endsWith(".class");
                }
            })) {
                this.getDirectories(file, prefix);
            }
        } else {
            String cn = f.getAbsolutePath().replace(File.separatorChar, '&').replaceFirst(prefix, "").replace('&', '.');
            if (cn.lastIndexOf(".class") > 0) {
                cn = cn.substring(0, cn.lastIndexOf(".class"));
            }
            this.logger.fine("cn: " + cn);
            this.projectClasses.add(cn);
        }
    }

    public <E> List<Class<? extends E>> get(Class<E> cls) {
        ArrayList ret = new ArrayList();
        for (String clsName : this.projectClasses) {
            try {
                Class<?> c = Class.forName(clsName);
                if (!cls.isAssignableFrom(c) || c.isInterface() || Modifier.isAbstract(c.getModifiers()) || cls.equals(c)) continue;
                ret.add(c);
            }
            catch (ClassNotFoundException e) {
                this.logger.severe(e.getMessage());
            }
        }
        return ret;
    }

    public static ClassHeritorsLoader getInstance() {
        if (classHeritorsLoader == null) {
            classHeritorsLoader = new ClassHeritorsLoader();
        }
        return classHeritorsLoader;
    }

    public static <E> List<Class<? extends E>> getHeritors(Class<E> cls) {
        return ClassHeritorsLoader.getInstance().get(cls);
    }
}

