/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.core.table;

import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.RowSorter;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.table.ObjectSortKey;
import ru.infor.beanviewer.swing.viewers.list.TableUIProperties;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.PrimitiveClassTransformer;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.ContextHolder;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;
import ru.infor.beanviewer.viewer.list.AsyncList;
import ru.infor.beanviewer.viewer.list.BeanPanelInList;
import ru.infor.beanviewer.viewer.list.ListWithSelection;

public abstract class TableWithModel<T> {
    public List<Object> list;
    private List<FieldPresentation<T>> columns;
    public boolean readOnly;
    public boolean notDefSelection;
    protected BeanPanelInList<T> bp;
    protected int[] selTable = null;
    private PanelContext pc;
    private boolean[] nosortable;
    private List<SortKeyForTable> sorters;
    protected BigContentViewer<T> viewer;
    private WorkExtendedObject<T> extendedObject = new WorkExtendedObject(this);
    String direction;
    String headerSize;
    private HashMap<Integer, FieldViewer<T>> viewersToRenderer = new HashMap();

    public List<SortKeyForTable> getSorters() {
        return this.sorters;
    }

    public BigContentViewer<T> getViewer() {
        return this.viewer;
    }

    public TableWithModel(BigContentViewer<T> viewer) {
        this.viewer = viewer;
    }

    public WorkExtendedObject<T> getExtendedObject() {
        return this.extendedObject;
    }

    public void setExtendedObject(WorkExtendedObject<T> extendedObject) {
        this.extendedObject = extendedObject;
    }

    public void addMoreRows(List<? extends Object> objects) {
        this.list.addAll(objects);
        this.fireTableDataChanged();
    }

    public void addRow(Object object) {
        this.list.add(object);
        this.fireTableDataChanged();
    }

    public abstract void fireTableDataChanged();

    public abstract void clearSelection();

    public Class<?> getColumnClass(int columnIndex) {
        Method getter = this.columns.get(columnIndex).getGetter();
        Class<?> ret = getter != null ? getter.getReturnType() : this.columns.get(columnIndex).getViewer().getContentClass();
        if (ret.isPrimitive()) {
            ret = PrimitiveClassTransformer.convert(ret);
        }
        return ret;
    }

    public List<FieldPresentation<T>> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int column) {
        return this.columns.get(column).getLabel();
    }

    public boolean isSortable(int column) {
        return !this.nosortable[column];
    }

    public FieldViewer<T> getFieldViewer(int i) {
        return this.columns.get(i).getViewer();
    }

    public FieldPresentation<T> getFieldPresentator(int i) {
        return this.columns.get(i);
    }

    public Object getObject(int selectedRow) {
        int rl = this.extendedObject.getRowInList(selectedRow);
        return this.list.get(rl);
    }

    public Optional<FieldPresentation<T>> getFieldPresentation(String label) {
        return this.columns.parallelStream().filter(p -> p.getLabel().equals(label)).findAny();
    }

    public FieldPresentation<T> getPresentatorForName(String name) {
        for (FieldPresentation<T> p : this.columns) {
            if (!p.getProperty().equals(name)) continue;
            return p;
        }
        return null;
    }

    public int getRowCount() {
        return this.extendedObject.getRowCount();
    }

    public Object[] getRows(int[] selected) {
        Object[] ret = new Object[selected.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.list.get(selected[i]);
        }
        return ret;
    }

    public List<Object> getSelectedItems() {
        if (this.getSelectedRows() == null || this.getSelectedRows().length <= 0) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i : this.getSelectedRows()) {
            Object o = this.list.get(i);
            if (o == null) continue;
            ret.add(o);
        }
        return ret;
    }

    public abstract int[] getSelectedRowsTable();

    public int[] getSelectedRows() {
        int[] ii = this.getSelectedRowsTable();
        int[] il = new int[ii.length];
        for (int k = 0; k < ii.length; ++k) {
            il[k] = this.extendedObject.getRowInList(ii[k]);
        }
        return il;
    }

    public abstract void setSelectedRowsTable(int[] var1);

    public void setSelectedRows(int[] i) {
        int[] il = new int[i.length];
        for (int k = 0; k < i.length; ++k) {
            il[k] = this.extendedObject.getRowInTable(i[k]);
        }
        this.setSelectedRowsTable(il);
    }

    public abstract Class<? extends FieldViewer<T>> getTableCellViewerClass();

    public abstract T getTableComponent();

    public Object getValueAt(int row, int column) {
        Object o = null;
        try {
            o = this.extendedObject.getValueFromObject(column, this.list.get(this.extendedObject.getRowInList(row)));
        }
        catch (Exception _ex) {
            return null;
        }
        if (o instanceof BeanViewerAction || this.list.get(row) instanceof ContextHolder) {
            ViewerContext vc = new ViewerContext();
            vc.setObject(this.list.get(row));
            vc.setParentContext(this.pc);
            if (o instanceof BeanViewerAction) {
                ((BeanViewerAction)o).setContext(vc);
            }
            if (this.list.get(row) instanceof ContextHolder) {
                ((ContextHolder)this.list.get(row)).setContext(vc);
            }
        }
        return o;
    }

    public void startEdit(int row) {
        if (this.bp != null && row != this.bp.getSelectRow() && this.bp.getObject() != this.getObject(row)) {
            this.bp.setSelectRow(row);
        }
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(String headerSize) {
        this.headerSize = headerSize;
    }

    public void setValueAt(Object o, int row, int column) {
        if (row == this.getEditingRow() && this.bp != null && this.bp.getObject() != this.getObject(row)) {
            this.bp.setSelectRow(row);
        }
        Object obj = this.list.get(this.extendedObject.getRowInList(row));
        Method setter = this.columns.get(column).getSetter();
        Class<?> argClass = setter.getParameterTypes()[0];
        Object newV = UISetter.getNewValue(argClass, o);
        if (setter != null) {
            try {
                setter.invoke(obj, newV);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        return !this.readOnly && !this.columns.get(column).isReadOnly();
    }

    public List<Object> removeRows(int[] rows) {
        this.canselCellEditor();
        if (this.list instanceof AsyncList) {
            ((AsyncList)this.list).compromateAllData();
            return null;
        }
        ArrayList<Object> remove = new ArrayList<Object>();
        for (int i = 0; i < rows.length; ++i) {
            this.selTable = new int[]{rows[i]};
            for (int j = i + 1; j < rows.length; ++j) {
                if (rows[j] <= rows[i]) continue;
                rows[j] = rows[j] - 1;
            }
            remove.add(this.list.get(rows[i]));
            this.list.remove(rows[i]);
        }
        this.fireTableDataChanged();
        return remove;
    }

    public void setSortKey(List<RowSorter.SortKey> sortKeys) {
        Object sel;
        Object object = sel = this.getSelectedItems() != null && this.getSelectedItems().size() > 0 ? this.getSelectedItems().get(0) : null;
        if (this.list instanceof AsyncList) {
            ArrayList<ObjectSortKey> kl = new ArrayList<ObjectSortKey>(sortKeys.size());
            for (RowSorter.SortKey key : sortKeys) {
                if (!this.isSortable(key.getColumn())) continue;
                kl.add(new ObjectSortKey(this.columns.get(key.getColumn()).getProperty(), key.getSortOrder()));
            }
            ((AsyncList)this.list).setSortKeysFL(kl);
        }
        if (sel != null && this.list instanceof ListWithSelection) {
            ((ListWithSelection)((Object)this.list)).setSelectTo(sel);
        }
        this.fireTableDataChanged();
    }

    public boolean isExternalSorter() {
        return this.list instanceof AsyncList && !((AsyncList)this.list).isFullList();
    }

    public void setViewerToRenderer(int i, FieldViewer<T> fieldviewer) {
        this.viewersToRenderer.put(i, fieldviewer);
    }

    public FieldViewer<T> getViewerToRenderer(int i) {
        return this.viewersToRenderer.get(i);
    }

    public abstract void setViewerToEditor(int var1, FieldViewer<T> var2);

    public void updateModel(List<Object> list, Class<?> item, UIFactory<T> factory, PanelContext pc, TableUIProperties properties, boolean containClassWasChanged, String keyContentProperties) {
        this.list = list;
        this.selTable = null;
        if (containClassWasChanged) {
            this.pc = pc;
            this.columns = new ArrayList<FieldPresentation<T>>(this.extendedObject.getFieldPresentation(item, factory, keyContentProperties, this.viewer.getViewerContext()));
            this.nosortable = new boolean[this.columns.size()];
            this.sorters = new ArrayList<SortKeyForTable>();
            for (int i = 0; i < this.columns.size(); ++i) {
                this.nosortable[i] = false;
                FieldPresentation<T> fp = this.columns.get(i);
                ViewerContext viewerContext = new ViewerContext();
                viewerContext.setParentContext(pc);
                viewerContext.setPresentator(fp);
                viewerContext.setKeyPage(pc.getKeyPage());
                fp.getViewer().setViewerContext(viewerContext);
                fp.getViewer().setBeanViewerActionContextToValidators(viewerContext);
                fp.getViewer().setBeanViewerActionContextToActions(viewerContext);
                if (fp.getFieldProperties() == null) continue;
                for (String key : fp.getFieldProperties().keySet()) {
                    if (key.equals("sortable")) {
                        this.nosortable[i] = fp.getFieldProperties().get(key).toLowerCase().equals("off");
                    }
                    if (!key.equals("sorter")) continue;
                    String value = fp.getFieldProperties().get(key);
                    String[] values = value.split(";");
                    SortKeyForTable sk = new SortKeyForTable(i, Integer.parseInt(values[0]), values[1]);
                    this.sorters.add(sk);
                }
            }
        }
    }

    public abstract void addActionOnSelectionListener(BeanViewerAction<AbstractContext<?>> var1);

    public void update(Object value, ActionID id) {
        if (this.list instanceof List) {
            List<Object> l = this.list;
            if (id != null) {
                switch (id) {
                    case ADD: {
                        if (this.bp != null && this.stopCellEditor()) {
                            this.bp.updateMainObject();
                        }
                        l.add(value);
                        if (this.list instanceof AsyncList) {
                            this.selTable = new int[]{-1};
                            break;
                        }
                        this.selTable = new int[]{l.indexOf(value)};
                        break;
                    }
                    case EDIT: {
                        break;
                    }
                    case REMOVE: {
                        l.remove(value);
                    }
                }
            }
        }
        if (this.list instanceof AsyncList) {
            ((AsyncList)this.list).compromateAllData();
        } else {
            this.fireTableDataChanged();
        }
    }

    public BeanPanelInList<T> getBp() {
        return this.bp;
    }

    public void setBp(BeanPanelInList<T> bp) {
        this.bp = bp;
    }

    public abstract boolean stopCellEditor();

    public abstract void canselCellEditor();

    public abstract void fireTableRowsUpdated(int var1);

    public abstract int getEditingRow();

    public TableUIProperties getUIProperties() {
        return null;
    }

    public void setUIProperties(Object viewerProperty) {
    }

    public void dndEnable(boolean enabled) {
    }

    public abstract List<?> getSortKeys();

    public abstract void setSortKeys(List<?> var1);

    public TableUIProperties getDefaultUIProperties() {
        return null;
    }

    public static class SortKeyForTable
    implements Comparable<SortKeyForTable> {
        private int column;
        private int orderSorter;
        private String sorter;

        public SortKeyForTable(int column, int orderSorter, String sorter) {
            this.column = column;
            this.orderSorter = orderSorter;
            this.sorter = sorter;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public int getOrderSorter() {
            return this.orderSorter;
        }

        public void setOrderSorter(int orderSorter) {
            this.orderSorter = orderSorter;
        }

        public String getSorter() {
            return this.sorter;
        }

        public void setSorter(String sorter) {
            this.sorter = sorter;
        }

        @Override
        public int compareTo(SortKeyForTable o) {
            if (this.orderSorter == o.getOrderSorter()) {
                return 0;
            }
            if (this.orderSorter < o.getOrderSorter()) {
                return -1;
            }
            return 1;
        }
    }

    public static class WorkExtendedObject<T> {
        private TableWithModel<T> tm;

        public WorkExtendedObject(TableWithModel<T> tm) {
            this.tm = tm;
        }

        public TableWithModel<T> getTm() {
            return this.tm;
        }

        public List<FieldPresentation<T>> getFieldPresentation(Class<?> item, UIFactory<T> factory, String keyContentProperties, ViewerContext vc) {
            return FieldPresentation.parse(item, null, factory, "panelInlist", keyContentProperties);
        }

        public Object getValueFromObject(int column, Object o) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.tm.getColumns().get(column).getGetter().invoke(o, new Object[0]);
        }

        public Color[] getColorForegroundBackgroundTable(Object value, int row, int column) {
            return new Color[]{null, null};
        }

        public Font getFontTable(Object value, int row, int column, Font defaultFont) {
            return null;
        }

        public int getRowCount() {
            return this.tm.list != null ? this.tm.list.size() : 0;
        }

        public int getRowInTable(int rowList) {
            return rowList;
        }

        public int getRowInTablePosition(int rowList) {
            return rowList;
        }

        public int getRowInList(int rowTable) {
            return rowTable;
        }

        public boolean canInnerSort() {
            return true;
        }
    }
}

