/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.dialog;

import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.swing.viewers.SimpleImageViewer;
import ru.infor.beanviewer.swing.viewers.SimpleTextViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.TextViewer;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

@ListView(views={@View(title="", layoutKeys={"tabSplitPercentLayoutManager"})})
public class ExceptionMessage
extends ErrorMessage {
    private Exception e;
    private String comment;

    public ExceptionMessage(String message, Exception e) {
        super(message);
        this.e = e;
    }

    public ExceptionMessage(String title, Exception e, String ... message) {
        super(title, message);
        this.e = e;
    }

    @ListField(fields={@Field(title="", viewer={TextViewer.class}, order=30, propertiesLayout="Tab1/\u0421\u0442\u0435\u043a \u0432\u044b\u0437\u043e\u0432\u043e\u0432")})
    public String getException() {
        String stackTrace = "";
        for (StackTraceElement ste : this.e.getStackTrace()) {
            stackTrace = stackTrace + ste.toString() + "\n";
        }
        return stackTrace;
    }

    @Override
    @ListField(fields={@Field(title="", viewer={SimpleImageViewer.class}, order=10, propertiesLayout="Tab1/\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435:1")})
    public String getImage() {
        return super.getImage();
    }

    @Override
    @ListField(fields={@Field(title="", viewer={SimpleTextViewer.class}, order=20, propertiesLayout="Tab1/\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435:1")})
    public String getMessage() {
        return super.getMessage() + "\n\n" + this.e.getMessage();
    }

    @ListField(fields={@Field(title="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u0438, \u043f\u0440\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", viewer={TextViewer.class}, order=40, propertiesLayout="Tab1/\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0443")})
    public String getComment() {
        return this.comment;
    }

    @ListField(fields={@Field(title="", viewer={ActionButton.class}, order=50, propertiesLayout="Tab1/\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0443")})
    public BeanViewerAction getSendButton() {
        return new BeanViewerAction<AbstractContext<?>>(){

            @Override
            public void actionPerformed(Object message) {
                UIFactory<?> factory = ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory();
                try {
                    factory.getReportSender().send("\u041e\u0442\u0447\u0435\u0442 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435", (String)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("comment").getViewer().getValue() + "\n\nStacktrace:\n" + ExceptionMessage.this.e.getMessage() + "\n" + ExceptionMessage.this.getException());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public String getName() {
                return "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c";
            }
        };
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

