/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.samples.invoices;

import java.util.ArrayList;
import java.util.List;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.table.ObjectSortKey;
import ru.infor.beanviewer.samples.invoices.DataFromServerAdd;
import ru.infor.beanviewer.samples.invoices.DataFromServerEdit;
import ru.infor.beanviewer.samples.invoices.DeleteByAnotherUser;
import ru.infor.beanviewer.samples.invoices.InvoiceUI;
import ru.infor.beanviewer.samples.invoices.server.Invoice;
import ru.infor.beanviewer.samples.invoices.server.InvoiceListServerLogic;
import ru.infor.beanviewer.viewer.list.AsynListProvider;
import ru.infor.beanviewer.viewer.list.AsyncList;

@ListView(views={@View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u0447\u0435\u0442\u043e\u0432")})
public class InvoiceListUI {
    private List<InvoiceUI> items = new InvoiceAsyncList();

    @ListField(fields={@Field(title="\u0421\u0447\u0435\u0442\u0430", panels={@PanelField(actions={@ActionField(clazz=DataFromServerEdit.class), @ActionField(clazz=DataFromServerAdd.class), @ActionField(clazz=DeleteByAnotherUser.class)})})})
    public List<InvoiceUI> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceUI> items) {
        this.items = items;
    }

    private class InvoiceAsyncList
    extends AsyncList<InvoiceUI> {
        public InvoiceAsyncList() {
            super(new AsynListProvider<InvoiceUI>(){
                private AsyncList<InvoiceUI> list;
                private List<ObjectSortKey> sortKeys;

                @Override
                public int getCount() {
                    return InvoiceListServerLogic.getInvoiceCount();
                }

                @Override
                public boolean isCountActual() {
                    return true;
                }

                @Override
                public List<InvoiceUI> getValues(int begin, int count) {
                    ArrayList<InvoiceUI> ret = new ArrayList<InvoiceUI>();
                    for (int i = 0; i < count; ++i) {
                        InvoiceUI ii = new InvoiceUI();
                        Invoice in = InvoiceListServerLogic.getInvoice(i + begin);
                        ii.setDate(in.getDate());
                        ii.setDescription(in.getDescription());
                        ii.setNumber(in.getNumber());
                        ii.setSupplier(in.getSupplier().getTitle());
                        ret.add(ii);
                    }
                    return ret;
                }

                @Override
                public boolean add(InvoiceUI obj) {
                    return InvoiceListServerLogic.addInvoice(obj);
                }

                @Override
                public void setAsyncList(AsyncList<InvoiceUI> list) {
                    this.list = list;
                }

                @Override
                public void setSortKeys(List<ObjectSortKey> sortKeys) {
                    this.sortKeys = sortKeys;
                    if (this.list != null) {
                        this.list.compromateAllData();
                    }
                }

                @Override
                public InvoiceUI set(int index, InvoiceUI element) {
                    return InvoiceListServerLogic.setInvoice(index, element);
                }
            }, 25);
        }
    }
}

