/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.samples.invoices.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.samples.invoices.ContractorViewer;
import ru.infor.beanviewer.samples.invoices.server.Contractor;
import ru.infor.beanviewer.samples.invoices.server.InvoiceItem;
import ru.infor.beanviewer.samples.invoices.server.InvoiceOKButton;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.list.ListViewer;

@ListView(views={@View(title="\u0421\u0447\u0435\u0442", actions={@ActionViewer(clazz=InvoiceOKButton.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class Invoice {
    private static int id_gen = 0;
    private static int nm_gen = 0;
    private Integer id;
    private Integer number;
    private String description;
    private Contractor supplier;
    private List<InvoiceItem> items = new ArrayList<InvoiceItem>();
    private Date date;

    public static Invoice createTestInvoice(Contractor contractor) {
        Invoice invoice = new Invoice();
        invoice.id = -1;
        invoice.setSupplier(contractor);
        Calendar c = GregorianCalendar.getInstance();
        c.set(1, c.get(1) - ThreadLocalRandom.current().nextInt(10));
        c.set(2, ThreadLocalRandom.current().nextInt(12));
        c.set(5, 1 + ThreadLocalRandom.current().nextInt(28));
        invoice.setDate(c.getTime());
        invoice.setNumber(++nm_gen);
        int items = ThreadLocalRandom.current().nextInt(20) + 1;
        for (int i = 0; i < items; ++i) {
            InvoiceItem ii = new InvoiceItem();
            ii.setDescription("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430");
            ii.setPrice(ThreadLocalRandom.current().nextLong(1000L));
            ii.setQnt(ThreadLocalRandom.current().nextDouble(1.0, 100.0));
            invoice.addItem(ii);
        }
        return invoice;
    }

    public Long getId() {
        return this.id.longValue();
    }

    public void addItem(InvoiceItem ii) {
        this.items.add(ii);
    }

    @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", order=13, validators={"\u0420\u0430\u043d\u0435\u0435:\u0414\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 22.05.2016:22.05.2016"})})
    public Date getDate() {
        return this.date;
    }

    @ListField(fields={@Field(title="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", order=15, validators={"\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435:\u041d\u0430\u0434\u043e \u043f\u0438\u0441\u0430\u0442\u044c \u0440\u0443\u0441\u0441\u043a\u0438\u043c\u0438 \u0431\u0443\u043a\u0432\u0430\u043c\u0438:[\u0410-\u042f\u0430-\u044f\\s\\d]+"})})
    public String getDescription() {
        return this.description;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f", content=InvoiceItem.class, order=100, viewer={ListViewer.class})})
    public List<InvoiceItem> getList() {
        return this.items;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440", order=10, validators={"\u041c\u0438\u043d\u0438\u043c\u0443\u043c:\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 100:100"})})
    public Integer getNumber() {
        return this.number;
    }

    @ListField(fields={@Field(title="\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c", order=20, viewer={ContractorViewer.class}, emptyItemPresent=true, validators={"\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435:\u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u041e\u041e\u041e:\u041e\u041e\u041e[\u0410-\u042f\u0430-\u044f\\s\\d]+"})})
    public Contractor getSupplier() {
        return this.supplier;
    }

    public void removeItem(int i) {
        this.items.remove(i);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setList(List<InvoiceItem> list) {
        this.items = list;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setSupplier(Contractor supplier) {
        this.supplier = supplier;
    }

    public String toString() {
        return "\u0421\u0447\u0435\u0442 \u2116 " + this.getNumber() + " \u043e\u0442 " + this.getDate() + " \u0434\u043b\u044f " + (this.getSupplier() == null ? "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e \u043a\u043e\u0433\u043e!" : this.getSupplier().toString()) + (this.getList() == null || this.getList().size() == 0 ? "" : ":\n\t") + this.getList().stream().map(i -> i.toString()).collect(Collectors.joining("\n\t"));
    }

    public boolean equals(Object obj) {
        if (this.id != null && obj != null && obj instanceof Invoice) {
            return this.id.equals(((Invoice)obj).id);
        }
        return false;
    }

    public void updateID() {
        this.id = id_gen++;
    }
}

