/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.samples.invoices.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.activation.UnsupportedDataTypeException;
import javax.swing.SortOrder;
import ru.infor.beanviewer.core.table.ObjectSortKey;
import ru.infor.beanviewer.samples.invoices.InvoiceUI;
import ru.infor.beanviewer.samples.invoices.server.Contractor;
import ru.infor.beanviewer.samples.invoices.server.Invoice;
import ru.infor.beanviewer.samples.invoices.server.InvoiceItem;
import ru.infor.beanviewer.samples.invoices.utils.Utils;

public class InvoiceListServerLogic {
    private static long invoiceTimeStamp = System.currentTimeMillis();
    private static List<Invoice> invoices = new ArrayList<Invoice>();
    private static List<Contractor> contractors = Collections.emptyList();
    private static List<ObjectSortKey> sk;

    public static void createInvoices(int contractor_count, int invoice_count) {
        contractors = IntStream.range(0, contractor_count).mapToObj(i -> Contractor.createTestContractor()).collect(Collectors.toList());
        ThreadLocalRandom.current().ints(invoice_count, 0, contractors.size()).mapToObj(i -> Invoice.createTestInvoice(contractors.get(i))).forEach(Utils.rethrowConsumer(i -> InvoiceListServerLogic.save(i)));
    }

    public static int getContractorCount() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return contractors.size();
    }

    public static long getTimeInvoiceStamp() {
        return invoiceTimeStamp;
    }

    public static List<Contractor> getContractor(int begin, int count) {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<Contractor> ret = new ArrayList<Contractor>();
        for (int i = begin; i < begin + count; ++i) {
            ret.add(contractors.get(i));
        }
        return ret;
    }

    public static int getInvoiceCount() {
        return invoices.size();
    }

    public static Invoice getInvoice(long id) {
        return invoices.get((int)id);
    }

    public static List<InvoiceUI> getInvoiceUI(int begin, int count, final List<ObjectSortKey> sortKeys) {
        if (sortKeys != null && !sortKeys.equals(sk)) {
            sk = sortKeys;
            Collections.sort(invoices, new Comparator<Invoice>(){

                @Override
                public int compare(Invoice o1, Invoice o2) {
                    if (((ObjectSortKey)sortKeys.get(0)).getSortOrder().equals((Object)SortOrder.UNSORTED)) {
                        return 0;
                    }
                    if (((ObjectSortKey)sortKeys.get(0)).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        return o1.getDate().compareTo(o2.getDate());
                    }
                    return o2.getDate().compareTo(o1.getDate());
                }
            });
        }
        try {
            Thread.sleep(Math.round(50.0 * Math.sqrt(count)));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<InvoiceUI> ret = new ArrayList<InvoiceUI>();
        for (int i = begin; i < begin + count && i < InvoiceListServerLogic.getInvoiceCount(); ++i) {
            Invoice invoice = invoices.get(i);
            ret.add(InvoiceListServerLogic.getUIByInvoice(invoice));
        }
        return ret;
    }

    private static InvoiceUI getUIByInvoice(Invoice invoice) {
        InvoiceUI iui = new InvoiceUI();
        iui.setDate(invoice.getDate());
        iui.setDescription(invoice.getDescription());
        iui.setNumber(invoice.getNumber());
        iui.setSupplier(invoice.getSupplier().toString());
        double s = 0.0;
        for (InvoiceItem ii : invoice.getList()) {
            s += (double)ii.getPrice().longValue() * ii.getQnt();
        }
        iui.setSumm(s);
        return iui;
    }

    public static Invoice getInvoiceByUI(InvoiceUI object) {
        for (Invoice invoice : invoices) {
            if (!invoice.getNumber().equals(object.getNumber())) continue;
            return invoice;
        }
        return null;
    }

    public static void save(Object object) throws UnsupportedDataTypeException {
        if (object instanceof Invoice) {
            int i = invoices.indexOf(object);
            if (i < 0) {
                invoiceTimeStamp = System.currentTimeMillis();
                ((Invoice)object).updateID();
                invoices.add((Invoice)object);
            } else {
                invoices.set(i, (Invoice)object);
            }
        } else if (object instanceof Contractor) {
            int i = contractors.indexOf(object);
            if (i < 0) {
                contractors.add((Contractor)object);
            } else {
                contractors.set(i, (Contractor)object);
            }
        } else {
            throw new UnsupportedDataTypeException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0431\u0430\u0437\u0435 " + object.getClass());
        }
    }

    public static boolean addContractor(Contractor obj) {
        return contractors.add(obj);
    }

    public static boolean addInvoice(InvoiceUI obj) {
        invoiceTimeStamp = System.currentTimeMillis();
        Invoice i = new Invoice();
        i.setDate(obj.getDate());
        i.setDescription(obj.getDescription());
        i.setNumber(obj.getNumber());
        i.updateID();
        for (Contractor contractor : contractors) {
            if (!contractor.toString().equals(obj.getSupplier())) continue;
            i.setSupplier(contractor);
            break;
        }
        return invoices.add(i);
    }

    public static void removeInvoice(int i) {
        invoiceTimeStamp = System.currentTimeMillis();
        invoices.remove(i);
    }

    public static InvoiceUI setInvoice(int index, InvoiceUI obj) {
        invoiceTimeStamp = System.currentTimeMillis();
        Invoice i = new Invoice();
        i.setDate(obj.getDate());
        i.setDescription(obj.getDescription());
        i.setNumber(obj.getNumber());
        for (Contractor contractor : contractors) {
            if (!contractor.toString().equals(obj.getSupplier())) continue;
            i.setSupplier(contractor);
            break;
        }
        invoices.set(index, i);
        return obj;
    }

    public static Contractor setContractor(int index, Contractor element) {
        return contractors.set(index, element);
    }
}

