/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.samples.invoices.utils;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public final class Utils {
    private Utils() {
    }

    public static <T, R> R putIfAbsent(Map<T, R> map, T key, Supplier<R> supplier) {
        R value;
        if (!map.containsKey(key)) {
            value = supplier.get();
            map.put(key, value);
        } else {
            value = map.get(key);
        }
        return value;
    }

    public static <T> Consumer<T> rethrowConsumer(Consumer_WithExceptions<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Utils.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R> Function<T, R> rethrowFunction(Function_WithExceptions<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Utils.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> IntFunction<T> rethrowIntFunction(IntFunction_WithExceptions<T> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Utils.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> Supplier<T> rethrowSupplier(Supplier_WithExceptions<T> function) {
        return () -> {
            try {
                return function.get();
            }
            catch (Exception exception) {
                Utils.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static void uncheck(Runnable_WithExceptions t) {
        try {
            t.accept();
        }
        catch (Exception exception) {
            Utils.throwAsUnchecked(exception);
        }
    }

    public static <R> R uncheck(Supplier_WithExceptions<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            Utils.throwAsUnchecked(exception);
            return null;
        }
    }

    public static <T, R> R uncheck(Function_WithExceptions<T, R> function, T t) {
        try {
            return function.apply(t);
        }
        catch (Exception exception) {
            Utils.throwAsUnchecked(exception);
            return null;
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface Runnable_WithExceptions {
        public void accept() throws Exception;
    }

    @FunctionalInterface
    public static interface Supplier_WithExceptions<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface IntFunction_WithExceptions<T> {
        public T apply(int var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Consumer_WithExceptions<T> {
        public void accept(T var1) throws Exception;
    }
}

