/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing;

import com.jhlabs.image.ConvolveFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.effect.BufferedImageOpEffect;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import ru.infor.beanviewer.classes.ViewWithKey;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.DefaultViewer;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.ManagerBeanPanel;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.flow.FlowManager;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.core.tree.Tree;
import ru.infor.beanviewer.core.ui.UIMainProperties;
import ru.infor.beanviewer.dialog.CommonMessage;
import ru.infor.beanviewer.dialog.WindowMessage;
import ru.infor.beanviewer.swing.JScrollPopupMenu;
import ru.infor.beanviewer.swing.SwingHelper;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.swing.SwingPanel;
import ru.infor.beanviewer.swing.layout.DefaultSwingLayoutManager;
import ru.infor.beanviewer.swing.layout.FourColumnLayoutManager;
import ru.infor.beanviewer.swing.layout.GroupSwingLayoutManager;
import ru.infor.beanviewer.swing.layout.LargeSimpleFieldsLayout;
import ru.infor.beanviewer.swing.layout.TabSplitPercentLayoutManager;
import ru.infor.beanviewer.swing.layout.TestSwingLayoutManager;
import ru.infor.beanviewer.swing.viewers.SwingObjectManager;
import ru.infor.beanviewer.swing.viewers.SwingTree;
import ru.infor.beanviewer.swing.viewers.directory.TDVComboBox;
import ru.infor.beanviewer.swing.viewers.list.MultiSortTableCellHeaderRenderer;
import ru.infor.beanviewer.swing.viewers.list.SwingListTableModel;
import ru.infor.beanviewer.validator.ValidatorListener;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.ByteArrayFromFileViewer;
import ru.infor.beanviewer.viewer.ComplexObjectViewer;
import ru.infor.beanviewer.viewer.ImageViewer;
import ru.infor.beanviewer.viewer.ListActionViewer;
import ru.infor.beanviewer.viewer.ObjectManager;
import ru.infor.beanviewer.viewer.action.ActionList;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.directory.AutoSearchComboBoxEditor;
import ru.infor.beanviewer.viewer.directory.TunedDirectoryViewer;
import ru.infor.beanviewer.viewer.list.ListTableEditor;
import ru.infor.beanviewer.viewer.list.ListTableRenderer;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.menu.Menu;
import ru.infor.beanviewer.viewer.menu.MenuAction;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.beanviewer.viewer.simple.BigDecimalViewer;
import ru.infor.beanviewer.viewer.simple.BooleanViewer;
import ru.infor.beanviewer.viewer.simple.ClassViewer;
import ru.infor.beanviewer.viewer.simple.ColorViewer;
import ru.infor.beanviewer.viewer.simple.PSValue;
import ru.infor.beanviewer.viewer.simple.SliderValue;
import ru.infor.beanviewer.viewer.simple.SliderViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithButton;

public class SwingFactory
extends UIFactory<JComponent> {
    private static final Border default_border = BorderFactory.createEtchedBorder(1);
    private static SwingFactory currentFactory;
    static HashMap<String, Class<? extends UIGLayoutManager<JComponent>>> mapLayout;
    HashMap<JComponent, Color> mapColor = new HashMap();
    private static HashMap<String, List<BeanPanel<JComponent>>> panels;
    protected BufferedImage splashImage;
    private HashMap<String, FlowManager<JComponent>> flowManagers = new HashMap();

    public static SwingFactory getInstance() {
        if (currentFactory == null) {
            currentFactory = new SwingFactory();
            currentFactory.registerViewer(Boolean.class, BooleanViewer.class);
            currentFactory.registerViewer(Boolean.TYPE, BooleanViewer.class);
            currentFactory.registerViewer(Color.class, ColorViewer.class);
            currentFactory.registerViewer(List.class, ListViewer.class);
            currentFactory.registerViewer(Object[].class, ListViewer.class);
            currentFactory.registerViewer(SortedSet.class, ListViewer.class);
            currentFactory.registerViewer(Collection.class, ListViewer.class);
            currentFactory.registerViewer(Set.class, ListViewer.class);
            currentFactory.registerViewer(Date.class, DateWithButton.class);
            currentFactory.registerViewer(Class.class, ClassViewer.class);
            currentFactory.registerViewer(BufferedImage.class, ImageViewer.class);
            currentFactory.registerViewer(byte[].class, ByteArrayFromFileViewer.class);
            currentFactory.registerViewer(Object.class, ComplexObjectViewer.class);
            currentFactory.registerViewer(SliderValue.class, SliderViewer.class);
            currentFactory.registerViewer(BigDecimal.class, BigDecimalViewer.class);
        }
        return currentFactory;
    }

    @Override
    public Class<? extends UIGLayoutManager<?>> getUIGLayoutManagerbyKey(String key) {
        return mapLayout.get(key);
    }

    @Override
    public void revalidate(JComponent component) {
        component.revalidate();
    }

    @Override
    public void addActionToComponent(JComponent component, final BeanViewerAction<?> action) {
        if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
        if (component instanceof JTextField) {
            ((JTextComponent)component).addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    action.actionPerformed(null);
                }
            });
            ((JTextField)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
        if (component instanceof JRadioButton) {
            ((JRadioButton)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
        if (component instanceof JSlider) {
            ((JSlider)component).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
    }

    @Override
    public void addActionToComponentOnEnter(JComponent component, final BeanViewerAction<?> action) {
        JComponent c;
        if (component instanceof TDVComboBox) {
            c = ((AutoSearchComboBoxEditor)((TDVComboBox)component).getEditor()).getField();
            ((AutoSearchComboBoxEditor)((TDVComboBox)component).getEditor()).setTransferOnenter(true);
        } else {
            c = component;
        }
        c.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "EnterAction");
        c.getActionMap().put("EnterAction", new AbstractAction(){
            private static final long serialVersionUID = 5519692762748660172L;

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(e);
            }
        });
    }

    @Override
    public void addItemToComboBox(JComponent comboBox, Object item) {
        if (comboBox instanceof JComboBox) {
            JComboBox jcb = (JComboBox)comboBox;
            jcb.addItem(item);
        }
    }

    @Override
    public void setValidateToComponent(JComponent component, String message, Boolean validate) {
        if (!validate.booleanValue()) {
            component.setToolTipText(message);
            if (component instanceof JLabel && this.mapColor.get(component.getParent()) != null) {
                component.getParent().setBackground(new Color(1.0f, 0.7f, 0.7f));
            } else {
                component.setBackground(new Color(1.0f, 0.7f, 0.7f));
            }
        } else {
            component.setToolTipText(message);
            if (component instanceof JLabel && this.mapColor.get(component.getParent()) != null) {
                component.getParent().setBackground(this.mapColor.get(component.getParent()));
            } else {
                component.setBackground(this.mapColor.get(component));
            }
        }
    }

    @Override
    public void setValidatorListener(final JComponent component, final ValidatorListener<JComponent> validatorListener) {
        if (component instanceof JTextComponent) {
            this.rememberComponentBackgroundColor(component);
            validatorListener.setComponent(component);
            ((JTextComponent)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    validatorListener.validate(component);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    validatorListener.validate(component);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    validatorListener.validate(component);
                }
            });
            if (component instanceof JUITextField) {
                this.rememberComponentBackgroundColor(component);
                validatorListener.setComponent(component);
                ((JUITextField)component).addAction(new BeanViewerAction<ViewerContext>(){

                    @Override
                    public void actionPerformed(Object message) {
                        validatorListener.validate(component);
                    }
                });
                ((JUITextField)component).addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        validatorListener.validate(component);
                    }
                });
            }
            if (component instanceof JUITextPane) {
                this.rememberComponentBackgroundColor(component);
                validatorListener.setComponent(component);
                ((JUITextPane)component).addAction(new BeanViewerAction<ViewerContext>(){

                    @Override
                    public void actionPerformed(Object message) {
                        validatorListener.validate(component);
                    }
                });
            }
            if (component instanceof JUIFormattedTextField) {
                this.rememberComponentBackgroundColor(component);
                validatorListener.setComponent(component);
                ((JUIFormattedTextField)component).addAction(new BeanViewerAction<ViewerContext>(){

                    @Override
                    public void actionPerformed(Object message) {
                        validatorListener.validate(component);
                    }
                });
            }
        } else if (component instanceof JUIComboBox && !(component instanceof TDVComboBox)) {
            this.rememberComponentBackgroundColor(component);
            validatorListener.setComponent(component);
            ((JComboBox)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    validatorListener.validate(component);
                }
            });
        } else if (component instanceof JLabelWithValidator) {
            validatorListener.setComponent(component);
            ((JLabelWithValidator)component).addValidatorListener(validatorListener);
        } else if (component instanceof JRadioButton) {
            validatorListener.setComponent(component);
            ((JRadioButton)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    validatorListener.validate(component);
                }
            });
        } else {
            for (Component c : component.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.setValidatorListener((JComponent)c, validatorListener);
            }
        }
    }

    @Override
    public boolean canManage(Class<?> mclass) {
        return SwingItem.class.isAssignableFrom(mclass);
    }

    @Override
    public void clearContainer(JComponent container) {
        container.removeAll();
        container.repaint();
    }

    @Override
    public JComponent createBigPanel(JComponent contentComponent, List<ObjectManager<JComponent>> oml) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(contentComponent), "Center");
        JPanel panel2 = this.getPanelManager();
        for (ObjectManager<JComponent> om : oml) {
            panel2.add((Component)om.getComponent(), "growx");
        }
        panel.add((Component)panel2, "North");
        return panel;
    }

    @Override
    public void addSouthPanelToBigPanel(JComponent panel, JComponent southPanel) {
        panel.add((Component)southPanel, "South");
    }

    @Override
    public ObjectManager<JComponent> createObjectManager() {
        return new SwingObjectManager();
    }

    @Override
    public BeanPanel<JComponent> createPanel(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView) {
        return this.getPanelFromCache(contentClass, fieldClass, obj, vc, keyView);
    }

    @Override
    public JComponent getAction(final BeanViewerAction<?> bva, JComponent button) {
        JButton ret;
        if (bva != null && bva.getUI(this) != null) {
            return bva.getUI(this);
        }
        Action a = this.createAction(bva, null, null);
        JButton jButton = ret = button != null && button instanceof JButton ? (JButton)button : new JButton();
        if (bva instanceof ActionList) {
            final JScrollPopupMenu pop = new JScrollPopupMenu();
            BeanViewerAction<ViewerContext> aa = new BeanViewerAction<ViewerContext>(){

                @Override
                public void actionPerformed(Object message) {
                    if (pop.getSubElements().length <= 0) {
                        for (Object object : ((ActionList)bva).getItems()) {
                            JMenuItem mi = new JMenuItem();
                            mi.setAction(SwingFactory.this.createAction(bva, object.toString(), object));
                            pop.add(mi);
                        }
                        pop.pack();
                    }
                    pop.show(ret, ret.getWidth(), 2);
                }
            };
            aa.setHint(bva.getHint());
            aa.setIcon(bva.getIcon());
            aa.setName(bva.getName());
            ret.setAction(this.createAction(aa, null, null));
        } else {
            ret.setAction(a);
            if (bva instanceof AsyncBVA) {
                AsyncBVA async = (AsyncBVA)bva;
                async.setBeforeAndAfterActions(() -> ret.setEnabled(false), () -> ret.setEnabled(true));
            }
        }
        if (bva != null && bva.getHint() != null) {
            ret.setToolTipText(bva.getHint());
        }
        return ret;
    }

    public Action createAction(final BeanViewerAction<?> bva, String name, final Object object) {
        Action a = bva == null ? null : (bva.getIcon() != null ? new AbstractAction(name == null ? bva.getName() : name, new ImageIcon(this.getClass().getResource(bva.getIcon()))){
            private static final long serialVersionUID = -3529814253249469450L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingFactory.this.setCursor(1);
                        try {
                            bva.actionPerformed(object);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            SwingFactory.this.setCursor(0);
                        }
                    }
                });
            }
        } : new AbstractAction(name == null ? bva.getName() : name){
            private static final long serialVersionUID = -9151559719765147295L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingFactory.this.setCursor(1);
                        bva.actionPerformed(null);
                        SwingFactory.this.setCursor(0);
                    }
                });
            }
        });
        if (a != null) {
            a.setEnabled(bva.isEnable());
        }
        return a;
    }

    @Override
    public JComponent getAugmentPanel() {
        return new JPanel(new BorderLayout());
    }

    public Object getChangedProperties(JComponent component) {
        if (component instanceof JTable) {
            TableColumnModel m = ((JTable)component).getColumnModel();
            Integer[] ret = new Integer[m.getColumnCount()];
            for (int i = 0; i < m.getColumnCount(); ++i) {
                ret[i] = m.getColumn(i).getWidth();
            }
            return ret;
        }
        return null;
    }

    @Override
    public JComponent getCheckBox() {
        return new JUICheckBox();
    }

    @Override
    public void setCaptionToCheckBox(String name, JComponent ch) {
        ((JCheckBox)ch).setText(name);
    }

    @Override
    public JComponent getComboBox(final BaseDirectoryViewer<JComponent> dv) {
        JUIComboBox ret = new JUIComboBox();
        ret.setBackground(Color.white);
        UIManager.put("ComboBox.timeFactor", (long)Settings.getComboboxTimeFactor().intValue() * 1000L);
        ret.getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), "update");
        ret.getActionMap().put("update", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dv != null) {
                    dv.clearCache();
                }
            }
        });
        return ret;
    }

    @Override
    public Object[] getRadioButtonList(List<?> listObject, JComponent panel, Integer disposition) {
        ButtonGroup bg = new ButtonGroup();
        HashMap map = new HashMap();
        for (Object o : listObject) {
            JRadioButton radioButton = new JRadioButton();
            radioButton.setText(o == null ? "" : o.toString());
            bg.add(radioButton);
            panel.add((Component)radioButton, disposition.equals(0) ? "" : "newline");
            map.put(o, radioButton);
        }
        return new Object[]{listObject, map, bg};
    }

    @Override
    public void clearSelectionInButtonGroup(Object buttonGroup) {
        ((ButtonGroup)buttonGroup).clearSelection();
    }

    @Override
    public void setSelectedToRadioButton(Object[] rb, Object select, boolean editable, boolean empty) {
        List listObject = (List)rb[0];
        HashMap map = (HashMap)rb[1];
        boolean f = false;
        for (Object o : listObject) {
            if (!o.equals(select)) continue;
            f = true;
            ((JRadioButton)map.get(o)).setSelected(true);
        }
        if (!f && editable && listObject.size() > 0 && !empty) {
            ((JRadioButton)map.get(listObject.get(0))).setSelected(false);
        } else if (!f) {
            this.clearSelectionInButtonGroup(rb[2]);
        }
    }

    @Override
    public Object getSelectedFromRadioButton(Object[] rb) {
        List listObject = (List)rb[0];
        HashMap map = (HashMap)rb[1];
        for (Object o : listObject) {
            if (!((JRadioButton)map.get(o)).isSelected()) continue;
            return o;
        }
        return null;
    }

    @Override
    public void setChangeValueActionToRadio(Object[] rb, BeanViewerAction<ViewerContext> changeAction) {
        HashMap map = (HashMap)rb[1];
        for (JComponent c : map.values()) {
            this.addActionToComponent(c, changeAction);
        }
    }

    @Override
    public void setEditableToRadio(Object[] rb, boolean editable) {
        HashMap map = (HashMap)rb[1];
        for (JComponent c : map.values()) {
            this.setComponentEditable(c, editable);
        }
    }

    @Override
    public UIGLayoutManager<JComponent> getDefaultLayoutManager() {
        return new DefaultSwingLayoutManager();
    }

    @Override
    public FieldViewer<JComponent> getDefaultViewer() {
        return new DefaultViewer<JComponent>(this);
    }

    @Override
    public JComponent getLabel(String string) {
        JLabelWithValidator label = new JLabelWithValidator(string);
        return label;
    }

    @Override
    public JComponent getLabelField(String string) {
        JLabel label = new JLabel(string);
        label.setHorizontalAlignment(4);
        return label;
    }

    @Override
    public List<JComponent> getNativeMenu(Menu menu) {
        ArrayList<JComponent> menus = new ArrayList<JComponent>();
        for (BaseNode baseNode : menu.getChildren()) {
            Menu sub = (Menu)baseNode;
            if (sub.isDivider()) {
                menus.add(new JSeparator(1));
                continue;
            }
            JMenu m = new JMenu(sub.getName());
            menus.add(m);
            this.setSubMenu(m, sub);
        }
        return menus;
    }

    private void setSubMenu(JMenuItem mi, Menu menu) {
        for (BaseNode baseNode : menu.getChildren()) {
            if (((Menu)baseNode).isDivider()) {
                mi.add(new JSeparator(0));
                continue;
            }
            JMenu item = new JMenu(baseNode.getName());
            this.setSubMenu(item, (Menu)baseNode);
            mi.add(item);
        }
        if (menu.getActions() != null) {
            for (MenuAction menuAction : menu.getActions()) {
                if (menuAction.isDivider()) {
                    mi.add(new JSeparator());
                    continue;
                }
                JMenuItem i = new JMenuItem(this.createAction(menuAction.getBva(), menuAction.getTitle(), null));
                if (menuAction.getBva() != null && menuAction.getBva().getHotKey() != null) {
                    i.setAccelerator(KeyStroke.getKeyStroke(menuAction.getBva().getHotKey().getKey(), menuAction.getBva().getHotKey().getModifier()));
                }
                mi.add(i);
            }
        }
    }

    @Override
    public JComponent getPanel() {
        return new JPanel((LayoutManager)new MigLayout("insets 0 0, hidemode 2,fillx", "[]0", "[]0"));
    }

    @Override
    public void clearCashInterface() {
        super.clearCashInterface();
        panels.clear();
    }

    @Override
    public void deleteFromCache(String key) {
        ArrayList<String> keysDel = new ArrayList<String>();
        for (String k : panels.keySet()) {
            if (k.indexOf(key) <= -1) continue;
            keysDel.add(k);
        }
        for (String k : keysDel) {
            panels.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanPanel<JComponent> getPanelFromCache(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView) {
        String key = (contentClass == null ? "null" : contentClass.getName()) + (fieldClass == null ? "null" : fieldClass.getName()) + (obj == null ? "" : obj.getClass().getName()) + keyView;
        Class<?> clazz = fieldClass;
        synchronized (clazz) {
            List<Object> bpl;
            if (panels.containsKey(key)) {
                bpl = panels.get(key);
                for (BeanPanel beanPanel : bpl) {
                    if (beanPanel.isVisible()) continue;
                    beanPanel.setContext(vc);
                    beanPanel.setObject(obj);
                    beanPanel.storeOldValues();
                    return beanPanel;
                }
            } else {
                bpl = new ArrayList();
                panels.put(key, bpl);
            }
            long l = System.currentTimeMillis();
            SwingPanel bp = new SwingPanel(contentClass, fieldClass, obj, vc, this, keyView);
            bpl.add(bp);
            return bp;
        }
    }

    @Override
    public Object getSelectedItem(JComponent component) {
        if (component instanceof JComboBox) {
            JComboBox jcb = (JComboBox)component;
            return jcb.getSelectedItem();
        }
        return null;
    }

    @Override
    public TableWithModel<JComponent> getTable(BigContentViewer<JComponent> fv) {
        return new SwingListTableModel(fv);
    }

    @Override
    public JComponent getTextField() {
        JUITextField t = new JUITextField();
        FontMetrics ff = t.getFontMetrics(t.getFont());
        t.setPreferredSize(new Dimension(100, ff.getHeight() + 9));
        return t;
    }

    @Override
    public JComponent getFormattedTextField(Format format) {
        return new JUIFormattedTextField(format);
    }

    @Override
    public void selectTextIntoTextField(JComponent textField, Integer select) {
        if (select == null) {
            ((JTextField)textField).selectAll();
        } else {
            ((JTextField)textField).select(0, select);
        }
    }

    @Override
    public void setActionOnFocusComponent(JComponent textField, final BeanViewerAction<?> bva, final boolean focusGained, final boolean focusLost) {
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (focusGained) {
                    bva.actionPerformed(null);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (focusLost) {
                    bva.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public void setHorizontalAlignmentToTextField(JComponent textField, String s) {
        if (s.toUpperCase().equals("RIGHT")) {
            ((JTextField)textField).setHorizontalAlignment(4);
            return;
        }
        if (s.toUpperCase().equals("LEFT")) {
            ((JTextField)textField).setHorizontalAlignment(2);
            return;
        }
        if (s.toUpperCase().equals("CENTER")) {
            ((JTextField)textField).setHorizontalAlignment(0);
            return;
        }
    }

    @Override
    public String getTextFromComponent(JComponent component) {
        if (component instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (component instanceof JLabel) {
            return ((JLabel)component).getText();
        }
        if (component instanceof JButton) {
            return ((JButton)component).getText();
        }
        return null;
    }

    @Override
    public boolean isCheckBoxSelected(JComponent checkBox) {
        if (checkBox instanceof JCheckBox) {
            return ((JCheckBox)checkBox).isSelected();
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean backward() {
        return this.backward("");
    }

    @Override
    public boolean backward(String keyPage) {
        if (this.flowManagers.get(keyPage) == null) {
            return false;
        }
        return this.flowManagers.get(keyPage).backward();
    }

    @Override
    @Deprecated
    public void close() {
        this.close("");
    }

    @Override
    public void close(String keyPage) {
        this.flowManagers.get(keyPage).close();
        this.flowManagers.remove(keyPage);
    }

    @Override
    public void newWindow(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, String keyPage, boolean oneWindow, BeanViewerAction<?> bva, boolean alwaysOnTop) {
        ModalWindowFlowManager f;
        PropertyManager.addStatistic(fieldClass.getName(), keyView);
        if (!oneWindow) {
            keyPage = keyPage + new Date().toString();
        }
        vc.setKeyPage(keyPage);
        if (this.flowManagers.get(keyPage) == null) {
            this.setFlowManager(keyPage, new ModalWindowFlowManager(this, false));
            this.flowManagers.get(keyPage).newPage(contentClass, fieldClass, obj, vc, keyView, bva);
        } else {
            f = (ModalWindowFlowManager)this.flowManagers.get(keyPage);
            f.currentPostion();
            f.getCurrentPanel().setObject(obj);
            ((BeanPanel)f.getCurrentPanel()).getPanelContext().setParentContext(vc);
            ((BeanPanel)f.getCurrentPanel()).getPanelContext().setObject(obj);
            f.getCurrentPanel().updateUI();
        }
        f = (ModalWindowFlowManager)this.flowManagers.get(keyPage);
        f.setAlwaysOnTop(alwaysOnTop);
        Component c = f.getPageContainer();
        if (c instanceof JFrame) {
            ((JFrame)c).setAlwaysOnTop(alwaysOnTop);
        } else {
            ((JDialog)c).setAlwaysOnTop(alwaysOnTop);
        }
    }

    @Override
    public void newWindow(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, String keyPage, boolean oneWindow) {
        this.newWindow(contentClass, fieldClass, obj, vc, keyView, keyPage, oneWindow, null, false);
    }

    @Override
    public void newWindow(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, String keyPage, boolean oneWindow, boolean alwaysOnTop) {
        this.newWindow(contentClass, fieldClass, obj, vc, keyView, keyPage, oneWindow, null, alwaysOnTop);
    }

    @Override
    public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, String keyPage, BeanViewerAction<?> bva) {
        PropertyManager.addStatistic(fieldClass.getName(), keyView);
        if (this.flowManagers.get(keyPage) == null) {
            this.setFlowManager(keyPage, new ModalWindowFlowManager(this, false));
        }
        if (obj != null && obj instanceof ViewWithKey && vc != null && vc.getParentContext() != null && ((PanelContext)vc.getParentContext()).getObject() != null && ((PanelContext)vc.getParentContext()).getObject() instanceof ViewWithKey) {
            ((ViewWithKey)obj).setKey(((ViewWithKey)((PanelContext)vc.getParentContext()).getObject()).getKey());
        }
        this.flowManagers.get(keyPage).newPage(contentClass, fieldClass, obj, vc, keyView, bva);
    }

    @Override
    public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, BeanViewerAction<?> bva) {
        String key = "";
        if (vc != null) {
            key = vc.getKeyPage();
        }
        this.newPage(contentClass, fieldClass, obj, vc, keyView, key, bva);
    }

    @Override
    public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc) {
        this.newPage(contentClass, fieldClass, obj, vc, "");
    }

    @Override
    public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView) {
        String key = "";
        if (vc != null) {
            key = vc.getKeyPage();
        }
        this.newPage(contentClass, fieldClass, obj, vc, keyView, key);
    }

    @Override
    public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, String keyPage) {
        this.newPage(contentClass, fieldClass, obj, vc, keyView, keyPage, null);
    }

    @Override
    public void putObjectToContainer(JComponent component, JComponent container, Object constraint) {
        container.add((Component)component, constraint);
    }

    @Override
    public Color runColorChooser(Color color) {
        return JColorChooser.showDialog(null, "\u0412\u044b\u0431\u043e\u0440 \u0446\u0432\u0435\u0442\u0430", color);
    }

    @Override
    public File runFileChooser(File file, int fileSelectionMode, FileFilter ff, String desc) {
        JFileChooser jfc = new JFileChooser(file);
        jfc.setSelectedFile(file);
        jfc.setFileSelectionMode(fileSelectionMode);
        jfc.setFileFilter(ff);
        int i = jfc.showDialog(null, desc);
        return i == 0 ? jfc.getSelectedFile() : file;
    }

    @Override
    public File runFileChooser(File file, int fileSelectionMode, FileFilter ff) {
        return this.runFileChooser(file, fileSelectionMode, ff, "\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u0430");
    }

    @Override
    public void setBFColorsToComponent(JComponent component, boolean selected) {
        component.setBackground(selected ? SwingHelper.getSelectedBackground() : SwingHelper.getUnselectedBackground());
        component.setForeground(selected ? SwingHelper.getSelectedForeground() : SwingHelper.getUnselectedForeground());
    }

    @Override
    public void setCheckBoxSelected(JComponent checkBox, boolean b) {
        if (checkBox instanceof JCheckBox) {
            ((JCheckBox)checkBox).setSelected(b);
        }
    }

    @Override
    public void setComponentColor(JComponent component, Color color) {
        component.setBackground(color);
    }

    @Override
    public void setComponentEditable(JComponent component, boolean editable) {
        if (component != null) {
            if (component instanceof JTextField) {
                ((JTextField)component).setEditable(editable);
            } else {
                component.setEnabled(editable);
            }
        }
    }

    @Override
    public void setComponentVisible(JComponent component, boolean visible) {
        if (component != null) {
            component.setVisible(visible);
        }
    }

    @Override
    public void setComponentSize(JComponent component, int width, int height) {
        component.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setEmptyBorderToComponent(JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void setFlowManager(FlowManager<JComponent> flowManager) {
        this.setFlowManager("", flowManager);
    }

    @Override
    public FlowManager<JComponent> getFlowManager() {
        return this.getFlowManager("");
    }

    @Override
    public void setFlowManager(String keyPage, FlowManager<JComponent> flowManager) {
        this.flowManagers.put(keyPage, flowManager);
    }

    @Override
    public FlowManager<JComponent> getFlowManager(String keyPage) {
        return this.flowManagers.get(keyPage);
    }

    @Override
    public void removeFlowManager(String keyPage) {
        this.flowManagers.remove(keyPage);
    }

    @Override
    public void setItemsToComboBox(JComponent comboBox, List<?> items, Object selected) {
        if (comboBox instanceof JComboBox) {
            JComboBox jcb = (JComboBox)comboBox;
            if (items != null) {
                jcb.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
                jcb.setSelectedItem(selected);
            } else {
                jcb.removeAllItems();
            }
        }
    }

    @Override
    public void setPropertyToComponent(String key, String property, JComponent component) {
        String[] dim;
        if (component instanceof JTable && "autoresize".equals(key.toLowerCase())) {
            if ("off".equals(property.toLowerCase())) {
                ((JTable)component).setAutoResizeMode(0);
            } else if ("all_columns".equals(property.toLowerCase())) {
                ((JTable)component).setAutoResizeMode(4);
            } else if ("last_column".equals(property.toLowerCase())) {
                ((JTable)component).setAutoResizeMode(3);
            } else if ("next_column".equals(property.toLowerCase())) {
                ((JTable)component).setAutoResizeMode(1);
            } else if ("subsequent_columns".equals(property.toLowerCase())) {
                ((JTable)component).setAutoResizeMode(2);
            }
        }
        if ("background".equals(key.toLowerCase())) {
            component.setBackground(Color.decode(property));
            this.rememberComponentBackgroundColor(component);
            for (Component c : component.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.setPropertyToComponent(key, property, (JComponent)c);
            }
        }
        if ("opaque".equals(key.toLowerCase())) {
            component.setOpaque(Boolean.parseBoolean(property));
        }
        if ("border".equals(key.toLowerCase())) {
            component.setBorder(Boolean.parseBoolean(property) ? default_border : null);
        }
        if ("titleborder".equals(key.toLowerCase())) {
            component.setBorder(new TitledBorder(property));
        }
        if ("size".equals(key.toLowerCase())) {
            dim = property.split("x");
            component.setPreferredSize(new Dimension(Integer.parseInt(dim[0]), Integer.parseInt(dim[1])));
        }
        if ("minsize".equals(key.toLowerCase())) {
            dim = property.split("x");
            component.setMinimumSize(new Dimension(Integer.parseInt(dim[0]), Integer.parseInt(dim[1])));
        }
        if ("hint".equals(key.toLowerCase())) {
            component.setToolTipText(property);
            for (Component c : component.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                this.setPropertyToComponent(key, property, (JComponent)c);
            }
        }
        if ("visible".equals(key.toLowerCase())) {
            component.setVisible(Boolean.parseBoolean(property));
        }
        if ("icon".equals(key.toLowerCase()) && component instanceof JButton) {
            if (property == null || property.equals("")) {
                ((JButton)component).setIcon(null);
            } else {
                ((JButton)component).setIcon(new ImageIcon(this.getClass().getResource(property)));
            }
        }
        if ("horizontalalignment".equals(key.toLowerCase())) {
            if (component instanceof JTextField) {
                if ("left".equals(property.toLowerCase())) {
                    ((JTextField)component).setHorizontalAlignment(2);
                }
                if ("right".equals(property.toLowerCase())) {
                    ((JTextField)component).setHorizontalAlignment(4);
                }
                if ("center".equals(property.toLowerCase())) {
                    ((JTextField)component).setHorizontalAlignment(0);
                }
            } else if (component instanceof JLabel) {
                if ("left".equals(property.toLowerCase())) {
                    ((JLabel)component).setHorizontalAlignment(2);
                }
                if ("right".equals(property.toLowerCase())) {
                    ((JLabel)component).setHorizontalAlignment(4);
                }
                if ("center".equals(property.toLowerCase())) {
                    ((JLabel)component).setHorizontalAlignment(0);
                }
            } else if (component instanceof JCheckBox) {
                if ("left".equals(property.toLowerCase())) {
                    ((JCheckBox)component).setHorizontalAlignment(2);
                }
                if ("right".equals(property.toLowerCase())) {
                    ((JCheckBox)component).setHorizontalAlignment(4);
                }
                if ("center".equals(property.toLowerCase())) {
                    ((JCheckBox)component).setHorizontalAlignment(0);
                }
            } else {
                for (Component c : component.getComponents()) {
                    if (!(c instanceof JComponent)) continue;
                    this.setPropertyToComponent(key, property, (JComponent)c);
                }
            }
        }
        if ("max".equals(key.toLowerCase()) && component instanceof JSlider) {
            ((JSlider)component).setMaximum(Integer.parseInt(property));
        }
        if ("min".equals(key.toLowerCase()) && component instanceof JSlider) {
            ((JSlider)component).setMinimum(Integer.parseInt(property));
        }
    }

    private void rememberComponentBackgroundColor(JComponent component) {
        this.mapColor.put(component, component.getBackground());
        if (component instanceof JLabel && component.getParent() != null && component.getParent() instanceof JComponent) {
            this.mapColor.put((JComponent)component.getParent(), component.getParent().getBackground());
        }
    }

    @Override
    public void setTextToComponent(JComponent component, String text) {
        if (component instanceof JTextField) {
            try {
                ((JTextField)component).setText(text);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (component instanceof JLabel) {
            ((JLabel)component).setText(text);
        } else if (component instanceof JButton) {
            ((JButton)component).setText(text);
        } else if (component instanceof JComboBox) {
            JComboBox cb = (JComboBox)component;
            if (cb.isEditable()) {
                cb.getEditor().setItem(text);
            }
        } else if (component instanceof JPanel) {
            Component tc = null;
            for (Component c : component.getComponents()) {
                if (c.getName() == null || !c.getName().equals("label_for_text_in_the_panel")) continue;
                tc = c;
                break;
            }
            if (tc == null) {
                tc = this.getLabel(text);
                tc.setName("label_for_text_in_the_panel");
                component.add(tc);
            } else {
                ((JLabel)tc).setText(text);
            }
        }
    }

    @Override
    public void setVisibleObject(JComponent object, boolean visible) {
        object.setVisible(visible);
    }

    @Override
    public void CloseDialog(Object object) {
        ((JDialog)object).setVisible(false);
        this.setLocked(false);
    }

    @Override
    public Tree<JComponent> getTree() {
        return new SwingTree();
    }

    @Override
    @Deprecated
    public int runMessage(String title, String message, BeanViewerAction<?> ... actions) {
        final JDialog m = new JDialog();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panelLab = new JPanel(new BorderLayout());
        JLabel l = new JLabel(message);
        panelLab.add((Component)l, "Center");
        panel.add((Component)panelLab, "North");
        m.setContentPane(panel);
        m.setModal(true);
        final ArrayList<Integer> rezult = new ArrayList<Integer>(1);
        rezult.add(-1);
        JPanel panelBva = new JPanel();
        for (int i = 0; i < actions.length; ++i) {
            final int k = i;
            BeanViewerAction<?> bva = actions[i];
            JButton b = (JButton)this.getAction(bva, null);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    m.setVisible(false);
                    rezult.set(0, k);
                }
            });
            panelBva.add(b);
        }
        panel.add((Component)panelBva, "Center");
        m.pack();
        m.setTitle(title);
        m.setLocationRelativeTo(null);
        m.setVisible(true);
        return (Integer)rezult.get(0);
    }

    @Override
    public JComponent getPasswordField() {
        JPasswordField passwordField = new JPasswordField();
        passwordField.setEchoChar('*');
        return passwordField;
    }

    @Override
    public char[] getPasswordFromComponent(JComponent component) {
        return ((JPasswordField)component).getPassword();
    }

    @Override
    public boolean isRoot(String keyPage) {
        return this.flowManagers.get(keyPage).isRoot();
    }

    @Override
    public boolean isRoot() {
        return this.isRoot("");
    }

    @Override
    public JPanel getPanelManager() {
        return new JPanel((LayoutManager)new MigLayout("insets 0 0, hidemode 2, wrap 1, fillx", "[]3", "[]0"));
    }

    @Override
    public JPanel getPanelInManager() {
        return new JPanel(new FlowLayout(0, 0, 0));
    }

    @Override
    public JComponent init(final Object obj, final ManagerBeanPanel<JComponent> mbp, JComponent content, JComponent management) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0)){
            private static final long serialVersionUID = 4990720082063638096L;
            boolean initialized;
            {
                super(x0);
                this.initialized = false;
            }

            @Override
            public void paint(Graphics g) {
                if (!this.initialized) {
                    this.initialized = true;
                    mbp.setObject(obj);
                }
                super.paint(g);
            }
        };
        if (content != null) {
            panel.add(content);
        }
        if (management != null) {
            panel.add(management);
        }
        return panel;
    }

    @Override
    public void runMessageEx(Object commonMessage, BeanViewerAction<?> ... actions) {
        this.runMessageEx("", commonMessage, actions);
    }

    @Override
    public void runMessageEx(String keyView, Object commonMessage, BeanViewerAction<?> ... actions) {
        this.runMessageEx("", keyView, commonMessage, actions);
    }

    @Override
    public void runMessageEx(String keyPage, String keyView, Object commonMessage, BeanViewerAction<?> ... actions) {
        final JDialog m = new JDialog();
        m.setResizable(false);
        m.setModal(true);
        if (commonMessage instanceof CommonMessage) {
            m.setTitle(((CommonMessage)commonMessage).getTitle());
            ((CommonMessage)commonMessage).setDialog(m);
            if (!((CommonMessage)commonMessage).isCloseEnable()) {
                m.setDefaultCloseOperation(0);
            }
        }
        ViewerContext vc = new ViewerContext();
        vc.setKeyPage(keyPage);
        BeanPanel<JComponent> panel = this.createPanel(null, commonMessage.getClass(), commonMessage, null, keyView);
        panel.getPanel().setVisible(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)panel.getPanel(), "Center");
        m.setContentPane(content);
        for (int i = 0; i < actions.length; ++i) {
            final BeanViewerAction<?> bva = actions[i];
            BeanViewerAction<PanelContext> nbva = new BeanViewerAction<PanelContext>(){

                @Override
                public void actionPerformed(Object message) {
                    bva.actionPerformed(message);
                    m.setVisible(false);
                    SwingFactory.this.setLocked(false);
                }
            };
            nbva.setEnable(bva.isEnable());
            nbva.setHint(bva.getHint());
            nbva.setIcon(bva.getIcon());
            nbva.setName(bva.getName());
            bva.setContext(panel.getPanelContext());
            panel.addActionToManagementPanel(nbva);
            if (bva.getHotKey() == null) continue;
            content.getInputMap(bva.getHotKey().getConditions()).put(KeyStroke.getKeyStroke(bva.getHotKey().getKey(), bva.getHotKey().getModifier()), bva);
            content.getActionMap().put(bva, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (bva.isEnable()) {
                        bva.actionPerformed(arg0);
                        m.setVisible(false);
                        SwingFactory.this.setLocked(false);
                    }
                }
            });
        }
        UISetter<JComponent> s = null;
        m.setMinimumSize(new Dimension(400, 400));
        if (commonMessage instanceof CommonMessage) {
            if (((CommonMessage)commonMessage).isFullscrean()) {
                s = this.getCurrentPanel();
                this.setLocked(true);
                if (s != null) {
                    m.setLocationRelativeTo(((SwingPanel)s).getPanel());
                }
            } else {
                m.setMinimumSize(((CommonMessage)commonMessage).getMinSize());
                if (((CommonMessage)commonMessage).getLocation() != null) {
                    m.setLocation(((CommonMessage)commonMessage).getLocation());
                } else {
                    m.setLocationRelativeTo(null);
                }
            }
        } else {
            m.setMinimumSize(new Dimension(400, 400));
            m.setLocationRelativeTo(null);
        }
        m.pack();
        m.setVisible(true);
    }

    @Override
    protected void closeWindow(WindowMessage m) {
        ((JDialog)m.getDialog()).setVisible(false);
    }

    @Override
    public void runWindow(String keyView, WindowMessage windowMessage, String keyWindow, BeanViewerAction<?> ... actions) {
        JDialog m = new JDialog();
        m.setResizable(false);
        m.setTitle(windowMessage.getTitle());
        windowMessage.setDialog(m);
        if (!windowMessage.isCloseEnable()) {
            m.setDefaultCloseOperation(0);
        }
        this.mapWindow.put(keyWindow, windowMessage);
        BeanPanel<JComponent> panel = this.createPanel(null, windowMessage.getClass(), windowMessage, null, keyView);
        panel.getPanel().setVisible(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)panel.getPanel(), "Center");
        m.setContentPane(content);
        for (int i = 0; i < actions.length; ++i) {
            final BeanViewerAction<?> bva = actions[i];
            BeanViewerAction<PanelContext> nbva = new BeanViewerAction<PanelContext>(){

                @Override
                public void actionPerformed(Object message) {
                    bva.actionPerformed(message);
                }
            };
            nbva.setEnable(bva.isEnable());
            nbva.setHint(bva.getHint());
            nbva.setIcon(bva.getIcon());
            nbva.setName(bva.getName());
            panel.addActionToManagementPanel(nbva);
            if (bva.getHotKey() == null) continue;
            content.getInputMap(bva.getHotKey().getConditions()).put(KeyStroke.getKeyStroke(bva.getHotKey().getKey(), bva.getHotKey().getModifier()), bva);
            content.getActionMap().put(bva, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (bva.isEnable()) {
                        bva.actionPerformed(arg0);
                    }
                }
            });
        }
        Object s = null;
        m.setMinimumSize(new Dimension(400, 400));
        m.pack();
        m.setVisible(true);
    }

    @Override
    public JComponent getSplitPanel(final boolean vert, final Float dev) {
        JSplitPane c = new JSplitPane(vert ? 0 : 1){
            private static final long serialVersionUID = 2046327200341371724L;
            boolean init;
            int w;
            int h;
            {
                super(x0);
                this.init = false;
                this.w = 0;
                this.h = 0;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (!this.init || vert && this.h != this.getHeight() || !vert && this.w != this.getWidth()) {
                    super.setDividerLocation(dev.floatValue());
                    this.init = true;
                    this.h = this.getHeight();
                    this.w = this.getWidth();
                }
            }
        };
        return c;
    }

    @Override
    public JComponent getVerticalPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1"));
        return panel;
    }

    @Override
    public JComponent getTabbedPane() {
        return new JTabbedPane();
    }

    @Override
    public JComponent getScrollPane(JComponent c, boolean border) {
        JScrollPane p = new JScrollPane(c);
        if (!border) {
            p.setBorder(null);
        }
        return p;
    }

    @Override
    public void setSelectTab(JComponent tab, JComponent c) {
        ((JTabbedPane)tab).setSelectedComponent(c);
    }

    @Override
    public void hideTab(JComponent tab, JComponent c) {
        ((JTabbedPane)tab).remove(c);
    }

    @Override
    public void insertTab(JComponent tabbedPane, String s, JComponent pint) {
        ((JTabbedPane)tabbedPane).insertTab(s, null, pint, null, ((JTabbedPane)tabbedPane).getTabCount());
    }

    @Override
    public void insertTab(JComponent tabbedPane, String s, JComponent pint, int index) {
        ((JTabbedPane)tabbedPane).insertTab(s, null, pint, null, index);
    }

    @Override
    public void setCompToSplitPanel(JComponent splitPane, boolean left, JComponent pint) {
        if (left) {
            ((JSplitPane)splitPane).setLeftComponent(pint);
        } else {
            ((JSplitPane)splitPane).setRightComponent(pint);
        }
    }

    @Override
    public JComponent getProgressBar() {
        return new JProgressBar();
    }

    @Override
    public void setValueToProgressBar(JComponent progressbar, String key, String value) {
        if (key.equals("value")) {
            ((JProgressBar)progressbar).setValue(Integer.parseInt(value));
            return;
        }
        if (key.equals("maximum")) {
            ((JProgressBar)progressbar).setMaximum(Integer.parseInt(value));
            return;
        }
        if (key.equals("indeterminate")) {
            ((JProgressBar)progressbar).setIndeterminate(Boolean.parseBoolean(value));
            return;
        }
    }

    @Override
    public void setObjectToComponent(JComponent component, Object object) {
        JComboBox cb;
        if (component instanceof JComboBox && (cb = (JComboBox)component).isEditable()) {
            cb.getEditor().setItem(object);
        }
    }

    @Override
    public OutputStream browse(String type) {
        try {
            final File file = File.createTempFile("frc", "." + type);
            FileOutputStream ret = new FileOutputStream(file){

                @Override
                public void close() throws IOException {
                    super.close();
                    Desktop.getDesktop().browse(file.toURI());
                }
            };
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void setCursor(int cursor) {
        this.setCursor(cursor, "");
    }

    @Override
    public void setCursor(int cursor, String keyPage) {
        if (this.flowManagers.get(keyPage) != null) {
            this.flowManagers.get(keyPage).setCursor(cursor);
        }
    }

    @Override
    public JComponent getComboboxTuning(TunedDirectoryViewer<JComponent> listTuner) {
        TDVComboBox box = new TDVComboBox(listTuner);
        return box;
    }

    @Override
    public void setFocusOnComponent(JComponent component) {
        JComponent c = component instanceof TDVComboBox ? ((AutoSearchComboBoxEditor)((TDVComboBox)component).getEditor()).getField() : component;
        c.requestFocusInWindow();
    }

    @Override
    public void runApplication(Class<?> cls) {
        this.runApplication(cls, 0);
    }

    @Override
    public void runApplication(Class<?> cls, int MAXIMIZED) {
        try {
            if (this.getFlowManager() == null) {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                JPanel panel = new JPanel(new BorderLayout()){
                    private static final long serialVersionUID = 597332734196488830L;

                    @Override
                    public void paint(Graphics g) {
                        if (this.getComponentCount() == 0) {
                            if (g instanceof Graphics2D) {
                                Graphics2D g2d = (Graphics2D)g;
                                try {
                                    if (SwingFactory.this.splashImage == null && SwingFactory.this.getSplash() != null) {
                                        SwingFactory.this.splashImage = ImageIO.read(SwingFactory.this.getSplash().toURL());
                                    }
                                    if (SwingFactory.this.splashImage != null) {
                                        g2d.drawImage(SwingFactory.this.splashImage, (this.getWidth() - SwingFactory.this.splashImage.getWidth()) / 2, (this.getHeight() - SwingFactory.this.splashImage.getHeight()) / 2, SwingFactory.this.splashImage.getWidth(), SwingFactory.this.splashImage.getHeight(), null);
                                    }
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            super.paint(g);
                        }
                    }
                };
                frame.getContentPane().add(panel);
                OnePanelFlowManager flManager = new OnePanelFlowManager(panel, this);
                panel.setPreferredSize(new Dimension(800, 600));
                this.setFlowManager(flManager);
                this.newPage(cls, cls, cls.newInstance(), new ViewerContext(), "");
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setExtendedState(MAXIMIZED);
            } else {
                this.newPage(cls, cls, cls.newInstance(), new ViewerContext(), "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public UISetter<JComponent> getCurrentPanel() {
        return this.getCurrentPanel("");
    }

    @Override
    public UISetter<JComponent> getCurrentPanel(String keyPage) {
        if (this.flowManagers.get(keyPage) == null) {
            return null;
        }
        return this.flowManagers.get(keyPage).getCurrentPanel();
    }

    @Override
    public JComponent getSlider(int begin, int end) {
        return new JSlider(begin, end);
    }

    @Override
    public Integer getValueFromSlider(JComponent slider) {
        return ((JSlider)slider).getValue();
    }

    @Override
    public void initSlider(PSValue value, JComponent slider) {
        JSlider sl = (JSlider)slider;
        if (value.getMajor() > 0) {
            sl.setMaximum(value.getMax());
            sl.setMinimum(value.getMin());
            sl.setMinorTickSpacing(value.getMinor());
            sl.setMajorTickSpacing(value.getMajor());
            sl.setPaintTicks(true);
            sl.setLabelTable(sl.createStandardLabels(value.getMajor(), value.getMin()));
            sl.setPaintLabels(true);
            sl.setValue(value.getValue());
        }
    }

    @Override
    public void setValueToSlider(Integer value, JComponent slider) {
        if (value == null) {
            ((JSlider)slider).setValue(((JSlider)slider).getMinimum());
        }
        ((JSlider)slider).setValue(value);
    }

    @Override
    public void addHotKey(JComponent comp, final BeanViewerAction<?> bva) {
        comp.getInputMap(bva.getHotKey().getConditions()).put(KeyStroke.getKeyStroke(bva.getHotKey().getKey(), bva.getHotKey().getModifier()), bva);
        comp.getActionMap().put(bva, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (bva.isEnable() && bva.isRightForEnable()) {
                    bva.actionPerformed(arg0);
                }
            }
        });
    }

    @Override
    public LockableUI getLockableUI() {
        return this.getFlowManager().getLockableUI();
    }

    @Override
    public void setLocked(boolean locked) {
        if (this.getFlowManager() != null) {
            this.getFlowManager().setLocked(locked);
        }
    }

    @Override
    public JComponent getChartPanel(JFreeChart chart) {
        return new ChartPanelWithLine(chart);
    }

    @Override
    public boolean getToggleValue(JComponent component) {
        return ((JToggleButton)component).isSelected();
    }

    @Override
    public Object getButtonGroup() {
        return new ButtonGroup();
    }

    @Override
    public JComponent getToggleButton(final BeanViewerAction<ViewerContext> bva, final ListActionViewer<JComponent> l) {
        JToggleButton b = new JToggleButton();
        if (bva.getIcon() != null) {
            b.setIcon(new ImageIcon(this.getClass().getResource(bva.getIcon())));
        }
        if (bva.getName() != null) {
            b.setText(bva.getName());
        }
        if (bva.getHint() != null) {
            b.setToolTipText(bva.getHint());
        }
        b.setEnabled(bva.isEnable());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.setSelected();
                bva.actionPerformed(e);
            }
        });
        return b;
    }

    @Override
    public void addButtonToGroup(Object bg, JComponent button) {
        ((ButtonGroup)bg).add((AbstractButton)button);
    }

    @Override
    public UIMainProperties getDefaultMainProperties() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource orig = (FontUIResource)value;
            UIMainProperties p = new UIMainProperties();
            p.setFontName(orig.getFontName());
            p.setFontSize(orig.getSize());
            return p;
        }
        return null;
    }

    @Override
    public void setUIMainProperties(UIMainProperties mainProperties) {
        if (mainProperties != null && mainProperties.getFontName() != null) {
            int size = 12;
            if (mainProperties.getFontSize() != null) {
                size = mainProperties.getFontSize();
            }
            Font font = new Font(mainProperties.getFontName(), 0, size);
            FontUIResource f = new FontUIResource(font);
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object object = UIManager.get(key);
                if (!(object instanceof FontUIResource)) continue;
                FontUIResource orig = (FontUIResource)object;
                Font font1 = new Font(f.getFontName(), orig.getStyle(), f.getSize());
                UIManager.put(key, new FontUIResource(font1));
            }
            for (Component c : ((JFrame)this.getFlowNavigator().getFrame()).getComponents()) {
                this.sf(c, font);
            }
            for (Map.Entry entry : this.flowManagers.entrySet()) {
                List ll = ((FlowManager)entry.getValue()).getPanelsCache();
                for (JComponent l : ll) {
                    this.sf(l, font);
                }
            }
        }
    }

    private void sf(Component c, Font font) {
        c.setFont(font);
        if (c instanceof Container) {
            for (Component cc : ((Container)c).getComponents()) {
                this.sf(cc, font);
            }
            if (c instanceof JMenu) {
                this.sf(((JMenu)c).getPopupMenu(), font);
            } else if (c instanceof JTable) {
                Enumeration<TableColumn> i = ((JTable)c).getColumnModel().getColumns();
                while (i.hasMoreElements()) {
                    TableColumn tc = i.nextElement();
                    if (tc.getCellRenderer() != null && tc.getCellRenderer() instanceof ListTableRenderer) {
                        this.sf(((ListTableRenderer)tc.getCellRenderer()).getFieldViewer().getComponent(false, false), font);
                    }
                    if (tc.getCellEditor() != null && tc.getCellEditor() instanceof ListTableEditor) {
                        this.sf(((ListTableEditor)((Object)tc.getCellRenderer())).getFieldViewer().getComponent(false, false), font);
                    }
                    if (tc.getHeaderRenderer() == null || !(tc.getHeaderRenderer() instanceof MultiSortTableCellHeaderRenderer)) continue;
                    this.sf(((MultiSortTableCellHeaderRenderer)tc.getHeaderRenderer()).getLabelRotate(), font);
                }
            }
        }
    }

    @Override
    public List<JComponent> getPanelsCache() {
        return null;
    }

    @Override
    public String getPathComponent() {
        return this.flowManagers.get("").getPathComponent();
    }

    @Override
    public JComponent getCommonComponent() {
        return this.flowManagers.get("").getCommonComponent();
    }

    @Override
    public JComponent getCommonComponent(String keyPage) {
        return this.flowManagers.get(keyPage).getCommonComponent();
    }

    static {
        mapLayout = new HashMap();
        mapLayout.put("dialogLayoutManager", FourColumnLayoutManager.class);
        mapLayout.put("tabSplitPercentLayoutManager", TabSplitPercentLayoutManager.class);
        mapLayout.put("defaultLayoutManager", DefaultSwingLayoutManager.class);
        mapLayout.put("groupLayoutManager", GroupSwingLayoutManager.class);
        mapLayout.put("largeSimpleFieldsLayout", LargeSimpleFieldsLayout.class);
        mapLayout.put("testLayoutManager", TestSwingLayoutManager.class);
        panels = new HashMap();
    }

    public static class ChartPanelWithLine
    extends ChartPanel
    implements ru.infor.beanviewer.core.ChartPanel<JComponent> {
        private Integer current;
        private double xLine;
        private static final long serialVersionUID = -5196276711837043218L;

        public ChartPanelWithLine(JFreeChart chart) {
            super(chart);
        }

        @Override
        public double getXLine() {
            return this.xLine;
        }

        @Override
        public void setXLine(double xLine) {
            this.xLine = xLine;
        }

        @Override
        public Integer getCurrent() {
            return this.current;
        }

        @Override
        public void setCurrent(Integer current) {
            this.current = current;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.current != null) {
                g.setColor(Color.blue);
                Point2D.Double p2 = new Point2D.Double(this.xLine, 0.0);
                Point p = this.translateJava2DToScreen(p2);
                g.drawLine((int)p.getX(), (int)this.getScreenDataArea().getMinY(), (int)p.getX(), (int)this.getScreenDataArea().getHeight());
            }
        }

        @Override
        public double getChartXFromChartMouseEvent(ChartMouseEvent mouseChartEvent) {
            Point2D p = this.translateScreenToJava2D(mouseChartEvent.getTrigger().getPoint());
            Rectangle2D plotArea = this.getChartRenderingInfo().getPlotInfo().getDataArea();
            XYPlot plot = (XYPlot)mouseChartEvent.getChart().getPlot();
            double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
            return chartX;
        }

        @Override
        public void setStateLine(Integer i) {
            ChartRenderingInfo info = this.getChartRenderingInfo();
            Rectangle2D dataArea = info.getPlotInfo().getDataArea();
            XYPlot plot = (XYPlot)this.getChart().getPlot();
            if (plot.getDomainAxis() != null && plot.getDataset() != null) {
                int k = plot.getDataset().getItemCount(0);
                while (i >= k) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i - 1);
                }
                double x = plot.getDomainAxis().valueToJava2D(plot.getDataset().getXValue(0, i.intValue()), dataArea, plot.getDomainAxisEdge());
                this.setXLine(x);
                this.setCurrent(i);
                this.repaint();
            }
        }
    }

    public static class JUIFormattedTextField
    extends JFormattedTextField {
        private static final long serialVersionUID = -8275670779468650687L;
        public List<BeanViewerAction<ViewerContext>> list = new ArrayList<BeanViewerAction<ViewerContext>>();

        public JUIFormattedTextField(Format format) {
            super(format);
        }

        public JUIFormattedTextField() {
        }

        public JUIFormattedTextField(JFormattedTextField.AbstractFormatter f) {
            super(f);
        }

        public void addAction(BeanViewerAction<ViewerContext> bva) {
            this.list.add(bva);
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.actionPerformed(null);
            }
        }
    }

    public static class JUITextPane
    extends JTextPane {
        private static final long serialVersionUID = 7507515507088860518L;
        List<BeanViewerAction<ViewerContext>> list = new ArrayList<BeanViewerAction<ViewerContext>>();

        public void addAction(BeanViewerAction<ViewerContext> bva) {
            this.list.add(bva);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.actionPerformed(null);
            }
        }
    }

    public static class JUITextField
    extends JTextField {
        private static final long serialVersionUID = 7507515507088860518L;
        List<BeanViewerAction<ViewerContext>> list = new ArrayList<BeanViewerAction<ViewerContext>>();

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            FontMetrics ff = this.getFontMetrics(this.getFont());
            this.setPreferredSize(new Dimension(100, ff.getHeight() + 9));
        }

        public void addAction(BeanViewerAction<ViewerContext> bva) {
            this.list.add(bva);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.actionPerformed(null);
            }
        }
    }

    public static class JUIComboBox
    extends JComboBox {
        private static final long serialVersionUID = -7196881679987767885L;
        List<ActionListener> list = new ArrayList<ActionListener>();

        @Override
        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
            for (ActionListener l : this.list) {
                l.actionPerformed(null);
            }
        }

        @Override
        public void addActionListener(ActionListener l) {
            super.addActionListener(l);
            this.list.add(l);
        }

        @Override
        public void removeAllItems() {
            super.removeAllItems();
            for (ActionListener l : this.list) {
                l.actionPerformed(null);
            }
        }
    }

    public static class JLabelWithValidator
    extends JLabel {
        private static final long serialVersionUID = -2384333879468471654L;
        ValidatorListener<JComponent> validatorListener;

        public JLabelWithValidator(String string) {
            super(string);
        }

        public void addValidatorListener(ValidatorListener<JComponent> validatorListener) {
            this.validatorListener = validatorListener;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.validatorListener != null) {
                this.validatorListener.validate(this);
            }
        }
    }

    public static class JUICheckBox
    extends JCheckBox {
        private static final long serialVersionUID = -7083204622064511402L;
        private boolean f = false;

        @Override
        public void setSelected(boolean b) {
            boolean s = this.isSelected();
            super.setSelected(b);
            if (!this.f) {
                this.f = true;
                if (b == s) {
                    this.fireActionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        }
    }

    public static class OnePanelWithNavigatorFlowManager
    extends OnePanelFlowManager {
        private String path = "";

        public OnePanelWithNavigatorFlowManager(JComponent main, UIFactory<JComponent> factory) {
            super(main, factory);
        }

        @Override
        public boolean backward() {
            boolean ret = super.backward();
            this.path = this.getPath();
            this.factory.getFlowNavigator().setPath(this.path);
            return ret;
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, BeanViewerAction<?> bva) {
            super.newPage(contentClass, fieldClass, obj, vc, keyView, bva);
            this.path = this.getPath();
            this.factory.getFlowNavigator().setPath(this.path);
        }

        @Override
        public String getPathComponent() {
            return this.path;
        }

        private String getPath() {
            String ret = "";
            if (this.prevStack.isEmpty()) {
                if (this.bp != null) {
                    ret = this.bp.getTitle();
                }
            } else {
                for (BeanPanel bpl : this.prevStack) {
                    ret = ret + (ret.equals("") ? "" : " / ");
                    ret = ret + bpl.getTitle();
                }
                if (this.bp != null) {
                    ret = ret + (ret.equals("") ? "" : " / ");
                    ret = ret + this.bp.getTitle();
                }
            }
            return ret;
        }
    }

    public static class OnePanelFlowManager
    implements FlowManager<JComponent> {
        protected UIFactory<JComponent> factory;
        protected Stack<BeanPanel<JComponent>> prevStack = new Stack();
        protected BeanPanel<JComponent> bp;
        protected JXLayer<JComponent> layer;
        protected LockableUI lockableUI;
        JComponent mpane;
        protected JComponent main = new JPanel(new BorderLayout());

        public Stack<BeanPanel<JComponent>> getPrevStack() {
            return this.prevStack;
        }

        @Override
        public LockableUI getLockableUI() {
            return this.lockableUI;
        }

        @Override
        public void setLocked(boolean locked) {
            this.lockableUI.setLocked(locked);
            this.lockableUI.updateUI(this.layer);
        }

        public OnePanelFlowManager(JComponent main, UIFactory<JComponent> factory) {
            this.mpane = main;
            this.factory = factory;
            this.layer = new JXLayer((Component)this.main);
            this.lockableUI = new LockableUI(new LayerEffect[]{new BufferedImageOpEffect(new BufferedImageOp[]{new MyFilter()})});
            this.layer.setUI((LayerUI)this.lockableUI);
            this.mpane.add((Component)this.layer, "Center");
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc) {
            this.newPage(contentClass, fieldClass, obj, vc, "", null);
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView) {
            this.newPage(contentClass, fieldClass, obj, vc, keyView, null);
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, BeanViewerAction<?> bva) {
            if (this.main.getComponentCount() > 0) {
                ((JComponent)this.main.getComponent(0)).setVisible(false);
                this.prevStack.push(this.bp);
                this.main.removeAll();
            }
            this.bp = this.factory.createPanel(contentClass, fieldClass, obj, vc, keyView);
            JComponent panel = this.bp.getPanel();
            panel.setVisible(true);
            this.main.add(panel);
            ((JComponent)this.main.getComponent(0)).setVisible(true);
            this.main.revalidate();
            this.main.repaint();
            this.bp.setDefaultFocus();
            if (bva != null) {
                bva.afterShowForm(this.bp.getPanelContext());
            }
        }

        @Override
        public boolean backward() {
            if (this.main.getComponentCount() > 0) {
                ((JComponent)this.main.getComponent(0)).setVisible(false);
                this.bp.destroy();
                this.main.removeAll();
            }
            if (this.prevStack.isEmpty()) {
                return false;
            }
            this.bp = this.prevStack.pop();
            ((Component)this.bp.getPanel()).setVisible(true);
            this.main.add(this.bp.getPanel());
            this.main.revalidate();
            this.main.repaint();
            return true;
        }

        @Override
        public boolean isRoot() {
            return this.prevStack.isEmpty();
        }

        @Override
        public void setCursor(int cursor) {
            switch (cursor) {
                case 0: {
                    this.main.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.main.setCursor(Cursor.getPredefinedCursor(3));
                    break;
                }
                default: {
                    this.main.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public UISetter<JComponent> getCurrentPanel() {
            return this.bp;
        }

        @Override
        public List<JComponent> getPanelsCache() {
            Enumeration em = this.prevStack.elements();
            ArrayList<JComponent> ll = new ArrayList<JComponent>();
            while (em.hasMoreElements()) {
                BeanPanel c = (BeanPanel)em.nextElement();
                ll.add((JComponent)c.getPanel());
            }
            return ll;
        }

        @Override
        public void close() {
        }

        @Override
        public String getPathComponent() {
            return "";
        }

        @Override
        public JComponent getCommonComponent() {
            return this.mpane;
        }
    }

    public static class MyFilter
    extends ConvolveFilter {
        protected static float[] blurMatrix = new float[]{0.14285715f, 0.028571429f, 0.0f, 0.028571429f, 0.14285715f, 0.057142857f, 0.0f, 0.014285714f, 0.014285714f, 0.057142857f, 0.0f, 0.014285714f, 0.0f, 0.014285714f, 0.0f, 0.057142857f, 0.014285714f, 0.014285714f, 0.0f, 0.057142857f, 0.14285715f, 0.028571429f, 0.0f, 0.028571429f, 0.14285715f};

        public MyFilter() {
            super(5, 5, blurMatrix);
            this.setEdgeAction(CLAMP_EDGES);
        }
    }

    public static class ModalWindowFlowManager
    implements FlowManager<JComponent> {
        private UIFactory<JComponent> factory;
        private Component firstPage;
        private boolean alwaysOnTop = false;
        private Component pageContainer;
        private BeanPanel<JComponent> pageContainerpanel;
        protected JXLayer<JComponent> layer;
        protected LockableUI lockableUI;
        boolean modal = true;
        private Stack<Object> prevStack = new Stack();
        int blinkState = 0;

        public boolean isAlwaysOnTop() {
            return this.alwaysOnTop;
        }

        public void setAlwaysOnTop(boolean alwaysOnTop) {
            this.alwaysOnTop = alwaysOnTop;
        }

        public ModalWindowFlowManager(UIFactory<JComponent> factory) {
            this.factory = factory;
        }

        public ModalWindowFlowManager(UIFactory<JComponent> factory, boolean modal) {
            this.factory = factory;
            this.modal = modal;
        }

        public void currentPostion() {
            this.pageContainer.setVisible(true);
            this.pageContainer.setFocusable(true);
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView) {
            this.newPage(contentClass, fieldClass, obj, vc, keyView, null);
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc) {
            this.newPage(contentClass, fieldClass, obj, vc, "", null);
        }

        @Override
        public void newPage(Class<?> contentClass, Class<?> fieldClass, Object obj, ViewerContext vc, String keyView, final BeanViewerAction<?> bva) {
            if (this.modal) {
                this.pageContainer = new JDialog();
                ((JDialog)this.pageContainer).setAlwaysOnTop(this.alwaysOnTop);
            } else {
                this.pageContainer = new JFrame();
                ((JFrame)this.pageContainer).setAlwaysOnTop(this.alwaysOnTop);
            }
            if (this.firstPage == null) {
                this.firstPage = this.pageContainer;
            }
            this.pageContainerpanel = this.factory.createPanel(contentClass, fieldClass, obj, vc, keyView);
            this.prevStack.push(new Object[]{this.pageContainer, this.pageContainerpanel});
            JComponent panel = this.pageContainerpanel.getPanel();
            panel.setVisible(true);
            if (this.pageContainerpanel.isNotClose()) {
                if (this.modal) {
                    ((JDialog)this.pageContainer).setDefaultCloseOperation(0);
                } else {
                    ((JFrame)this.pageContainer).setDefaultCloseOperation(0);
                }
            }
            if (this.modal) {
                ((JDialog)this.pageContainer).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        pageContainerpanel.destroy();
                    }
                });
            } else {
                ((JFrame)this.pageContainer).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        pageContainerpanel.destroy();
                    }
                });
            }
            this.layer = new JXLayer((Component)panel);
            this.lockableUI = new LockableUI(new LayerEffect[]{new BufferedImageOpEffect(new BufferedImageOp[]{new MyFilter()})});
            this.layer.setUI((LayerUI)this.lockableUI);
            if (this.pageContainerpanel.getMinSize() != null) {
                this.pageContainer.setMinimumSize(this.pageContainerpanel.getMinSize());
            } else {
                this.pageContainer.setMinimumSize(new Dimension(200, 100));
            }
            if (this.pageContainerpanel.getMaxSize() != null) {
                this.pageContainer.setMaximumSize(this.pageContainerpanel.getMaxSize());
            }
            if (this.pageContainerpanel.getSize() != null) {
                this.pageContainer.setSize(this.pageContainerpanel.getSize());
            }
            if (this.modal) {
                ((JDialog)this.pageContainer).getContentPane().add((Component)this.layer);
                ((JDialog)this.pageContainer).pack();
                ((JDialog)this.pageContainer).setLocationRelativeTo(null);
                ((JDialog)this.pageContainer).setTitle((String)panel.getClientProperty("Title"));
            } else {
                ((JFrame)this.pageContainer).getContentPane().add((Component)this.layer);
                ((JFrame)this.pageContainer).pack();
                ((JFrame)this.pageContainer).setLocationRelativeTo(null);
                ((JFrame)this.pageContainer).setTitle((String)panel.getClientProperty("Title"));
            }
            if (this.pageContainerpanel.getMaxSize() != null) {
                Dimension d = this.pageContainerpanel.getMaxSize();
                String[] newD = this.pageContainer.getSize();
                if ((double)this.pageContainer.getHeight() > d.getHeight()) {
                    newD.setSize(newD.getWidth(), d.getHeight());
                }
                if ((double)this.pageContainer.getWidth() > d.getWidth()) {
                    newD.setSize(d.getWidth(), newD.getHeight());
                }
                this.pageContainer.setSize((Dimension)newD);
            }
            if (this.pageContainerpanel.getBlink() != null) {
                final ArrayList<String> titles = new ArrayList<String>();
                titles.add((String)panel.getClientProperty("Title"));
                for (String s : this.pageContainerpanel.getBlink()) {
                    titles.add(s);
                }
                int blinkInterval = 1000;
                if (this.pageContainerpanel.getBlinkInterval() != null) {
                    blinkInterval = this.pageContainerpanel.getBlinkInterval();
                }
                Timer makeItBlink = new Timer(blinkInterval, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ++blinkState;
                        if (blinkState >= titles.size()) {
                            blinkState = 0;
                        }
                        String t = (String)titles.get(blinkState);
                        if (modal) {
                            ((JDialog)pageContainer).setTitle(t);
                        } else {
                            ((JFrame)pageContainer).setTitle(t);
                        }
                    }
                });
                makeItBlink.start();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pageContainerpanel.setDefaultFocus();
                    if (bva != null) {
                        bva.afterShowForm(pageContainerpanel.getPanelContext());
                    }
                }
            });
            if (bva != null && bva.getName() != null) {
                this.pageContainerpanel.setTitle(bva.getName());
                if (this.modal) {
                    ((JDialog)this.pageContainer).setTitle(bva.getName());
                } else {
                    ((JFrame)this.pageContainer).setTitle(bva.getName());
                }
            }
            if (this.pageContainerpanel.getTitleForm() != null) {
                if (this.modal) {
                    ((JDialog)this.pageContainer).setTitle(this.pageContainerpanel.getTitleForm());
                } else {
                    ((JFrame)this.pageContainer).setTitle(this.pageContainerpanel.getTitleForm());
                }
            }
            if (this.modal) {
                ((JDialog)this.pageContainer).setModal(this.modal);
            }
            this.pageContainer.setVisible(true);
        }

        public Component getPageContainer() {
            return this.pageContainer;
        }

        @Override
        public String getPathComponent() {
            return "";
        }

        @Override
        public void close() {
            while (this.backward()) {
            }
        }

        @Override
        public boolean backward() {
            if (this.prevStack.isEmpty()) {
                return false;
            }
            Object[] o = (Object[])this.prevStack.pop();
            this.pageContainer = (Component)o[0];
            ((BeanPanel)o[1]).destroy();
            this.pageContainer.setVisible(false);
            if (!this.prevStack.isEmpty()) {
                this.pageContainer = (Component)((Object[])this.prevStack.get(this.prevStack.size() - 1))[0];
            }
            return true;
        }

        @Override
        public boolean isRoot() {
            return this.prevStack.isEmpty();
        }

        @Override
        public void setCursor(int cursor) {
            switch (cursor) {
                case 0: {
                    this.pageContainer.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.pageContainer.setCursor(Cursor.getPredefinedCursor(3));
                    break;
                }
                default: {
                    this.pageContainer.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public UISetter<JComponent> getCurrentPanel() {
            return this.pageContainerpanel;
        }

        @Override
        public LockableUI getLockableUI() {
            return this.lockableUI;
        }

        @Override
        public void setLocked(boolean locked) {
            this.lockableUI.setLocked(locked);
            this.lockableUI.updateUI(this.layer);
        }

        @Override
        public List<JComponent> getPanelsCache() {
            Enumeration em = this.prevStack.elements();
            ArrayList<JComponent> ll = new ArrayList<JComponent>();
            while (em.hasMoreElements()) {
                Object c = em.nextElement();
                Object[] cc = (Object[])c;
                ll.add((JComponent)((BeanPanel)cc[1]).getPanel());
            }
            return ll;
        }

        @Override
        public JComponent getCommonComponent() {
            return null;
        }
    }
}

