/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing;

import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JFrame;
import ru.infor.beanviewer.core.flow.FlowNavigator;

public class SwingFlowNavigator
implements FlowNavigator {
    private JFrame window;
    private String defaultTitle;

    public SwingFlowNavigator(JFrame window, String defaultTitle) {
        this.window = window;
        this.defaultTitle = defaultTitle;
        this.window.setTitle(defaultTitle);
    }

    @Override
    public void setPath(Object path) {
        if (path instanceof String) {
            if (((String)path).compareTo("") == 0) {
                this.window.setTitle(this.defaultTitle);
            } else {
                this.window.setTitle(this.truncate((String)path));
            }
        }
    }

    private String truncate(String str) {
        String res = str;
        Graphics g = this.window.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        while (fm.stringWidth(str) > this.window.getWidth() - 90) {
            String[] arr = str.split("/");
            String newres = "";
            for (int i = 1; i < arr.length; ++i) {
                if (newres != "") {
                    newres = newres + "/";
                }
                newres = newres + arr[i];
            }
            str = newres;
        }
        if (!res.equals(str)) {
            res = "..." + str;
        }
        return res;
    }

    @Override
    public Object getFrame() {
        return this.window;
    }
}

