/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.swing.CreateFieldViewerException;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class SwingPanel
extends BeanPanel<JComponent> {
    JComponent content;
    JTabbedPane jtp;
    Box management;
    private JPanel panel;

    public SwingPanel(Class<?> contentClass, Class<?> cls, Object obj, ViewerContext vc, UIFactory<JComponent> factory, String keyView) {
        super(contentClass, cls, obj, vc, factory, keyView);
    }

    @Override
    public JComponent addActionToManagementPanel(BeanViewerAction<PanelContext> a) {
        if (this.management == null) {
            this.management = Box.createHorizontalBox();
            if (this.panel != null) {
                this.panel.add((Component)this.management, "South");
            }
        }
        JComponent c = this.getFactory().getAction(a, null);
        if (this.management.getComponentCount() == 0) {
            this.management.add(Box.createGlue());
            this.management.add(c);
            this.management.add(Box.createGlue());
        } else {
            this.management.add(Box.createHorizontalStrut(4), this.management.getComponentCount() - 1);
            this.management.add((Component)c, this.management.getComponentCount() - 1);
        }
        return c;
    }

    @Override
    public FieldViewer<JComponent> addComponent(Class<?> cls, Class<? extends FieldViewer<JComponent>> view, UIGLayoutManager<JComponent> layout) throws CreateFieldViewerException {
        FieldViewer<JComponent> fv;
        try {
            fv = view.getConstructor(UIFactory.class).newInstance(this.getFactory());
        }
        catch (Exception e) {
            throw new CreateFieldViewerException(e, view);
        }
        this.fv = fv;
        if (this.content == null) {
            this.content = layout.getPanel();
        }
        layout.addComponent(this.content, fv.getComponent(false, false));
        fv.setContentClass(cls);
        return fv;
    }

    @Override
    protected void addField(final FieldPresentation<JComponent> fr, UIFactory<JComponent> factory, UIGLayoutManager<JComponent> layout) {
        if (layout == null) {
            layout = this.getFactory().getDefaultLayoutManager();
        }
        if (this.content == null) {
            this.content = layout.getPanel();
        }
        JComponent comp = layout.addField(this.content, fr);
        if (fr.getViewer().getUIPropertiesClass() != null) {
            comp.getInputMap(1).put(KeyStroke.getKeyStroke(115, 0), "editProperties");
            comp.getActionMap().put("editProperties", new AbstractAction(){
                private static final long serialVersionUID = -8896185252389473789L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object properties = fr.getViewer().getUIProperties();
                    if (properties == null) {
                        try {
                            properties = fr.getViewer().getUIPropertiesClass().newInstance();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SwingPanel.this.getFactory().newPage(fr.getViewer().getUIPropertiesClass(), fr.getViewer().getUIPropertiesClass(), properties, fr.getViewer().getViewerContext(), fr.getViewer().getUIPropertiesKeyView(), fr.getViewer().getViewerContext().getKeyPage());
                }
            });
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void hideManagementPanel() {
        if (this.panel != null) {
            this.panel.remove(this.management);
        }
    }

    @Override
    protected void init(Object obj) {
        this.obj = obj;
        this.pc.setObject(obj);
        this.panel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 3875284965523631408L;

            @Override
            public void paint(Graphics g) {
                if (!SwingPanel.this.initialized) {
                    SwingPanel.this.initialized = true;
                    SwingPanel.this.lzy_init();
                }
                try {
                    super.paint(g);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.panel.setVisible(false);
        if (this.content != null) {
            this.panel.add((Component)this.content, "Center");
            String t = this.getTitle();
            this.content.setBorder(BorderFactory.createTitledBorder(t));
            this.panel.putClientProperty("Title", t);
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't parse class " + obj.getClass());
        }
        if (this.management != null) {
            this.panel.add((Component)this.management, "South");
        }
        for (BeanViewerAction a : this.actions.keySet()) {
            if (a.getHotKey() == null) continue;
            this.getFactory().addHotKey(this.panel, a);
        }
    }

    @Override
    public boolean isVisible() {
        return this.panel != null && this.panel.isVisible();
    }

    private void lzy_init() {
        this.setObject(this.getObject() == null ? this.obj : this.getObject());
        this.storeOldValues();
    }

    @Override
    public void setDynamicTitle(String title) {
        if (this.content != null) {
            this.content.setBorder(BorderFactory.createTitledBorder(title));
        }
    }
}

