/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.swing.SwingItem;

public class GroupSwingLayoutManager
extends UIGLayoutManager<JComponent>
implements SwingItem {
    DefBox col = new DefBox(false);
    HashMap<String, DefBox> groups = new HashMap();

    public GroupSwingLayoutManager() {
        this.groups.put("root", this.col);
    }

    @Override
    public void addComponent(JComponent container, JComponent component) {
        container.add(component);
    }

    @Override
    public JComponent addField(JComponent container, FieldPresentation<JComponent> fp) {
        String[] levels = fp.getLabel().split(":");
        DefBox prev = this.groups.get("root");
        for (int i = 0; i < levels.length - 1; ++i) {
            if (!this.groups.containsKey(levels[i])) {
                DefBox curr = new DefBox(!prev.isHorizontal());
                prev.getBox().add(curr.getBox());
                this.groups.put(levels[i], curr);
            }
            prev = this.groups.get(levels[i]);
        }
        switch (fp.getViewer().getShape()) {
            case 0: {
                this.createStrut(prev);
                Box line = Box.createHorizontalBox();
                JComponent ll = fp.getViewer().getFactory().getLabelField(levels[levels.length - 1]);
                line.add(ll);
                line.add(Box.createHorizontalStrut(2));
                JComponent c = fp.getViewer().getComponent(false, false);
                line.add(c);
                prev.getBox().add(line);
                this.createStrut(prev);
                this.mapComponents.put(fp, new UIGLayoutManager.Components<JComponent>(ll, c));
                return line;
            }
            case 1: {
                this.createStrut(prev);
                JComponent label = fp.getViewer().getFactory().getLabelField(levels[levels.length - 1]);
                JPanel l = new JPanel(new BorderLayout());
                l.add((Component)label, "Before");
                prev.getBox().add(l);
                JComponent comp = fp.getViewer().getComponent(false, false);
                prev.getBox().add(comp);
                this.createStrut(prev);
                this.mapComponents.put(fp, new UIGLayoutManager.Components<JComponent>(label, comp));
                return comp;
            }
        }
        return null;
    }

    private void createStrut(DefBox prev) {
        prev.getBox().add(prev.isHorizontal() ? Box.createHorizontalStrut(3) : Box.createVerticalStrut(3));
    }

    @Override
    public JComponent getPanel() {
        return this.col.getBox();
    }

    @Override
    public boolean getComparableToOnlyOrder() {
        return false;
    }

    @Override
    public void setFocusOnComponent(FieldPresentation<JComponent> fp) {
        fp.getViewer().setFocus();
    }

    private class DefBox {
        private boolean horizontal;
        private Box box;

        public DefBox(boolean horizontal) {
            this.horizontal = horizontal;
            this.box = horizontal ? Box.createHorizontalBox() : Box.createVerticalBox();
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public Box getBox() {
            return this.box;
        }
    }
}

