/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.layout.UIGLayoutManager;
import ru.infor.beanviewer.swing.SwingItem;

public abstract class LargeSimpleFieldsLayout
extends UIGLayoutManager<JComponent>
implements SwingItem {
    private JPanel main = new JPanel(new BorderLayout());
    private JPanel simple;
    private JTabbedPane jtp;
    private JSplitPane sp = new JSplitPane(0);

    public abstract int getColumns();

    public LargeSimpleFieldsLayout() {
        this.simple = new JPanel((LayoutManager)new MigLayout("wrap " + this.getColumns() * 2, "[]5", "[]0"));
        this.sp.setLeftComponent(this.simple);
        this.main.add((Component)this.sp, "Center");
    }

    @Override
    public void addComponent(JComponent container, JComponent component) {
        container.add(component);
    }

    @Override
    public void setFocusOnComponent(FieldPresentation<JComponent> fp) {
        fp.getViewer().setFocus();
    }

    @Override
    public JComponent addField(JComponent container, FieldPresentation<JComponent> fp) {
        JComponent comp = null;
        switch (fp.getViewer().getShape()) {
            case 0: {
                JComponent label = fp.getViewer().getFactory().getLabelField(fp.getLabel());
                int g1 = 100 / (this.getColumns() * 2) / 3 * 2;
                this.simple.add((Component)label, "align right, grow " + g1);
                int g2 = 100 / (this.getColumns() * 2) / 3 * 4;
                comp = fp.getViewer().getComponent(false, false);
                this.simple.add((Component)comp, "align left, grow " + g2);
                this.mapComponents.put(fp, new UIGLayoutManager.Components<JComponent>(label, comp));
                break;
            }
            case 1: {
                if (this.jtp == null) {
                    this.jtp = new JTabbedPane();
                    this.sp.setRightComponent(this.jtp);
                }
                comp = fp.getViewer().getComponent(false, false);
                this.jtp.insertTab(fp.getLabel(), null, comp, null, this.jtp.getTabCount());
                this.mapComponents.put(fp, new UIGLayoutManager.Components<JComponent>(null, comp));
            }
        }
        return comp;
    }

    @Override
    public JComponent getPanel() {
        return this.main;
    }

    @Override
    public boolean getComparableToOnlyOrder() {
        return false;
    }
}

