/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.mapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactory;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.swing.mapviewer.MapValue;
import ru.infor.beanviewer.swing.mapviewer.MultiPainter;
import ru.infor.beanviewer.swing.mapviewer.cache.TileCacheFile;
import ru.infor.beanviewer.swing.mapviewer.ui.AbstractDefaultProviders;
import ru.infor.beanviewer.swing.mapviewer.ui.MapPropertiesUI;
import ru.infor.beanviewer.swing.mapviewer.ui.OpenStreetMapsProviders;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class MapViewer
extends FieldViewer<JComponent>
implements SwingItem {
    protected JComponent main;
    public JXMapKit map;
    protected DefaultTileFactory tf;
    protected MapValue value;
    protected MultiPainter<JXMapViewer> painter;
    protected MapPropertiesUI propertiesUI = null;
    private Class<? extends AbstractDefaultProviders> providers = null;
    private boolean wc = false;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.init();
    }

    protected MapValue getNewMapValue() {
        return new MapValue(58.0508, 38.8255, 5);
    }

    protected void init() {
        this.map = new JXMapKit();
        this.map.setAddressLocationShown(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (MapViewer.this.value == null) {
                    MapViewer.this.value = MapViewer.this.getNewMapValue();
                } else {
                    MapViewer.this.value.setLat(MapViewer.this.map.getMainMap().getCenterPosition().getLatitude());
                    MapViewer.this.value.setLon(MapViewer.this.map.getMainMap().getCenterPosition().getLongitude());
                    MapViewer.this.value.setZoom(MapViewer.this.map.getMainMap().getZoom());
                }
                MapViewer.this.map.setAddressLocation(new GeoPosition(MapViewer.this.value.getLat(), MapViewer.this.value.getLon()));
                MapViewer.this.map.setZoom(MapViewer.this.value.getZoom());
            }
        }));
        this.map.setPreferredSize(new Dimension(800, 600));
        this.main = new JPanel(new BorderLayout());
        this.main.add((Component)this.map, "Center");
        JPanel p2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 0"));
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0"));
        final JLabel st = new JLabel();
        p2.add(st);
        p.add(new JLabel(" \u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u0440\u0442\u044b "));
        JLabel l = new JLabel("<html><a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CCBYSA</a></html>");
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://creativecommons.org/licenses/by-sa/2.0/"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                st.setText("<html><font size=-2>http://creativecommons.org/licenses/by-sa/2.0/</font>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                st.setText("");
            }
        });
        p.add(l);
        p.add(new JLabel(" 2010 "));
        l = new JLabel("<html><a href=\"http://www.openstreetmap.org/\">OpenStreetMap.org</a></html>");
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.openstreetmap.org/"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                st.setText("<html><font size=-2>http://www.openstreetmap.org/</font>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                st.setText("");
            }
        });
        p.add(l);
        p2.add((Component)p, "align right");
        this.main.add((Component)p2, "South");
        this.painter = new MultiPainter();
        this.map.getMainMap().setOverlayPainter(this.painter);
        this.main.setSize(this.main.getPreferredSize());
    }

    protected void initPainter() {
    }

    @Override
    public void setKey(String key) {
        super.setKey(key);
        if (this.propertiesUI == null) {
            this.setUIProperties(this.getUIProperties());
        }
    }

    @Override
    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.main;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> arg0) {
    }

    @Override
    public int getShape() {
        return 1;
    }

    @Override
    public void setEditable(boolean arg0) {
    }

    @Override
    public void setValue(Object arg0) {
        this.value = arg0 == null ? this.getNewMapValue() : (MapValue)arg0;
        this.map.setAddressLocation(new GeoPosition(this.value.getLat(), this.value.getLon()));
        this.map.setZoom(this.value.getZoom());
        this.initPainter();
    }

    @Override
    public Object getUIProperties() {
        if (this.propertiesUI == null) {
            this.propertiesUI = new MapPropertiesUI();
            this.propertiesUI.setProviders(OpenStreetMapsProviders.class);
        }
        return this.propertiesUI;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUI.class;
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        if (viewerProperty != null) {
            try {
                this.propertiesUI = (MapPropertiesUI)viewerProperty;
                if (this.providers == null || !this.providers.equals(this.propertiesUI.getProviders())) {
                    Object val = this.getValue();
                    AbstractDefaultProviders p = this.propertiesUI.getProviders().newInstance();
                    this.tf = p.getTileFactory();
                    this.map.setTileFactory((TileFactory)this.tf);
                    this.providers = this.propertiesUI.getProviders();
                    this.setValue(val);
                }
                if (this.propertiesUI.isWithCache()) {
                    this.tf.setTileCache((TileCache)new TileCacheFile("data/TileCacheFile/"));
                } else {
                    this.tf.setTileCache(new TileCache());
                }
                this.wc = this.propertiesUI.isWithCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

