/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.mapviewer.cache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import org.jxmapviewer.viewer.TileCache;

public class TileCacheFile
extends TileCache {
    private String cachePrefix = null;

    public TileCacheFile(String cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    private File getFile(URI uri) {
        String filename = this.cachePrefix + uri.getHost() + "/" + uri.getPath() + (uri.getQuery() == null ? "" : "/" + uri.getQuery().replaceAll("=", "").replaceAll("&", "/"));
        return new File(filename);
    }

    public BufferedImage get(URI uri) throws IOException {
        File f = this.getFile(uri);
        if (f.exists()) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(f);
            }
            catch (Exception e) {
                f.delete();
            }
            return img;
        }
        return null;
    }

    public void needMoreMemory() {
    }

    public void put(URI uri, byte[] arg1, BufferedImage img) {
        File f = this.getFile(uri);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            ImageIO.write((RenderedImage)img, "png", f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

