/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;

public class ListActionViewer
extends FieldViewer<JComponent>
implements SwingItem {
    JComponent panel;
    List<BeanViewerAction<ViewerContext>> list;
    HashMap<BeanViewerAction<ViewerContext>, JComponent> map = new HashMap();
    private boolean onlyOnePressed;

    public ListActionViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.panel = new JPanel((LayoutManager)new MigLayout("insets 0 0, hidemode 2", "[]0", "[]0"));
    }

    private void setSelected() {
        for (BeanViewerAction<ViewerContext> bva : this.list) {
            if (!bva.isToggle()) continue;
            bva.setSelected(((JToggleButton)this.map.get(bva)).isSelected());
        }
    }

    private void initUI() {
        ButtonGroup bg = null;
        if (this.onlyOnePressed) {
            bg = new ButtonGroup();
        }
        this.map.clear();
        this.panel.removeAll();
        for (final BeanViewerAction<ViewerContext> bva : this.list) {
            if (bva.isToggle()) {
                JToggleButton b = new JToggleButton();
                if (bva.getIcon() != null) {
                    b.setIcon(new ImageIcon(this.getClass().getResource(bva.getIcon())));
                }
                if (bva.getName() != null) {
                    b.setText(bva.getName());
                }
                if (bva.getHint() != null) {
                    b.setToolTipText(bva.getHint());
                }
                b.setEnabled(bva.isEnable());
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListActionViewer.this.setSelected();
                        bva.actionPerformed(e);
                    }
                });
                if (this.onlyOnePressed) {
                    bg.add(b);
                }
                this.panel.add(b);
                this.map.put(bva, b);
            } else {
                JComponent component = this.getFactory().getAction(bva, null);
                this.panel.add(component);
                this.map.put(bva, component);
            }
            bva.setContext(this.getViewerContext());
        }
        this.panel.revalidate();
    }

    @Override
    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        if (this.list != null) {
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.setContext(viewerContext);
            }
        }
    }

    @Override
    public void setPropertyUI(String key, String value) {
        if ("onlyonepressed".equals(key.toLowerCase())) {
            this.onlyOnePressed = Boolean.parseBoolean(value);
        } else {
            super.setPropertyUI(key, value);
        }
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Object getValue() {
        return this.list;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setVisibleToAction(BeanViewerAction<ViewerContext> bva, boolean visible) {
        this.map.get(bva).setVisible(visible);
    }

    public void setEnableToAction(BeanViewerAction<ViewerContext> bva, boolean enable) {
        this.map.get(bva).setEnabled(enable);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        for (JComponent b : this.map.values()) {
            b.setEnabled(editable);
        }
    }

    @Override
    public void update(Object value, ActionID id) {
    }

    @Override
    public void setValue(Object object) {
        this.list = (List)object;
        this.initUI();
    }
}

