/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.core.tree.Tree;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.dragndrop.DNDTree;

public class SwingTree
implements Tree<JComponent> {
    DNDTree tree = new DNDTree();

    @Override
    public void addToSelection(List<?> obj) {
        TreePath parentPath = this.tree.getSelectionPath();
        BaseNode parent = parentPath == null ? (BaseNode)this.tree.getModel().getRoot() : (BaseNode)parentPath.getLastPathComponent();
        if (parent == null) {
            this.updateRoot(obj.get(0));
        } else {
            for (Object object : obj) {
                parent.addChild((BaseNode)object);
            }
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(parent);
    }

    @Override
    public Object getRootValue() {
        return this.tree.getModel().getRoot();
    }

    @Override
    public Object getSelected() {
        return this.tree.getSelectionPath().getLastPathComponent();
    }

    @Override
    public List<Object> getSelection() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (TreePath tp : this.tree.getSelectionPaths()) {
            ret.add(tp.getLastPathComponent());
        }
        return ret;
    }

    @Override
    public JComponent getTreeComponent() {
        return this.tree;
    }

    @Override
    public List<Object> removeSelected() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths.length > 0) {
            ArrayList<Object> removed = new ArrayList<Object>(paths.length);
            for (TreePath path : paths) {
                BaseNode obj = (BaseNode)path.getLastPathComponent();
                removed.add(obj);
                BaseNode parent = obj.getParent();
                if (parent != null) {
                    parent.removeChild(obj);
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(parent);
            }
            return removed;
        }
        return null;
    }

    @Override
    public void setChangeValueAction(final BeanViewerAction changeAction) {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                changeAction.actionPerformed(e);
            }
        });
    }

    @Override
    public void setValueAndSelect(Object value) {
        BaseNode root = (BaseNode)value;
        ArrayList<BaseNode> path = new ArrayList<BaseNode>();
        while (root != null) {
            path.add(0, root);
            BaseNode parent = root.getParent();
            if (parent == null) break;
            root = parent;
        }
        this.updateRoot(root);
        this.tree.setSelectionPath(new TreePath(path.toArray()));
        this.tree.revalidate();
    }

    @Override
    public void updateRoot(Object value) {
        DefaultTreeModel model = new DefaultTreeModel((BaseNode)value);
        this.tree.setModel(model);
    }

    @Override
    public void updateUIForSelectedObject() {
        BaseNode node;
        BaseNode parent;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (parent = (node = (BaseNode)path.getLastPathComponent()).getParent()) != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(parent);
        }
    }

    @Override
    public void addActionOnSelectionListener(final BeanViewerAction<AbstractContext<?>> bva) {
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                bva.actionPerformed(null);
            }
        });
    }

    @Override
    public void setSelection(Object value) {
    }
}

