/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.DateFormatter;
import javax.swing.text.MaskFormatter;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.DateViewer;

public class TimeFormatViewer
extends FieldViewer<JComponent>
implements SwingItem {
    protected Date date;
    protected SimpleDateFormat realFormat = null;
    JPanel panel = (JPanel)this.getFactory().getPanel();
    private BeanViewerAction<ViewerContext> buttonClear;
    JButton button;
    SwingFactory.JUIFormattedTextField field;
    Calendar calendar = Calendar.getInstance();

    public TimeFormatViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.setPropertyField("format", "HH:mm:ss");
        this.buttonClear = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                TimeFormatViewer.this.setValue(null);
            }
        };
        this.buttonClear.setName("X");
        this.buttonClear.setHint("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        this.button = this.getFactory().getAction(this.buttonClear, this.button);
        this.getFactory().putObjectToContainer((JPanel)((Object)this.button), this.panel, "width 42, height 22:22:22");
    }

    @Override
    public Class getTableCellViewerClass() {
        return DateViewer.class;
    }

    @Override
    public void setFocus() {
        this.getFactory().setFocusOnComponent(this.field);
        this.field.getCaret().setDot(0);
    }

    private void initField(String format) {
        try {
            String ff = format.replaceAll("H|h|m|s|S", "#");
            MaskFormatter f = new MaskFormatter(ff);
            f.setPlaceholderCharacter('_');
            this.field = new SwingFactory.JUIFormattedTextField(f);
            this.setEditable(this.isEditable());
            this.panel.removeAll();
            this.getFactory().setPropertyToComponent("minsize", "40x22", this.field);
            this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.field);
            this.getFactory().putObjectToContainer((JPanel)((Object)this.field), this.panel, "growx");
            if (this.button != null) {
                this.getFactory().putObjectToContainer((JPanel)((Object)this.button), this.panel, "width 42:42:42, height 22:22:22");
            }
            this.field.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String s = TimeFormatViewer.this.getFactory().getTextFromComponent(TimeFormatViewer.this.field);
                        if (!s.isEmpty()) {
                            TimeFormatViewer.this.realFormat.setLenient(false);
                            TimeFormatViewer.this.realFormat.parse(s);
                        }
                    }
                    catch (Exception e1) {
                        TimeFormatViewer.this.getFactory().runMessageEx(new ErrorMessage("\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f"), new MessageOKButton());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private Date getDefaultValue() {
        this.calendar.setTime(new Date());
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("format")) {
            this.realFormat = new SimpleDateFormat(value);
            this.realFormat.setLenient(false);
            this.initField(value);
        }
        super.setPropertyField(key, value);
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Object getValue() {
        try {
            if (this.getFactory().getTextFromComponent(this.field).isEmpty()) {
                return null;
            }
            this.calendar.setTime(this.date);
            Calendar c2 = Calendar.getInstance();
            c2.setTime((Date)new DateFormatter(this.realFormat).stringToValue(this.getFactory().getTextFromComponent(this.field)));
            this.calendar.set(11, c2.get(11));
            this.calendar.set(12, c2.get(12));
            this.calendar.set(13, c2.get(13));
            this.calendar.set(14, c2.get(14));
            this.date = this.calendar.getTime();
            this.setValue(this.date);
        }
        catch (Exception e) {
            this.setValue(this.date);
        }
        return this.date;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.getFactory().setComponentEditable(this.field, editable);
        this.getFactory().setComponentEditable(this.button, editable);
    }

    @Override
    public void setValue(Object object) {
        this.date = object == null ? this.getDefaultValue() : (Date)object;
        try {
            this.getFactory().setTextToComponent(this.field, new DateFormatter(this.realFormat).valueToString(this.date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponent(this.field, changeAction);
        this.getFactory().addActionToComponent(this.button, changeAction);
    }

    @Override
    public void setChangeValueActionOnEnter(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponentOnEnter(this.field, changeAction);
    }
}

