/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.checkbox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class CheckBox3State
extends JCheckBox {
    private static final long serialVersionUID = 1420599648869639767L;
    private final TristateDecorator model;

    public CheckBox3State(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CheckBox3State.this.grabFocus();
                CheckBox3State.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 4756953448259148444L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBox3State.this.grabFocus();
                CheckBox3State.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public CheckBox3State(String text, State initial) {
        this(text, null, initial);
    }

    public CheckBox3State(String text) {
        this(text, State.PARTIAL);
    }

    public CheckBox3State() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(State.CHECKED);
        } else {
            this.setState(State.UNCHECKED);
        }
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == State.UNCHECKED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == State.CHECKED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.CHECKED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.PARTIAL;
            }
            return State.UNCHECKED;
        }

        private void nextState() {
            State current = this.getState();
            if (current == State.UNCHECKED) {
                this.setState(State.CHECKED);
            } else if (current == State.CHECKED) {
                this.setState(State.PARTIAL);
            } else if (current == State.PARTIAL) {
                this.setState(State.UNCHECKED);
            }
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            CheckBox3State.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static enum State {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }
}

