/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.directory;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import ru.infor.beanviewer.viewer.directory.AutoSearchComboBoxEditor;
import ru.infor.beanviewer.viewer.directory.AutoSearchComboBoxModel;
import ru.infor.beanviewer.viewer.directory.AutoSearchField;
import ru.infor.beanviewer.viewer.directory.CBUI;
import ru.infor.beanviewer.viewer.directory.ListTuner;
import ru.infor.beanviewer.viewer.directory.TunedDirectoryViewer;
import ru.infor.beanviewer.viewer.directory.TuningCombobox;

public class TDVComboBox
extends JComboBox
implements TuningCombobox {
    AutoSearchComboBoxEditor editor;
    private boolean init = false;
    private ListTuner<JComponent> l;
    private static final long serialVersionUID = 1412536376444887700L;

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (this.getEditor() != null && this.getEditor() instanceof AutoSearchComboBoxEditor) {
            ((AutoSearchComboBoxEditor)this.getEditor()).setEditable(flag);
        }
    }

    public TDVComboBox(final TunedDirectoryViewer<JComponent> l) {
        this.l = l;
        this.setPrototypeDisplayValue("******************");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), "update");
        this.getActionMap().put("update", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.clearCache();
            }
        });
        this.setUI(new CBUI());
        this.setPopupVisible(false);
        this.setEditable(true);
        this.putClientProperty("JComboBox.isTableCellEditor", l.isTableField());
        AutoSearchComboBoxModel model = new AutoSearchComboBoxModel(l, this);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                l.canReadTunedValues = true;
            }
        });
        this.setModel(model);
        this.editor = new AutoSearchComboBoxEditor(model);
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                l.canReadTunedValues = true;
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        this.editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.changeActionAllPerformed(e);
            }
        });
        this.setEditor(this.editor);
        this.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (l.getContentClass().isAssignableFrom(value.getClass())) {
                    return super.getListCellRendererComponent((JList<?>)list, l.objectToString(value), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                l.changeActionAllPerformed(arg0);
            }
        });
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                AutoSearchField a;
                if (arg0.getOppositeComponent() instanceof JScrollPane && ((JScrollPane)arg0.getOppositeComponent()).getViewport().getComponent(0) instanceof AutoSearchField && TDVComboBox.this.editor.equals((a = (AutoSearchField)((JScrollPane)arg0.getOppositeComponent()).getViewport().getComponent(0)).getEditor())) {
                    return;
                }
                l.changeActionAllPerformed(arg0);
            }
        });
    }

    @Override
    public void addChangeListener(boolean always) {
        if (!this.init) {
            this.init = true;
            if (always) {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((TunedDirectoryViewer)TDVComboBox.this.l).changeActionAllPerformed(e);
                    }
                });
            } else {
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        ((TunedDirectoryViewer)TDVComboBox.this.l).changeActionAllPerformed(e);
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }
                });
            }
        }
    }

    @Override
    public String getText() {
        return ((AutoSearchComboBoxEditor)this.getEditor()).getField().getText();
    }

    @Override
    public int getSelectedIndex() {
        if (this.l != null) {
            return this.l.getIndex(this.getSelectedItem());
        }
        return -1;
    }
}

